package com.ejianc.business.equipment.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.equipment.hystrix.EquipmentContractHystrix;
import com.ejianc.business.finance.pub.api.IPubContractApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 获取合同参照工厂类方法
 * 
 * @author yqls
 *
 */
@FeignClient(name= "ejc-equipment-web", url="${common.env.feign-client-url}", path="ejc-equipment-web", fallback = EquipmentContractHystrix.class)
public interface IEquipmentContractApi extends IPubContractApi {

	/**
	 * 根据条件查询不同合同类型的合同
	 * @param queryParam
	 * @return
	 */
	@Override
	@PostMapping(value = "/api/equipment/getContract")
	public CommonResponse<JSONObject> getContract(@RequestBody QueryParam queryParam);

	/**
	 * 根据条件查询不同合同类型的合同结算
	 * @param queryParam
	 * @return
	 */
	@Override
	@PostMapping(value = "/api/equipment/getContractSettle")
	public CommonResponse<JSONObject> getContractSettle(@RequestBody QueryParam queryParam);

	/**
	 * 根据条件查询不同合同类型的合同结算
	 * @param queryParam
	 * @return
	 */
	@PostMapping(value = "/api/equipment/getRentSettle")
	public CommonResponse<JSONObject> getRentSettle(@RequestBody QueryParam queryParam);
	
}
