package com.ejianc.business.equipment.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.equipment.hystrix.EquipmentContractHystrix;
import com.ejianc.business.finance.pub.api.IPubContractApi;
import com.ejianc.business.tax.pub.api.IPubInvoiceReceiveApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

/**
 * 获取合同参照工厂类方法
 * 
 * @author yqls
 *
 */
@FeignClient(name= "ejc-equipment-web", url="${common.env.feign-client-url}", path="ejc-equipment-web", fallback = EquipmentContractHystrix.class)
public interface IEquipmentContractApi extends IPubContractApi,IPubInvoiceReceiveApi {

	/**
	 * 根据条件查询不同合同类型的合同
	 * @param queryParam
	 * @return
	 */
	@Override
	@PostMapping(value = "/api/equipment/getContract")
	public CommonResponse<JSONObject> getContract(@RequestBody QueryParam queryParam);

	/**
	 * 根据条件查询不同合同类型的合同结算
	 * @param queryParam
	 * @return
	 */
	@Override
	@PostMapping(value = "/api/equipment/getContractSettle")
	public CommonResponse<JSONObject> getContractSettle(@RequestBody QueryParam queryParam);

	/**
	 * 根据条件查询不同合同类型的合同结算
	 * @param queryParam
	 * @return
	 */
	@PostMapping(value = "/api/equipment/getRentSettle")
	public CommonResponse<JSONObject> getRentSettle(@RequestBody QueryParam queryParam);

	/**
	 * 更新设备采购合同累计付款金额、累计预付款金额
	 * @param contractId
	 * @param payMny
	 * @param prepayMny
	 * @return
	 */
	@GetMapping(value = "/api/equipment/updatePurchaseContractSumPayMny")
	CommonResponse<String> updatePurchaseContractSumPayMny(@RequestParam(value="contractId", required=true) Long contractId,
			@RequestParam("payMny") BigDecimal payMny, @RequestParam("prepayMny") BigDecimal prepayMny);

	/**
	 * 更新设备租赁合同累计付款金额、累计预付款金额
	 * @param contractId
	 * @param payMny
	 * @param prepayMny
	 * @return
	 */
	@GetMapping(value = "/api/equipment/updateRentContractSumPayMny")
	CommonResponse<String> updateRentContractSumPayMny(@RequestParam(value="contractId", required=true) Long contractId,
			@RequestParam("payMny") BigDecimal payMny, @RequestParam("prepayMny") BigDecimal prepayMny);

	/**
	 * 更新设备采购结算单累计付款金额
	 * @param settleId
	 * @param payMny
	 * @return
	 */
	@GetMapping(value = "/api/equipment/updatePurchaseSettleSumPayMny")
	CommonResponse<String> updatePurchaseSettleSumPayMny(@RequestParam(value="settleId", required=true) Long settleId,
			@RequestParam("payMny") BigDecimal payMny);

	/**
	 * 更新设备租赁结算单累计付款金额
	 * @param settleId
	 * @param payMny
	 * @return
	 */
	@GetMapping(value = "/api/equipment/updateRentSettleSumPayMny")
	CommonResponse<String> updateRentSettleSumPayMny(@RequestParam(value="settleId", required=true) Long settleId,
			@RequestParam("payMny") BigDecimal payMny);

	@Override
	@PostMapping(value = "/api/equipment/afterApproveInvoiceReceive")
	CommonResponse<String> afterApproveInvoiceReceive(Long contractId, BigDecimal invoiceMny, BigDecimal invoiceTaxMny);

	@Override
	@PostMapping(value = "/api/equipment/afterRevocationInvoiceReceive")
	CommonResponse<JSONObject> afterRevocationInvoiceReceive(Long contractId, BigDecimal invoiceMny, BigDecimal invoiceTaxMny);
}
