package com.ejianc.business.equipment.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 设备合同变更记录
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
public class SupplementRentContractRecordVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 合同主键
     */
    private Long contractId;

    /**
     * 合同金额
     */
    private BigDecimal contractTaxMny;

    /**
     * 初始版本金额
     */
    private BigDecimal baseTaxMoney;

    /**
     * 累计变更金额
     */
    private BigDecimal sumChangeMny;

    /**
     * 累计变更率
     */
    private BigDecimal sumScale;

    // 设备明细子表
    private List<SupplementRentContractVO> supplementRecord = new ArrayList<SupplementRentContractVO>();

    private Integer settlementType;

    public Integer getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getSumChangeMny() {
        return sumChangeMny;
    }

    public void setSumChangeMny(BigDecimal sumChangeMny) {
        this.sumChangeMny = sumChangeMny;
    }

    public BigDecimal getSumScale() {
        return sumScale;
    }

    public void setSumScale(BigDecimal sumScale) {
        this.sumScale = sumScale;
    }

    public List<SupplementRentContractVO> getSupplementRecord() {
        return supplementRecord;
    }

    public void setSupplementRecord(List<SupplementRentContractVO> supplementRecord) {
        this.supplementRecord = supplementRecord;
    }
}
