package com.ejianc.business.equipment.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 设备合同表
 * </p>
 *
 * @author yqls
 * @since 2020-06-09
 */
public class RentRecordVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 原合同主键
     */
    private Long contractId;
    private String contractName;

    /**
     * 合同编码
     */
    private String billCode;

    /**
     * 组织主键
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 项目主键
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 总包企业主键
     */
    private Long customerId;

    /**
     * 总包企业名称
     */
    private String customerName;

    /**
     * 设备供应商主键
     */
    private Long supplierId;

    /**
     * 设备供应商名称
     */
    private String supplierName;

    /**
     * 签约日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 合同税率
     */
    private BigDecimal taxRate;

    /**
     * 合同支付比例
     */
    private BigDecimal payScale;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    private String contractStatus;

    /**
     * 备注
     */
    private String memo;

    /**
     * 合同金额(含税)
     */
    private BigDecimal contractTaxMny;

    /**
     * 税金
     */
    private BigDecimal taxMny;

    /**
     * 合同金额(不含税)
     */
    private BigDecimal contractMny;

    /**
     * 单据状态（审批必须字段）
     */
    private Integer billState;

    /**
     * 变更版本
     */
    private Integer changeVersion;

    /**
     * 变更主键
     */
    private Long changeId;

    /**
     * 变更编号
     */
    private String changeCode;

    /**
     * 初始版本金额（不含税）
     */
    private BigDecimal baseMoney;

    /**
     * 初始版本金额
     */
    private BigDecimal baseTaxMoney;

    /**
     * 变更前金额（不含税）
     */
    private BigDecimal beforeChangeMny;

    /**
     * 变更前金额
     */
    private BigDecimal beforeChangeTaxMny;

    /**
     * 变更中金额(不含税)
     */
    private BigDecimal changingMny;

    /**
     * 变更中金额
     */
    private BigDecimal changingTaxMny;

    /**
     * 变更状态1-未变更 2-变更中 3-已变更
     */
    private Integer changeStatus;

    /**
     * 累计预付款金额
     */
    private BigDecimal sumPrepayMny;

    /**
     * 累计付款金额
     */
    private BigDecimal sumPayMny;

    /**
     * 累计冲抵金额
     */
    private BigDecimal sumOffsetMny;

    /**
     * 累计结算金额(不含税)
     */
    private BigDecimal sumSettlementMny;

    /**
     * 累计结算金额
     */
    private BigDecimal sumSettlementTaxMny;

    /**
     * 累计收票金额(不含税)
     */
    private BigDecimal sumInvoiceMny;

    /**
     * 累计收票金额
     */
    private BigDecimal sumInvoiceTaxMny;
    // 设备明细子表
    private List<RentRecordDetailVO> rentdetail = new ArrayList<RentRecordDetailVO>();

    // 合同条款子表
    private List<RentRecordClauseVO> rentclause = new ArrayList<RentRecordClauseVO>();

    // 其他费用子表
    private List<RentRecordFeeVO> rentfee = new ArrayList<RentRecordFeeVO>();

    // 付款阶段子表
    private List<RentRecordStageVO> rentstage = new ArrayList<>();

    private Integer settlementType;

    private Long mainContractId; // 主合同ID
    private String mainContractCode; // 主合同编码
    private String mainContractName; // 主合同编码
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public Integer getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }

    public List<RentRecordStageVO> getRentstage() {
        return rentstage;
    }

    public void setRentstage(List<RentRecordStageVO> rentstage) {
        this.rentstage = rentstage;
    }

    /**
     * 变更原因
     */
    private String changeReason;

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public List<RentRecordDetailVO> getRentdetail() {
        return rentdetail;
    }

    public void setRentdetail(List<RentRecordDetailVO> rentdetail) {
        this.rentdetail = rentdetail;
    }

    public List<RentRecordClauseVO> getRentclause() {
        return rentclause;
    }

    public void setRentclause(List<RentRecordClauseVO> rentclause) {
        this.rentclause = rentclause;
    }

    public List<RentRecordFeeVO> getRentfee() {
        return rentfee;
    }

    public void setRentfee(List<RentRecordFeeVO> rentfee) {
        this.rentfee = rentfee;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }
    public String getMemo() {
        return memo;
    }

    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public BigDecimal getSumPrepayMny() {
        return sumPrepayMny;
    }

    public void setSumPrepayMny(BigDecimal sumPrepayMny) {
        this.sumPrepayMny = sumPrepayMny;
    }
    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }
    public BigDecimal getSumOffsetMny() {
        return sumOffsetMny;
    }

    public void setSumOffsetMny(BigDecimal sumOffsetMny) {
        this.sumOffsetMny = sumOffsetMny;
    }
    public BigDecimal getSumSettlementMny() {
        return sumSettlementMny;
    }

    public void setSumSettlementMny(BigDecimal sumSettlementMny) {
        this.sumSettlementMny = sumSettlementMny;
    }
    public BigDecimal getSumSettlementTaxMny() {
        return sumSettlementTaxMny;
    }

    public void setSumSettlementTaxMny(BigDecimal sumSettlementTaxMny) {
        this.sumSettlementTaxMny = sumSettlementTaxMny;
    }
    public BigDecimal getSumInvoiceMny() {
        return sumInvoiceMny;
    }

    public void setSumInvoiceMny(BigDecimal sumInvoiceMny) {
        this.sumInvoiceMny = sumInvoiceMny;
    }
    public BigDecimal getSumInvoiceTaxMny() {
        return sumInvoiceTaxMny;
    }

    public void setSumInvoiceTaxMny(BigDecimal sumInvoiceTaxMny) {
        this.sumInvoiceTaxMny = sumInvoiceTaxMny;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    @ReferSerialTransfer(referCode="support-customer")
    public Long getCustomerId() {
        return customerId;
    }

    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
}
