package com.ejianc.business.equipment.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 设备使用申请表
 * </p>
 *
 * @author yqls
 * @since 2020-06-06
 */
public class ApplyVO extends BaseVO {

    private static final long serialVersionUID = 2779265683222439571L;

    /**
     * 申请单编码
     */
    private String billCode;
    private String name;

    /**
     * 项目
     */
    private Long projectId;
    private Long parentId;

    /**
     * 计划日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planDate;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 备注
     */
    private String memo;

    /**
     * 单据状态（审批必须字段）
     */
    private Integer billState;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 项目名称
     */
    private String projectName;
    private String billStateName;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 机械设备名称合集
     */
    private String equipmentName;

    // 设备明细子表
    private List<ApplyDetailVO> applyDetail = new ArrayList<ApplyDetailVO>();

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public List<ApplyDetailVO> getApplyDetail() {
        return applyDetail;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setApplyDetail(List<ApplyDetailVO> applyDetail) {
        this.applyDetail = applyDetail;
    }

    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
