package com.ejianc.business.equipment.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * <p>
 * 其他费用
 * </p>
 *
 * @author yqls
 * @since 2020-06-10
 */
@TableName("ejc_equipment_rent_settlement_fee")
public class RentSettlementFeeVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 结算主键
     */
    private Long settlementId;

    /**
     * 费用类型
     */
    private String feeType;

    /**
     * 金额
     */
    private BigDecimal feemoney;

    /**
     * 备注
     */
    private String memo;
    /**
     * 使用记录主表主键
     */
    private Long useId;
    /**
     * 来源
     */
    private String source;
    /**
     * 成本科目主键
     */
    private Long subjectId;
    /**
     * 成本科目名称
     */
    private String subjectName;

    /**
     * 税率
     */
    private BigDecimal freeTaxRate;

    /**
     * 金额（含税）
     */
    private BigDecimal taxMoney;

    public BigDecimal getFreeTaxRate() {
        return freeTaxRate;
    }

    public void setFreeTaxRate(BigDecimal freeTaxRate) {
        this.freeTaxRate = freeTaxRate;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    @ReferSerialTransfer(referCode="cost-subject-set")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getUseId() {
        return useId;
    }

    public void setUseId(Long useId) {
        this.useId = useId;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    public String getFeeType() {
        return feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public BigDecimal getFeemoney() {
        return feemoney;
    }

    public void setFeemoney(BigDecimal feemoney) {
        this.feemoney = feemoney;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }


}
