package com.ejianc.business.equipment.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * <p>
 * 设备明细
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
public class PurchaseSettlementDetailVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 结算表主键
     */
    private Long settlementId;

    /**
     * 设备档案主键
     */
    private Long equipmentId;

    /**
     * 合同明细主键
     */
    private Long contractDetailId;

    /**
     * 来源类型 1-设备档案，2-合同
     */
    private Integer source;

    /**
     * 设备编码
     */
    private String code;

    /**
     * 设备名称
     */
    private String name;

    /**
     * 规格型号
     */
    private String spec;

    /**
     * 计量单位名称
     */
    private String unitName;

    /**
     * 单价
     */
    private BigDecimal price;

    /**
     * 数量
     */
    private BigDecimal num;

    /**
     * 金额
     */
    private BigDecimal money;

    /**
     * 本期结算金额
     */
    private BigDecimal settlementMny;


    /**
     * 备注
     */
    private String memo;
    /**
     * 成本科目主键
     */
    private Long subjectId;
    /**
     * 成本科目名称
     */
    private String subjectName;

    /**
     * 单价(含税)
     */
    private BigDecimal taxPrice;

    /**
     * 税率
     */
    private BigDecimal detaiTaxRate;

    /**
     * 金额（含税）
     */
    private BigDecimal taxMoney;

    /**
     * 税额
     */
    private BigDecimal tax;

    /**
     * 本期结算金额(含税)
     */
    private BigDecimal settlementTaxMny;

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getDetaiTaxRate() {
        return detaiTaxRate;
    }

    public void setDetaiTaxRate(BigDecimal detaiTaxRate) {
        this.detaiTaxRate = detaiTaxRate;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getSettlementTaxMny() {
        return settlementTaxMny;
    }

    public void setSettlementTaxMny(BigDecimal settlementTaxMny) {
        this.settlementTaxMny = settlementTaxMny;
    }

    @ReferSerialTransfer(referCode="cost-subject-set")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }

    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
