package com.ejianc.business.equipment.api;

import com.ejianc.business.equipment.hystrix.EquipmentWarnHystrix;
import com.ejianc.business.equipment.vo.warn.EquipmentWarnVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name= "ejc-equipment-web", url="${common.env.feign-client-url}", path="ejc-equipment-web", fallback = EquipmentWarnHystrix.class)
public interface IEquipmentWarnApi {

    /**
     * 租户下，按照项目分类，支出合同累计金额-设备租赁，设备采购合同累计
     * @param tenantIds
     * @return
     */
    @PostMapping(value = "/api/equipmentApi/equipmentProjectOutMny")
    CommonResponse<List<EquipmentWarnVo>> equipmentProjectOutMny(@RequestParam("tenantIds") List<Long> tenantIds);
}
