package com.ejianc.business.equipment.api;

import com.ejianc.business.equipment.hystrix.SettlementHystrix;
import com.ejianc.business.equipment.vo.SettlementVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * 获取合同参照工厂类方法
 *
 * @author yqls
 */
@FeignClient(name = "ejc-equipment-web", url = "${common.env.feign-client-url}", path = "ejc-equipment-web", fallback = SettlementHystrix.class)
public interface ISettlementApi {
    /**
     * 根据条件查询结算单累计冲抵金额
     *
     * @return
     */
    @GetMapping(value = "/api/equipment/getPurchaseSettlementById")
    public CommonResponse<SettlementVO> getPurchaseSettlementById(@RequestParam(value = "contractId", required = true) Long contractId, @RequestParam(value = "orgId", required = true) Long orgId);

    /**
     * 根据条件查询结算单累计冲抵金额
     *
     * @return
     */
    @GetMapping(value = "/api/equipment/getRentSettlementById")
    public CommonResponse<SettlementVO> getRentSettlementById(@RequestParam(value = "contractId", required = true) Long contractId, @RequestParam(value = "orgId", required = true) Long orgId);

    /**
     * @Author mrsir_wxp
     * @Date 2021/5/13 根据 项目ids查询累计结算(含税)  包括设备采购结算和租赁结算
     * @Description querySubSettleMoneyByTypeAndProjectIds
     * @Param [param]
     * projectId 该类项目id集合
     * @Return com.ejianc.framework.core.response.CommonResponse<java.math.BigDecimal>
     */
    @RequestMapping(value = "/api/equipment/querySubSettleMoneyByTypeAndProjectIds", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<BigDecimal> querySubSettleMoneyByTypeAndProjectIds(@RequestBody QueryParam param);


    /***
     * @description: 获取设备结算金额，项目维度
     * @param projectIds
     * @return: com.ejianc.framework.core.response.CommonResponse<java.math.BigDecimal>
     * @author songlx
     * @date: 2021/10/25
     */
    @RequestMapping(value = "/api/equipment/getSettleMny", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<SettlementVO>> getSettleMny(@RequestParam("projectIds") List<Long> projectIds);
}
