package com.ejianc.business.equipment.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 设备合结算记录
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
public class RentSettlementRecordVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 合同主键
     */
    private Long contractId;

    /**
     * 合同金额
     */
    private BigDecimal contractTaxMny;

    /**
     * 累计结算金额(不含税)
     */
    private BigDecimal sumSettlementMny;

    /**
     * 累计结算金额
     */
    private BigDecimal sumSettlementTaxMny;

    /**
     * 累计结算比例
     */
    private BigDecimal sumScale;

    // 采购合同结算表
    private List<RentSettlementVO> settlementRecord = new ArrayList<RentSettlementVO>();

    private String contractStatus;

    private Integer changeStatus;



    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getSumSettlementMny() {
        return sumSettlementMny;
    }

    public void setSumSettlementMny(BigDecimal sumSettlementMny) {
        this.sumSettlementMny = sumSettlementMny;
    }

    public BigDecimal getSumSettlementTaxMny() {
        return sumSettlementTaxMny;
    }

    public void setSumSettlementTaxMny(BigDecimal sumSettlementTaxMny) {
        this.sumSettlementTaxMny = sumSettlementTaxMny;
    }

    public BigDecimal getSumScale() {
        return sumScale;
    }

    public void setSumScale(BigDecimal sumScale) {
        this.sumScale = sumScale;
    }

    public List<RentSettlementVO> getSettlementRecord() {
        return settlementRecord;
    }

    public void setSettlementRecord(List<RentSettlementVO> settlementRecord) {
        this.settlementRecord = settlementRecord;
    }
}
