package com.ejianc.business.equipment.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.equipment.hystrix.EquipmentContractHystrix;
import com.ejianc.business.equipment.vo.EquipmentReportVo;
import com.ejianc.business.equipment.vo.RentUseRecordVO;
import com.ejianc.business.finance.pub.api.IPubContractApi;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * 获取合同参照工厂类方法
 * 
 * @author yqls
 *
 */
@FeignClient(name= "ejc-equipment-web", url="${common.env.feign-client-url}", path="ejc-equipment-web", fallback = EquipmentContractHystrix.class)
public interface IEquipmentContractApi extends IPubContractApi {

	/**
	 * 根据条件查询不同合同类型的合同
	 * @param queryParam
	 * @return
	 */
	@Override
	@PostMapping(value = "/api/equipment/getContract")
	public CommonResponse<JSONObject> getContract(@RequestBody QueryParam queryParam);

	/**
	 * 根据条件查询不同合同类型的合同结算
	 * @param queryParam
	 * @return
	 */
	@Override
	@PostMapping(value = "/api/equipment/getContractSettle")
	public CommonResponse<JSONObject> getContractSettle(@RequestBody QueryParam queryParam);

	/**
	 * 根据条件查询不同合同类型的合同结算
	 * @param queryParam
	 * @return
	 */
	@PostMapping(value = "/api/equipment/getRentSettle")
	public CommonResponse<JSONObject> getRentSettle(@RequestBody QueryParam queryParam);

	/**
	 * 回写设备采购合同累计付款金额、累计预付款金额
	 * @param contractId
	 * @param payMny	本期支付金额，正为回写，负为逆回写
	 * @param prepayMny	本期支付金额，正为回写，负为逆回写
	 * @return
	 */
	@GetMapping(value = "/api/equipment/updatePurchaseContractSumPayMny")
	CommonResponse<String> updatePurchaseContractSumPayMny(@RequestParam(value="contractId", required=true) Long contractId,
			@RequestParam("payMny") BigDecimal payMny, @RequestParam("prepayMny") BigDecimal prepayMny);

	/**
	 * 回写设备租赁合同累计付款金额、累计预付款金额
	 * @param contractId
	 * @param payMny 本期支付金额，正为回写，负为逆回写
	 * @param prepayMny 本期预付款金额，正为回写，负为逆回写
	 * @return
	 */
	@GetMapping(value = "/api/equipment/updateRentContractSumPayMny")
	CommonResponse<String> updateRentContractSumPayMny(@RequestParam(value="contractId", required=true) Long contractId,
			@RequestParam("payMny") BigDecimal payMny, @RequestParam("prepayMny") BigDecimal prepayMny);

	/**
	 * 回写设备采购结算单累计付款金额
	 * @param settleId 结算单id
	 * @param payMny 本期支付金额，正为回写，负为逆回写
	 * @return
	 */
	@GetMapping(value = "/api/equipment/updatePurchaseSettleSumPayMny")
	CommonResponse<String> updatePurchaseSettleSumPayMny(@RequestParam(value="settleId", required=true) Long settleId,
														 @RequestParam("payMny") BigDecimal payMny);

	/**
	 * 回写设备租赁结算单累计付款金额
	 * @param settleId 结算单id
	 * @param payMny 本期支付金额，正为回写，负为逆回写
	 * @return
	 */
	@GetMapping(value = "/api/equipment/updateRentSettleSumPayMny")
	CommonResponse<String> updateRentSettleSumPayMny(@RequestParam(value="settleId", required=true) Long settleId,
													 @RequestParam("payMny") BigDecimal payMny);

	/**
	 * 回写设备采购结算单累计申请金额、剩余可申请金额
	 * @param settleId 结算单id
	 * @param applyMny 本期申请金额，正为回写，负为逆回写
	 * @return
	 */
	@GetMapping(value = "/api/equipment/updatePurchaseSettleSumApplyMny")
	CommonResponse<String> updatePurchaseSettleSumApplyMny(@RequestParam(value="settleId", required=true) Long settleId,
			@RequestParam("applyMny") BigDecimal applyMny);

	/**
	 * 回写设备租赁结算单累计申请金额、剩余可申请金额
	 * @param settleId 结算单id
	 * @param applyMny 本期申请金额，正为回写，负为逆回写
	 * @return
	 */
	@GetMapping(value = "/api/equipment/updateRentSettleSumApplyMny")
	CommonResponse<String> updateRentSettleSumApplyMny(@RequestParam(value="settleId", required=true) Long settleId,
			@RequestParam("applyMny") BigDecimal applyMny);

	@PostMapping(value = "/api/equipment/afterApproveInvoiceReceive")
	CommonResponse<String> afterApproveInvoiceReceive(@RequestParam(value="contractId", required=true) Long contractId,
			@RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny);

	@PostMapping(value = "/api/equipment/afterRevocationInvoiceReceive")
	CommonResponse<JSONObject> afterRevocationInvoiceReceive(@RequestParam(value="contractId", required=true) Long contractId,
			@RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny);
	/**
	 * 根据条件查询不同合同类型的合同
	 * @return
	 */
	@PostMapping(value = "/api/equipment/getPurchaseContractById")
	public CommonResponse<ContractResVO> getContractById(@RequestParam(value="contractId", required=true)Long contractId);
	@PostMapping(value = "/api/equipment/rentAfterApproveInvoiceReceive")
	CommonResponse<String> rentAfterApproveInvoiceReceive(@RequestParam(value="contractId", required=true) Long contractId,
														  @RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny);

	@PostMapping(value = "/api/equipment/rentAfterRevocationInvoiceReceive")
	CommonResponse<JSONObject> rentAfterRevocationInvoiceReceive(@RequestParam(value="contractId", required=true) Long contractId,
																 @RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny);
	@RequestMapping(value = "/api/equipment/getMonthEquipmentMny", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<EquipmentReportVo>> getMonthEquipmentMny(@RequestParam(value = "projectId") Long projectId,
																		@RequestParam(value = "lastDay") Integer lastDay);
	/**
	 * 查设备采购/租赁数量，合同金额，结算金额
	 * @param projectId
	 * @return
	 */
	@RequestMapping(value = "/api/equipment/getEquipment", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<EquipmentReportVo>> getEquipment(@RequestParam(value = "projectId") Long projectId);

	/**
	 * 根据条件查询不同合同类型的合同结算
	 *
	 * @param rentUseRecordVOS
	 *
	 * @return
	 */
	@PostMapping(value = "/api/equipment/updateRentUseRecordSporadicUseFlag")
	public CommonResponse<String> updateRentUseRecordSporadicUseFlag(@RequestBody List<RentUseRecordVO> rentUseRecordVOS);

	@GetMapping(value = "/api/equipment/fetchSjzcjePurchase")
	CommonResponse<BigDecimal> fetchSjzcjePurchase(@RequestParam(value = "projectId") Long projectId);

	@GetMapping(value = "/api/equipment/fetchSjzcjeRent")
	CommonResponse<BigDecimal> fetchSjzcjeRent(@RequestParam(value = "projectId") Long projectId);
}
