package com.ejianc.business.acceptance.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 购置验收表
 *
 * @author generator
 *
 */
public class PurchaseAcceptanceVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String billCode; // 单据编号
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long projectId; // 项目id
    private String projectOrg; // 所属单位
    private Long projectOrgId; // 所属单位id
    private String contractName; // 合同名称
    private Long contractId; // 合同id
    private String contractCode; // 合同编号
    private String supplierName; // 供应商
    private Long supplierId; // 供应商id
    private String propertyRightCompany; // 产权单位
    private Long propertyRightCompanyId; // 产权单位id
    private String manageCompany; // 管理单位
    private Long manageCompanyId; // 管理单位id
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date acceptanceDate; // 验收日期
    private String acceptancePsn; // 验收人
    private Long acceptancePsnId; // 验收人id
    private String manufactor; // 厂家:一致/不一致
    private String equipmentModel; // 设备型号:一致/不一致
    private String appearance; // 外观:一致/不一致
    private String bodyStructure; // 机体结构:良好/一般/差
    private String safeProtectDevice; // 安全防护装置：良好/一般/差
    private String testRun; // 试运行:合格/不合格
    private String skillInformation; // 技术资料:完备/不完备
    private String manufacturer; // 生产厂家
    private String certificateNum; // 合格证号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date productionDate; // 生产日期
    private String leaveFactoryCode; // 出厂编号
    private String randomTool; // 随机工具
    private String ability; // 能力
    private BigDecimal weight; // 重量（t）
    private BigDecimal power; // 动力（kw）
    private BigDecimal ownWeight; // 自重（t）
    private BigDecimal appearanceSize; // 外形尺寸（毫米）
    private String modelExplain; // 型号说明
    private String memo; // 备注
    private String originalBillPath; // 原始单据路径
    private String photoPath; // 现场照片路径
    private String projectMangerSign; // 项目经理签字
    private String supplierSign; // 供应商签字
    private Long projectDepartmentId; // 项目部ID
    private String projectDepartmentName; // 项目部名称
    private Boolean notSignature;//是否签字
    private Long equipmentId; // 设备ID
    private String equipmentCode; // 设备编码
    private Long equipmentTypeId; // 设备分类ID
    private Long sourceDetailId; //
    private String equipmentName; // 设备名称
    private String equipmentType; // 设备类别
    private String spec; // 规格型号
    private String company; // 计量单位
    private BigDecimal purchasePrice; // 含税单价
    private BigDecimal taxRate; // 税率
    private BigDecimal overageSettleTaxMny; //
    private BigDecimal contractNum; // 剩余可结算金额
    private String orgCode; // 项目部编码
    private Integer financePushFlag; // 是否推送财务1推送0不推送

    @ApiModelProperty("组织id")
    private Long orgId;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;

    public BigDecimal getContractNum() {
        return contractNum;
    }

    public void setContractNum(BigDecimal contractNum) {
        this.contractNum = contractNum;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }

    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }

    public Long getEquipmentTypeId() {
        return equipmentTypeId;
    }

    public void setEquipmentTypeId(Long equipmentTypeId) {
        this.equipmentTypeId = equipmentTypeId;
    }

    public BigDecimal getOverageSettleTaxMny() {
        return overageSettleTaxMny;
    }

    public void setOverageSettleTaxMny(BigDecimal overageSettleTaxMny) {
        this.overageSettleTaxMny = overageSettleTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }

    public String getEquipmentType() {
        return equipmentType;
    }

    public void setEquipmentType(String equipmentType) {
        this.equipmentType = equipmentType;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public BigDecimal getPurchasePrice() {
        return purchasePrice;
    }

    public void setPurchasePrice(BigDecimal purchasePrice) {
        this.purchasePrice = purchasePrice;
    }

    private List<PurchaseAcceptanceSubVO> purchaseAcceptanceSubList = new ArrayList<>(); // 设备购置验收-设备明细

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectOrg() {
        return projectOrg;
    }

    public void setProjectOrg(String projectOrg) {
        this.projectOrg = projectOrg;
    }

    public Long getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode = "equipment-purchase-contract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getPropertyRightCompany() {
        return propertyRightCompany;
    }

    public void setPropertyRightCompany(String propertyRightCompany) {
        this.propertyRightCompany = propertyRightCompany;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getPropertyRightCompanyId() {
        return propertyRightCompanyId;
    }

    @ReferDeserialTransfer
    public void setPropertyRightCompanyId(Long propertyRightCompanyId) {
        this.propertyRightCompanyId = propertyRightCompanyId;
    }

    public String getManageCompany() {
        return manageCompany;
    }

    public void setManageCompany(String manageCompany) {
        this.manageCompany = manageCompany;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getManageCompanyId() {
        return manageCompanyId;
    }

    @ReferDeserialTransfer
    public void setManageCompanyId(Long manageCompanyId) {
        this.manageCompanyId = manageCompanyId;
    }

    public Date getAcceptanceDate() {
        return acceptanceDate;
    }

    public void setAcceptanceDate(Date acceptanceDate) {
        this.acceptanceDate = acceptanceDate;
    }

    public String getAcceptancePsn() {
        return acceptancePsn;
    }

    public void setAcceptancePsn(String acceptancePsn) {
        this.acceptancePsn = acceptancePsn;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getAcceptancePsnId() {
        return acceptancePsnId;
    }

    @ReferDeserialTransfer
    public void setAcceptancePsnId(Long acceptancePsnId) {
        this.acceptancePsnId = acceptancePsnId;
    }

    public String getManufactor() {
        return manufactor;
    }

    public void setManufactor(String manufactor) {
        this.manufactor = manufactor;
    }

    public String getEquipmentModel() {
        return equipmentModel;
    }

    public void setEquipmentModel(String equipmentModel) {
        this.equipmentModel = equipmentModel;
    }

    public String getAppearance() {
        return appearance;
    }

    public void setAppearance(String appearance) {
        this.appearance = appearance;
    }

    public String getBodyStructure() {
        return bodyStructure;
    }

    public void setBodyStructure(String bodyStructure) {
        this.bodyStructure = bodyStructure;
    }

    public String getSafeProtectDevice() {
        return safeProtectDevice;
    }

    public void setSafeProtectDevice(String safeProtectDevice) {
        this.safeProtectDevice = safeProtectDevice;
    }

    public String getTestRun() {
        return testRun;
    }

    public void setTestRun(String testRun) {
        this.testRun = testRun;
    }

    public String getSkillInformation() {
        return skillInformation;
    }

    public void setSkillInformation(String skillInformation) {
        this.skillInformation = skillInformation;
    }

    public String getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getCertificateNum() {
        return certificateNum;
    }

    public void setCertificateNum(String certificateNum) {
        this.certificateNum = certificateNum;
    }

    public Date getProductionDate() {
        return productionDate;
    }

    public void setProductionDate(Date productionDate) {
        this.productionDate = productionDate;
    }

    public String getLeaveFactoryCode() {
        return leaveFactoryCode;
    }

    public void setLeaveFactoryCode(String leaveFactoryCode) {
        this.leaveFactoryCode = leaveFactoryCode;
    }

    public String getRandomTool() {
        return randomTool;
    }

    public void setRandomTool(String randomTool) {
        this.randomTool = randomTool;
    }

    public String getAbility() {
        return ability;
    }

    public void setAbility(String ability) {
        this.ability = ability;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public BigDecimal getPower() {
        return power;
    }

    public void setPower(BigDecimal power) {
        this.power = power;
    }

    public BigDecimal getOwnWeight() {
        return ownWeight;
    }

    public void setOwnWeight(BigDecimal ownWeight) {
        this.ownWeight = ownWeight;
    }

    public BigDecimal getAppearanceSize() {
        return appearanceSize;
    }

    public void setAppearanceSize(BigDecimal appearanceSize) {
        this.appearanceSize = appearanceSize;
    }

    public String getModelExplain() {
        return modelExplain;
    }

    public void setModelExplain(String modelExplain) {
        this.modelExplain = modelExplain;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getOriginalBillPath() {
        return originalBillPath;
    }

    public void setOriginalBillPath(String originalBillPath) {
        this.originalBillPath = originalBillPath;
    }

    public String getPhotoPath() {
        return photoPath;
    }

    public void setPhotoPath(String photoPath) {
        this.photoPath = photoPath;
    }

    public String getProjectMangerSign() {
        return projectMangerSign;
    }

    public void setProjectMangerSign(String projectMangerSign) {
        this.projectMangerSign = projectMangerSign;
    }

    public String getSupplierSign() {
        return supplierSign;
    }

    public void setSupplierSign(String supplierSign) {
        this.supplierSign = supplierSign;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getProjectDepartmentName() {
        return projectDepartmentName;
    }

    public void setProjectDepartmentName(String projectDepartmentName) {
        this.projectDepartmentName = projectDepartmentName;
    }

    public Boolean getNotSignature() {
        return notSignature;
    }

    public void setNotSignature(Boolean notSignature) {
        this.notSignature = notSignature;
    }

    public List<PurchaseAcceptanceSubVO> getPurchaseAcceptanceSubList() {
        return purchaseAcceptanceSubList;
    }

    public void setPurchaseAcceptanceSubList(List<PurchaseAcceptanceSubVO> purchaseAcceptanceSubList) {
        this.purchaseAcceptanceSubList = purchaseAcceptanceSubList;
    }

    public Integer getFinancePushFlag() {
        return financePushFlag;
    }

    public void setFinancePushFlag(Integer financePushFlag) {
        this.financePushFlag = financePushFlag;
    }
}
