package com.ejianc.business.equipment.controller;

import java.io.Serializable;

import com.ejianc.business.equipment.vo.SupplementPurchaseContractRecordVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.equipment.bean.SupplementPurchaseContractEntity;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.ISupplementPurchaseContractService;
import com.ejianc.business.equipment.vo.SupplementPurchaseContractVO;


/**
 * 采购合同补充协议
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("supplementPurchaseContract")
public class SupplementPurchaseContractController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ISupplementPurchaseContractService service; 
    @Autowired
    private IPurchaseContractService purchaseContractService;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplementPurchaseContractVO> saveOrUpdate(@RequestBody SupplementPurchaseContractVO saveorUpdateVO) {
        SupplementPurchaseContractVO vo = service.insertOrUpdate(saveorUpdateVO);
        purchaseContractService.updateContractIsSupplementFlag(saveorUpdateVO.getMainContractId());
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Author sunyj
     * @Description  新增根据合同主键查询转换
     * @param contractId
     * @Return com.ejianc.framework.core.response.CommonResponse<ChangeVO>
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplementPurchaseContractVO> addConvertByConId(Long contractId) {
        SupplementPurchaseContractVO vo = service.addConvertByConId(contractId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Description saveOrUpdate 查询合同协议记录
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<ChangeVO>
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplementPurchaseContractRecordVO> queryDetailRecord(Long id) {
        SupplementPurchaseContractRecordVO vo = service.queryDetailRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplementPurchaseContractVO> queryDetail(Long id) {
    	SupplementPurchaseContractEntity entity = service.selectById(id);
    	SupplementPurchaseContractVO vo = BeanMapper.map(entity, SupplementPurchaseContractVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplementPurchaseContractVO> vos) {
    	 Long[] ids=new Long[vos.size()];
     	for (int i = 0; i < ids.length; i++) {
     		SupplementPurchaseContractEntity entity =service.getById(vos.get(i).getId());
     		ids[i]=entity.getMainContractId();
 		}
        service.removeByIds(vos.stream().map(SupplementPurchaseContractVO::getId).collect(Collectors.toList()),true);       
        for (int i = 0; i < ids.length; i++) {
        	purchaseContractService.updateContractIsSupplementFlag(ids[i]);
		}
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplementPurchaseContractVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<SupplementPurchaseContractEntity> page = service.queryPage(param,false);
        IPage<SupplementPurchaseContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplementPurchaseContractVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
