package com.ejianc.business.equipment.zhgcloud.api;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.equipment.bean.TaibanDetailEntity;
import com.ejianc.business.equipment.bean.TaibanEntity;
import com.ejianc.business.equipment.service.ITaibanService;
import com.ejianc.business.equipment.zhgcloud.bean.ZhpResult;
import com.ejianc.business.equipment.zhgcloud.bean.taibanBean.TaibanDetail;
import com.ejianc.business.equipment.zhgcloud.bean.taibanBean.TaibanRoot;
import com.mysql.fabric.xmlrpc.base.Array;

@RestController
@RequestMapping("api/equipment/")
public class EquipmentTaibanApi {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITaibanService service;
    
	@PostMapping(value = "getTaiban")
	public ZhpResult getTaiban(@RequestBody JSONObject json) {
		ZhpResult result=new ZhpResult();
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
		TaibanEntity taibanEntity=new TaibanEntity();
		TaibanDetailEntity taibanDetailEntity =new TaibanDetailEntity();
		List<TaibanDetailEntity> taibanDetailEntityList =new ArrayList<TaibanDetailEntity>();
		logger.info(json.toString());
		TaibanRoot taiban = JSON.parseObject(json.toString(), TaibanRoot.class);
		if(taiban!=null) {
			taibanEntity.setTenantKey(taiban.getTenant_key());
			//TODO 根据TenantKey查询组织主键
			taibanEntity.setMachineShiftKey(taiban.getMachine_shift_key());
			taibanEntity.setMachineShiftNumber(taiban.getMachine_shift_number());
			//TODO 台班签证编号作为billCode
			taibanEntity.setContractKey(taiban.getContract_key());
			taibanEntity.setBillCode(taiban.getMachine_shift_number());
			//TODO 通过合同编码查找合同及供应商
			taibanEntity.setContractName("机械设备租赁合同");
			taibanEntity.setSupplierName("李沧区渠成源机械设备租赁部");
			
			taibanEntity.setContractDetailKey(taiban.getContract_detail_key());
			taibanEntity.setContractDetailCode(taiban.getContract_detail_code());
			taibanEntity.setMachineGuid(taiban.getMachine_info().getMachine_guid());
			taibanEntity.setMachineName(taiban.getMachine_info().getMachine_name());
			taibanEntity.setProjectKey(taiban.getProject_info().getProject_key());
			taibanEntity.setProjectName(taiban.getProject_info().getProject_name());
			taibanEntity.setStatus(taiban.getStatus());
			taibanEntity.setSendJson(json.toString());
			taibanEntity.setActualWorkTime(BigDecimal.valueOf((int)taiban.getActual_work_time()).divide(new BigDecimal(360)));
			try {
				taibanEntity.setCreatedAt(simpleDateFormat.parse(taiban.getCreated_at()));
			} catch (ParseException e) {
				e.printStackTrace();
			}
			//TODO 台班总数
			BigDecimal shifNumber=new BigDecimal(0);
			for (TaibanDetail taibanDetail : taiban.getDetail()) {
				taibanDetailEntity.setShiftDetailKey(taibanDetail.getShift_detail_key());
				taibanDetailEntity.setWorkState(taibanDetail.getWork_state());
				taibanDetailEntity.setBeginAt(taibanDetail.getBegin_at());
				taibanDetailEntity.setEndAt(taibanDetail.getEnd_at());
				taibanDetailEntity.setWorkTime(BigDecimal.valueOf(taibanDetail.getWork_time()).divide(new BigDecimal(360)));
				taibanDetailEntity.setTerminalTotalTime(BigDecimal.valueOf(taibanDetail.getTerminal_total_time()));
				taibanDetailEntity.setTerminalWorkTime(BigDecimal.valueOf(taibanDetail.getTerminal_work_time()));
				taibanDetailEntity.setTerminalIdleTime(BigDecimal.valueOf(taibanDetail.getTerminal_idle_time()));
				taibanDetailEntity.setActualWorkTime(BigDecimal.valueOf(taibanDetail.getActual_work_time()));
				taibanDetailEntity.setShiftNumber(BigDecimal.valueOf(taibanDetail.getShift_number()));
				shifNumber=shifNumber.add(BigDecimal.valueOf(taibanDetail.getShift_number()));
				taibanDetailEntity.setAccountingObject(taibanDetail.getAccounting_object_code());
				taibanDetailEntityList.add(taibanDetailEntity);
			}
			taibanEntity.setShiftNumber(shifNumber);
			taibanEntity.setTaibanDetail(taibanDetailEntityList);
		}
		service.saveOrUpdate(taibanEntity, false);
		result.setStatus(0);
		result.setMessage("推送成功");
		return result;
	}
	
	
}
