package com.ejianc.business.equipment.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.bean.PurchaseContractDetailEntity;
import com.ejianc.business.equipment.service.IPurchaseContractDetailService;
import com.ejianc.business.equipment.vo.PurchaseContractDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.Map;

@RestController
@RequestMapping("purchaseContractDetail")
public class PurchaseContractDetailController {

    @Autowired
    private IPurchaseContractDetailService purchaseContractDetailService;

    @Autowired
    private IOrgApi orgApi;

    /**
     * 查询指定组织本下的所有项目信息列表
     *
     * @param pageNumber
     * @param pageSize
     * @param
     * @param searchText
     * @return
     */
    @GetMapping("/purchaseContractDetailRef")
    public  CommonResponse<IPage<PurchaseContractDetailVO>>  projectListRefe(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                           @RequestParam(defaultValue = "10") Integer pageSize,
                                                           @RequestParam(value = "condition", required = false) String condition,
                                                           @RequestParam(value = "searchText", required = false) String searchText) {

        JSONObject jsonObject = new JSONObject();
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("name");
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("contractId")) {
                queryParam.getParams().put("contract_id",new Parameter("eq",conditionMap.get("contractId")));
                queryParam.getParams().put("change_type",new Parameter("ne","3"));
            }
        }
        IPage<PurchaseContractDetailEntity> pageData = purchaseContractDetailService.queryPage(queryParam,false);
        IPage<PurchaseContractDetailVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        pageData.getRecords().forEach(e->{
        	PurchaseContractDetailEntity entitySumNum=purchaseContractDetailService.querySumNum(e.getId());
        	e.setSumNum(entitySumNum.getSumNum());
            BigDecimal price = e.getPrice()==null?BigDecimal.ZERO:e.getPrice();
            BigDecimal nums = e.getNum()==null?BigDecimal.ZERO:e.getNum();
            e.setMoney(price.multiply(nums));
        });
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), PurchaseContractDetailVO.class));
        return CommonResponse.success("参照查询成功！", result);
    }
}
