package com.ejianc.business.equipment.bean;

import java.math.BigDecimal;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

/**
 * <p>
 * 其他费用
 * </p>
 *
 * @author yqls
 * @since 2020-06-11
 */
@TableName("ejc_equipment_rent_use_record_fee")
public class RentUseRecordFeeEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 使用记录主表主键
     */
    @TableField("use_id")
    private Long useId;

    /**
     * 费用类型
     */
    @TableField("fee_type")
    private String feeType;

    /**
     * 金额
     */
    @TableField("money")
    private BigDecimal money;
    
    /**
     * 金额含税
     */
    @TableField("money_tax")
    private BigDecimal moneyTax;
    
    /**
     * 税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;
    
    /**
     * 税金
     */
    @TableField("tax")
    private BigDecimal tax;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    public Long getUseId() {
        return useId;
    }
    /**
     * 成本科目主键
     */
    @TableField(value = "fee_subject_id")
    private Long subjectId;

    /**
     * 成本科目名称
     */
    @TableField(value = "fee_subject_name")
    private String subjectName;

    /**
     * 成本科目集团主键
     */
    @TableField(value = "fee_org_subject_id")
    private Long orgSubjectId;
    
    /**
     * 核算对象主键
     */
    @TableField(value = "fee_accounting_id")
    private Long accountingId;

    /**
     * 核算对象名称
     */
    @TableField(value = "fee_accounting_name")
    private String accountingName;

    /**
     * 核算对象集团主键
     */
    @TableField(value = "fee_org_accounting_id")
    private Long orgAccountingId;

    

	public Long getSubjectId() {
		return subjectId;
	}
	public void setSubjectId(Long subjectId) {
		this.subjectId = subjectId;
	}
	public String getSubjectName() {
		return subjectName;
	}
	public void setSubjectName(String subjectName) {
		this.subjectName = subjectName;
	}
	public Long getOrgSubjectId() {
		return orgSubjectId;
	}
	public void setOrgSubjectId(Long orgSubjectId) {
		this.orgSubjectId = orgSubjectId;
	}
	public Long getAccountingId() {
		return accountingId;
	}
	public void setAccountingId(Long accountingId) {
		this.accountingId = accountingId;
	}
	public String getAccountingName() {
		return accountingName;
	}
	public void setAccountingName(String accountingName) {
		this.accountingName = accountingName;
	}
	public Long getOrgAccountingId() {
		return orgAccountingId;
	}
	public void setOrgAccountingId(Long orgAccountingId) {
		this.orgAccountingId = orgAccountingId;
	}
	public void setMoneyTax(BigDecimal moneyTax) {
		this.moneyTax = moneyTax;
	}
	public void setUseId(Long useId) {
        this.useId = useId;
    }
    public String getFeeType() {
        return feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

	public BigDecimal getMoneyTax() {
		return moneyTax;
	}

	public void setMoney_tax(BigDecimal moneyTax) {
		this.moneyTax = moneyTax;
	}

	public BigDecimal getTaxRate() {
		return taxRate;
	}

	public void setTaxRate(BigDecimal taxRate) {
		this.taxRate = taxRate;
	}

	public BigDecimal getTax() {
		return tax;
	}

	public void setTax(BigDecimal tax) {
		this.tax = tax;
	}

}
