package com.ejianc.business.equipment.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 设备退场单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_equipment_rent_walk")
public class RentWalkEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="supplier_id")
    private Long supplierId; // 设备供应商
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="arena_date")
    private java.util.Date arenaDate; // 进场日期
    @TableField(value="memo")
    private String memo; // 进场说明
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="bill_code")
    private String billCode; // 单据编码


    @TableField(exist=false)
    @SubEntity(serviceName="rentWalkDetailService",pidName = "enId")
    private List<RentWalkDetailEntity> rentWalkDetailVOList = new ArrayList<>(); // 退场单子表实体


    public List<RentWalkDetailEntity> getRentWalkDetailVOList() {
        return rentWalkDetailVOList;
    }

    public void setRentWalkDetailVOList(List<RentWalkDetailEntity> rentWalkDetailVOList) {
        this.rentWalkDetailVOList = rentWalkDetailVOList;
    }

    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 设备供应商
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 设备供应商
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 进场日期
     */
    public java.util.Date getArenaDate() {
        return arenaDate;
    }

    /**
     * 进场日期
     */
    public void setArenaDate(java.util.Date arenaDate) {
        this.arenaDate = arenaDate;
    }
    /**
     * 进场说明
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 进场说明
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
}
