package com.ejianc.business.equipment.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 台班签证实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_equipment_taiban")
public class TaibanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="tenant_key")
    private String tenantKey; //  企业唯一标识
    @TableField(value="machine_shift_key")
    private String machineShiftKey; // 主记录唯一标识
    @TableField(value="machine_shift_number")
    private String machineShiftNumber; // 台班签证单签证单编号
    @TableField(value="contract_key")
    private String contractKey; // 指挥官唯一合同标识
    @TableField(value="long_contract_code")
    private String longContractCode; // 客户合同唯一标识
    @TableField(value="contract_detail_key")
    private String contractDetailKey; // 指挥官唯一合同详情标识
    @TableField(value="contract_detail_code")
    private String contractDetailCode; // 客户合同详情唯一标识
    @TableField(value="machine_guid")
    private String machineGuid; // 机械唯一标识
    @TableField(value="machine_name")
    private String machineName; // 机械名称
    @TableField(value="assets_code")
    private String assetsCode; // 资产编号
    @TableField(value="factory_code")
    private String factoryCode; // 铭牌编号
    @TableField(value="vehicle_license_code")
    private String vehicleLicenseCode; // 车牌号
    @TableField(value="management_code")
    private String managementCode; // 管理编号
    @TableField(value="project_key")
    private String projectKey; // 项目唯⼀标识
    @TableField(value="project_number")
    private String projectNumber; // 项目编号
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="status")
    private String status; // 审批状态:checked：已通过check_fail：未通过cancel：已取消
    @TableField(value="actual_work_time")
    private BigDecimal actualWorkTime; // 时间工作时间
    @TableField(value="created_at")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createdAt; // 创建时间
    @TableField(value="send_json")
    private String sendJson; // 接收报文
    @TableField(value="bill_code")
    private String billCode; // 单据号
    @TableField(value="contract_name")
    private String contractName; // 合同名
    @TableField(value="supplier_name")
    private String supplierName; // 租赁方
    @TableField(value="shift_number")
    private BigDecimal shiftNumber; // 台班数
    
    // 明细子表
    @TableField(exist = false)
    @SubEntity(serviceName="taibanDetailService",pidName = "pid")
    private List<TaibanDetailEntity> taibanDetail = new ArrayList<>();
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getTenantKey() {
        return tenantKey;
    }

    public void setTenantKey(String tenantKey) {
        this.tenantKey = tenantKey;
    }
    public String getMachineShiftKey() {
        return machineShiftKey;
    }

    public void setMachineShiftKey(String machineShiftKey) {
        this.machineShiftKey = machineShiftKey;
    }
    public String getMachineShiftNumber() {
        return machineShiftNumber;
    }

    public void setMachineShiftNumber(String machineShiftNumber) {
        this.machineShiftNumber = machineShiftNumber;
    }
    public String getContractKey() {
        return contractKey;
    }

    public void setContractKey(String contractKey) {
        this.contractKey = contractKey;
    }
    public String getLongContractCode() {
        return longContractCode;
    }

    public void setLongContractCode(String longContractCode) {
        this.longContractCode = longContractCode;
    }
    public String getContractDetailKey() {
        return contractDetailKey;
    }

    public void setContractDetailKey(String contractDetailKey) {
        this.contractDetailKey = contractDetailKey;
    }
    public String getContractDetailCode() {
        return contractDetailCode;
    }

    public void setContractDetailCode(String contractDetailCode) {
        this.contractDetailCode = contractDetailCode;
    }
    public String getMachineGuid() {
        return machineGuid;
    }

    public void setMachineGuid(String machineGuid) {
        this.machineGuid = machineGuid;
    }
    public String getMachineName() {
        return machineName;
    }

    public void setMachineName(String machineName) {
        this.machineName = machineName;
    }
    public String getAssetsCode() {
        return assetsCode;
    }

    public void setAssetsCode(String assetsCode) {
        this.assetsCode = assetsCode;
    }
    public String getFactoryCode() {
        return factoryCode;
    }

    public void setFactoryCode(String factoryCode) {
        this.factoryCode = factoryCode;
    }
    public String getVehicleLicenseCode() {
        return vehicleLicenseCode;
    }

    public void setVehicleLicenseCode(String vehicleLicenseCode) {
        this.vehicleLicenseCode = vehicleLicenseCode;
    }
    public String getManagementCode() {
        return managementCode;
    }

    public void setManagementCode(String managementCode) {
        this.managementCode = managementCode;
    }
    public String getProjectKey() {
        return projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }
    public String getProjectNumber() {
        return projectNumber;
    }

    public void setProjectNumber(String projectNumber) {
        this.projectNumber = projectNumber;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
    public BigDecimal getActualWorkTime() {
        return actualWorkTime;
    }

    public void setActualWorkTime(BigDecimal actualWorkTime) {
        this.actualWorkTime = actualWorkTime;
    }
    public Date getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }
    public String getSendJson() {
        return sendJson;
    }

    public void setSendJson(String sendJson) {
        this.sendJson = sendJson;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public BigDecimal getShiftNumber() {
        return shiftNumber;
    }

    public void setShiftNumber(BigDecimal shiftNumber) {
        this.shiftNumber = shiftNumber;
    }

	public List<TaibanDetailEntity> getTaibanDetail() {
		return taibanDetail;
	}

	public void setTaibanDetail(List<TaibanDetailEntity> taibanDetail) {
		this.taibanDetail = taibanDetail;
	}
    
}
