package com.ejianc.business.equipment.zhgcloud.service;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.equipment.bean.RentContractDetailEntity;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.zhgcloud.bean.contractBean.ContractDatalist;
import com.ejianc.business.equipment.zhgcloud.bean.contractBean.ContractDetail;
import com.ejianc.business.equipment.zhgcloud.bean.contractBean.ContractRoot;

public class ZhpCloudService {
    @Autowired
    private IRentContractService rentContractService;
	public void sendContract(String contractId) {
		 String datestr="2022-10-21 23:35:50";
	    DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd");
		RentContractEntity RentContract=rentContractService.getById(contractId);
		ContractRoot contractRoot=new ContractRoot();
		contractRoot.setApp_key("738d76ce-9eee-4594-bb30-8ab274f71ee7");
		contractRoot.setApp_secret("1114aeee9274fde132c7aaf816724382");
		contractRoot.setTenant_key("W6FFFL6U");
		
		ContractDatalist contractDatalist=new ContractDatalist();
		contractDatalist.setLong_contract_code(RentContract.getId().toString());
		contractDatalist.setNumber(RentContract.getBillCode());
		contractDatalist.setSign_date(dateformat.format(RentContract.getSignDate()));
		contractDatalist.setProject_key("W6FFFSM0");
		contractDatalist.setContractor_name(RentContract.getContractName());
		contractDatalist.setContractor_contact("宋雪梅");
		contractDatalist.setContractor_phone("15269236774");
		contractDatalist.setLessor_name(RentContract.getSupplierName());
		contractDatalist.setLessor_phone(" ");
		contractDatalist.setTax_type("include");
		contractDatalist.setTariff(RentContract.getTaxRate().doubleValue());
		contractDatalist.setAmount(RentContract.getContractTaxMny().intValue());
		contractDatalist.setAmount_non_tax(RentContract.getContractMny().intValue());

		List<RentContractDetailEntity> contractDetailEntity =RentContract.getRentdetail();
		List<ContractDetail> detail=new  ArrayList<ContractDetail>();
		for (RentContractDetailEntity rentContractDetailEntity : contractDetailEntity) {
			ContractDetail contractDetail=new ContractDetail();
			contractDetail.setContract_detail_code(rentContractDetailEntity.getId().toString());
			contractDetail.setMachine_type(2);
			contractDetail.setMachine_category(rentContractDetailEntity.getName());
			contractDetail.setSpecification(rentContractDetailEntity.getSpec());
			contractDetail.setMachine_quantity(1);
			contractDetail.setSettlement("team");
			contractDetail.setEnter_at(dateformat.format(rentContractDetailEntity.getStartDate()));
			contractDetail.setExit_at(dateformat.format(rentContractDetailEntity.getEndDate()));
			contractDetail.setEstimated_quantity(rentContractDetailEntity.getNum().intValue());
			contractDetail.setSettlement_unit_price(rentContractDetailEntity.getTaxPrice());
			contractDetail.setSettlement_amount(rentContractDetailEntity.getTaxMoney());
			contractDetail.setContractor_costs_amount(new BigDecimal(0));
			detail.add(contractDetail);
		}
		contractDatalist.setDetail(detail);
		List<ContractDatalist> contractDatalistArray=new ArrayList<ContractDatalist>();
		contractDatalistArray.add(contractDatalist);
		contractRoot.setDatalist(contractDatalistArray);
		String contractJson=JSONObject.toJSONString(contractRoot);
		System.out.println(contractJson);
	}
}
