package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.bean.RentSettlementEntity;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.service.IRentSettlementService;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * <p>
 * 设备合同结算单审批操作后
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("rentSettlement")
public class RentSettlementBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentContractService rentContractService;

    @Autowired
    private IRentSettlementService rentSettlementService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private HttpServletRequest request;

    // 是否推送凭证
    private static final String VOUCHER_PARAM = "P-h5UC6769";

    @Autowired
    private IParamConfigApi paramConfigApi;


    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state,String billTypeCode) {
        logger.info("进入审批同意后回写--- billId:"+billId+"  state:"+state);
        RentSettlementEntity settlementEntity= rentSettlementService.selectById(billId);
        BigDecimal offsetMny = settlementEntity.getOffsetMny()==null?BigDecimal.ZERO:settlementEntity.getOffsetMny();//本次冲抵金额
        BigDecimal settlementMny = settlementEntity.getSettlementMny()==null?BigDecimal.ZERO:settlementEntity.getSettlementMny();//本期结算金额(不含税)
        BigDecimal settlementTaxMny = settlementEntity.getSettlementTaxMny()==null?BigDecimal.ZERO:settlementEntity.getSettlementTaxMny();//本期结算金额(含税)

        BigDecimal sumOffsetMnys = settlementEntity.getSumOffsetMny()==null?BigDecimal.ZERO:settlementEntity.getSumOffsetMny();//实际累计冲抵金额
        BigDecimal sumPrePayMnys = settlementEntity.getSumPrepayMny()==null?BigDecimal.ZERO:settlementEntity.getSumPrepayMny();//实际预付款金额
        //1，先查出合同
        RentContractEntity contractEntity = rentContractService.selectById(settlementEntity.getContractId());
        BigDecimal sumOffsetMny = contractEntity.getSumOffsetMny()==null?BigDecimal.ZERO:contractEntity.getSumOffsetMny();//累计冲抵金额
        BigDecimal sumSettlementMny = contractEntity.getSumSettlementMny()==null?BigDecimal.ZERO:contractEntity.getSumSettlementMny();//累计结算金额(不含税)
        BigDecimal sumSettlementTaxMny = contractEntity.getSumSettlementTaxMny()==null?BigDecimal.ZERO:contractEntity.getSumSettlementTaxMny();//累计结算金额

        if(offsetMny.compareTo(sumPrePayMnys.subtract(sumOffsetMnys))>0){
            return CommonResponse.error("审批回写异常!该合同冲抵金额已超出预付款金额!");
        }

        contractEntity.setSumOffsetMny(sumOffsetMny.add(offsetMny));
        contractEntity.setSumSettlementMny(sumSettlementMny.add(settlementMny));
        contractEntity.setSumSettlementTaxMny(sumSettlementTaxMny.add(settlementTaxMny));
        logger.info("业务逻辑完成--"+contractEntity.getSumOffsetMny()+"    --"+contractEntity.getSumSettlementTaxMny());

        Boolean flag = rentContractService.saveOrUpdate(contractEntity,false);
        logger.info("业务逻辑完成--返回"+flag);
        rentSettlementService.costPush(settlementEntity);

        // 推送凭证
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(VOUCHER_PARAM);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            Long projectId = settlementEntity.getProjectId();
            if (valueData.equals(String.valueOf(projectId)) || "是".equals(valueData)) {
                ExecutorService threadPool = Executors.newFixedThreadPool(1);
                String authority = request.getHeader("authority");
                if (authority == null) {
                    logger.info("request-authority为空");
                    authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
                }
                try {
                    Callable<CommonResponse> voucherCallable = new VoucherCallable(true, settlementEntity, RequestContextHolder.getRequestAttributes(), authority);
                    threadPool.submit(voucherCallable);
                } catch (Exception e) {
                    logger.error(this.getClass() + "推送凭证异常, ", e);
                } finally {
                    threadPool.shutdown();
                }
            }
        }
        if(flag){
            return CommonResponse.success();
        }else{
            return CommonResponse.error("审批回写异常!");
        }
    }

    class VoucherCallable implements Callable<CommonResponse> {

        private RentSettlementEntity entity;
        private boolean isGenerate;
        private RequestAttributes context;
        private String authority;

        public VoucherCallable(boolean isGenerate, RentSettlementEntity entity, RequestAttributes context, String authority) {
            this.entity = entity;
            this.isGenerate = isGenerate;
            this.context = context;
            this.authority = authority;
        }

        @Override
        public CommonResponse call() {
            logger.info("--------------{}--voucher线程开始-------{}---------", this.getClass(), isGenerate);
            RequestContextHolder.setRequestAttributes(context);
            InvocationInfoProxy.setExtendAttribute("authority", authority);
            rentSettlementService.handleVoucher(entity, isGenerate);
            logger.info("--------------{}--voucher线程结束-------{}---------", this.getClass(), isGenerate);
            return null;
        }
    }



    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        RentSettlementEntity settlementEntity = rentSettlementService.selectById(billId);
        //TO DO 结算单是否被其他引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            LambdaQueryWrapper<RentSettlementEntity> lambdachange = Wrappers.<RentSettlementEntity>lambdaQuery();
            lambdachange.eq(RentSettlementEntity::getContractId, settlementEntity.getContractId());
            lambdachange.eq(RentSettlementEntity::getOrgId, settlementEntity.getOrgId());
            lambdachange.gt(RentSettlementEntity::getCreateTime, settlementEntity.getCreateTime());
            lambdachange.ne(RentSettlementEntity::getId,billId);
            lambdachange.in(RentSettlementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
            int num = rentSettlementService.count(lambdachange);
            if (num > 0) {
                return CommonResponse.error("审批回写异常!该合同不是最新的结算日期，不能回退!");
            } else {
                return CommonResponse.success();
            }
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }

    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        logger.info("进入同意后回写--- billId:"+billId+"  state:"+state);
        RentSettlementEntity settlementEntity= rentSettlementService.selectById(billId);
        BigDecimal offsetMny = settlementEntity.getOffsetMny()==null?BigDecimal.ZERO:settlementEntity.getOffsetMny();//本次冲抵金额
        BigDecimal settlementMny = settlementEntity.getSettlementMny()==null?BigDecimal.ZERO:settlementEntity.getSettlementMny();//本期结算金额(不含税)
        BigDecimal settlementTaxMny = settlementEntity.getSettlementTaxMny()==null?BigDecimal.ZERO:settlementEntity.getSettlementTaxMny();//本期结算金额(含税)

        //1，先查出合同
        RentContractEntity contractEntity = rentContractService.selectById(settlementEntity.getContractId());
        BigDecimal sumOffsetMny = contractEntity.getSumOffsetMny()==null?BigDecimal.ZERO:contractEntity.getSumOffsetMny();//累计冲抵金额
        BigDecimal sumSettlementMny = contractEntity.getSumSettlementMny()==null?BigDecimal.ZERO:contractEntity.getSumSettlementMny();//累计结算金额(不含税)
        BigDecimal sumSettlementTaxMny = contractEntity.getSumSettlementTaxMny()==null?BigDecimal.ZERO:contractEntity.getSumSettlementTaxMny();//累计结算金额

        //弃审回写合同
        contractEntity.setSumOffsetMny(sumOffsetMny.subtract(offsetMny));
        contractEntity.setSumSettlementMny(sumSettlementMny.subtract(settlementMny));
        contractEntity.setSumSettlementTaxMny(sumSettlementTaxMny.subtract(settlementTaxMny));

        //弃审回写结算单上对应的金额，与合同保持一致
        logger.info("业务逻辑完成--"+contractEntity.getSumOffsetMny()+"    --"+contractEntity.getSumSettlementTaxMny());
        Boolean flag = rentContractService.saveOrUpdate(contractEntity,false);
        logger.info("业务逻辑完成--返回"+flag);
        //删除成本中心数据, 更新关联状态为未关联
        rentSettlementService.pullCost(billId);

        //更新凭证恢复到初始态
        if (!VoucherFlag.NO_NEED.equals(settlementEntity.getVoucherFlag())) {
            //有凭证则删除
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            String authority = request.getHeader("authority");
            if (authority == null) {
                logger.info("request-authority为空");
                authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
            }
            try {
                Callable<CommonResponse> voucherCallable = new VoucherCallable(false, settlementEntity, RequestContextHolder.getRequestAttributes(), authority);
                threadPool.submit(voucherCallable);
            } catch (Exception e) {
                logger.error(this.getClass() + "撤回凭证异常, ", e);
            } finally {
                threadPool.shutdown();
            }
        }
        if(flag){
            return CommonResponse.success();
        }else{
            return CommonResponse.error("审批回写异常!");
        }
    }
}
