/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.PurchaseChangeEntity;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.mapper.PurchaseChangeMapper;
import com.ejianc.business.equipment.service.IPurchaseChangeService;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.vo.PurchaseChangeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="PurchaseChangeService")
public class PurchaseChangeServiceImpl
extends BaseServiceImpl<PurchaseChangeMapper, PurchaseChangeEntity>
implements IPurchaseChangeService {
    private static final String PURCHASE_CHANGE_BILL_CODE = "EQUIPMENT_PURCHASE";
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<PurchaseChangeVO> saveOrUpdate(PurchaseChangeVO purchaseChangeVo) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseChangeEntity entity = null;
        List entitiesc = null;
        List entities = null;
        PurchaseContractEntity pcentity = new PurchaseContractEntity();
        if (StringUtils.isEmpty((CharSequence)purchaseChangeVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PURCHASE_CHANGE_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                purchaseChangeVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (purchaseChangeVo.getContractId() != null && purchaseChangeVo.getContractId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(PurchaseChangeEntity::getBillCode, (Object)purchaseChangeVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)purchaseChangeVo.getId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)purchaseChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)purchaseChangeVo.getId()));
            entitiesc = this.purchaseContractService.queryList(queryParam, false);
            pcentity.setId(purchaseChangeVo.getContractId());
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(PurchaseChangeEntity::getBillCode, (Object)purchaseChangeVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)purchaseChangeVo.getBillCode()));
            entitiesc = this.purchaseContractService.queryList(queryParam, false);
            purchaseChangeVo.setContractId(purchaseChangeVo.getId());
            pcentity.setId(purchaseChangeVo.getId());
            pcentity.setChangeVersion(purchaseChangeVo.getChangeVersion() + 1);
            purchaseChangeVo.setChangeVersion(Integer.valueOf(purchaseChangeVo.getChangeVersion() + 1));
            purchaseChangeVo.setId(null);
            purchaseChangeVo.setBeforeContractName(purchaseChangeVo.getContractName());
            if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getPurchasedetail())) {
                purchaseChangeVo.getPurchasedetail().forEach(vo -> {
                    vo.setContractDetailId(vo.getId());
                    vo.setId(null);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getPurchasefee())) {
                purchaseChangeVo.getPurchasefee().forEach(vo -> vo.setId(null));
            }
            if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getPurchaseclause())) {
                purchaseChangeVo.getPurchaseclause().forEach(vo -> vo.setId(null));
            }
        }
        if (entities != null && entities.size() > 0 && entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity = (PurchaseChangeEntity)((Object)BeanMapper.map((Object)purchaseChangeVo, PurchaseChangeEntity.class));
        super.saveOrUpdate((Object)entity, false);
        pcentity.setChangeStatus(2);
        pcentity.setChangingMny(entity.getContractMny());
        pcentity.setChangingTaxMny(entity.getContractTaxMny());
        pcentity.setChangeCode(entity.getBillCode());
        pcentity.setChangeId(entity.getId());
        this.purchaseContractService.update((Object)pcentity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)pcentity.getId()), false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), PurchaseChangeVO.class));
    }

    @Override
    public PurchaseChangeVO queryDetail(Long id) {
        PurchaseChangeEntity entity = (PurchaseChangeEntity)((Object)super.selectById((Serializable)id));
        PurchaseChangeVO purchaseChangeVo = (PurchaseChangeVO)BeanMapper.map((Object)((Object)entity), PurchaseChangeVO.class);
        return purchaseChangeVo;
    }

    @Override
    public void deletePurchaseChange(List<PurchaseChangeVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }
}

