/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.mapper.RentContractMapper;
import com.ejianc.business.equipment.service.IRentClauseService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.service.IRentCostService;
import com.ejianc.business.equipment.service.IRentDetailsService;
import com.ejianc.business.equipment.vo.RentClauseVO;
import com.ejianc.business.equipment.vo.RentContractVO;
import com.ejianc.business.equipment.vo.RentCostVO;
import com.ejianc.business.equipment.vo.RentDetailsVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RentContractService")
public class RentContractServiceImpl
extends BaseServiceImpl<RentContractMapper, RentContractEntity>
implements IRentContractService {
    private static final String RENT_CONTRACT_BILL_CODE = "EQUIPMENT_RENT";
    @Autowired
    private RentContractMapper rentContractMapper;
    @Autowired
    private IRentDetailsService rentDetailsService;
    @Autowired
    private IRentCostService rentCostService;
    @Autowired
    private IRentClauseService rentClauseService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<RentContractVO> saveOrUpdate(RentContractVO rentContractVo) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentContractEntity entity = null;
        Object operateType = null;
        if (StringUtils.isEmpty((CharSequence)rentContractVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(RENT_CONTRACT_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                rentContractVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (rentContractVo.getId() != null && rentContractVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(RentContractEntity::getBillCode, (Object)rentContractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)rentContractVo.getId());
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(RentContractEntity::getBillCode, (Object)rentContractVo.getBillCode());
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity = (RentContractEntity)((Object)BeanMapper.map((Object)rentContractVo, RentContractEntity.class));
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), RentContractVO.class));
    }

    @Override
    public RentContractVO queryDetail(Long id) {
        RentContractEntity entity = (RentContractEntity)((Object)this.rentContractMapper.selectById(id));
        if (entity != null) {
            List rentClauses;
            List rentCosts;
            RentContractVO rentContractVo = (RentContractVO)BeanMapper.map((Object)((Object)entity), RentContractVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)rentContractVo.getId()));
            queryParam.getOrderMap().put("createTime", "desc");
            List rentDetailss = this.rentDetailsService.queryList(queryParam, false);
            if (rentDetailss != null && rentDetailss.size() > 0) {
                List rentDetailsVos = BeanMapper.mapList((Iterable)rentDetailss, RentDetailsVO.class);
                rentContractVo.setRentdetails(rentDetailsVos);
            }
            if ((rentCosts = this.rentCostService.queryList(queryParam, false)) != null && rentCosts.size() > 0) {
                List rentCostVos = BeanMapper.mapList((Iterable)rentCosts, RentCostVO.class);
                rentContractVo.setRentcost(rentCostVos);
            }
            if ((rentClauses = this.rentClauseService.queryList(queryParam, false)) != null && rentClauses.size() > 0) {
                List rentClauseVos = BeanMapper.mapList((Iterable)rentClauses, RentClauseVO.class);
                rentContractVo.setRentclause(rentClauseVos);
            }
            return rentContractVo;
        }
        return null;
    }

    @Override
    public void deleteRentContract(List<Long> ids) {
        for (Long id : ids) {
            this.rentClauseService.deleteByContractId(id);
            this.rentCostService.deleteByContractId(id);
            this.rentDetailsService.deleteByContractId(id);
            this.rentContractMapper.deleteById(id);
        }
    }
}

