/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.bean.PurchaseSettlementEntity;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.bean.RentSettlementEntity;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IPurchaseSettlementService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.service.IRentSettlementService;
import com.ejianc.business.equipment.vo.RentContractResVO;
import com.ejianc.business.finance.pub.vo.PubContractSettleVO;
import com.ejianc.business.finance.pub.vo.PubContractVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/equipment/"})
public class EquipmentContractApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IPurchaseSettlementService purchaseSettleService;
    @Autowired
    private IRentSettlementService rentSettleService;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private ICustomerApi customerApi;

    @PostMapping(value={"getContract"})
    public CommonResponse<JSONObject> getContract(@RequestBody QueryParam param) {
        try {
            List fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("contractName");
            fuzzyFields.add("billCode");
            fuzzyFields.add("orgName");
            fuzzyFields.add("employeeName");
            fuzzyFields.add("customerName");
            fuzzyFields.add("supplierName");
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getOrderMap().put("createTime", "desc");
            param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
            IPage pageData = this.purchaseContractService.queryPage(param, false);
            List contractEntityList = pageData.getRecords();
            ArrayList<PubContractVO> contractVOList = new ArrayList<PubContractVO>();
            for (PurchaseContractEntity entity : contractEntityList) {
                PubContractVO vo = new PubContractVO();
                vo.setId(entity.getId());
                vo.setBillCode(entity.getBillCode());
                vo.setContractName(entity.getContractName());
                vo.setContractMny(entity.getContractTaxMny());
                vo.setContractType(Integer.valueOf(2));
                vo.setPurchaseType(entity.getPurchaseType());
                vo.setProjectId(entity.getProjectId());
                vo.setOrgId(entity.getOrgId());
                vo.setReceiveUnitId(entity.getSupplierId());
                vo.setSumInvoiceMny(entity.getSumInvoiceTaxMny());
                vo.setSumPayMny(entity.getSumPayMny());
                vo.setSumSettleMny(entity.getSumSettlementTaxMny());
                vo.setPayScale(entity.getPayScale());
                contractVOList.add(vo);
            }
            JSONObject page = new JSONObject();
            page.put("records", contractVOList);
            page.put("total", (Object)pageData.getTotal());
            page.put("current", (Object)pageData.getCurrent());
            page.put("size", (Object)pageData.getSize());
            page.put("pages", (Object)pageData.getPages());
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @PostMapping(value={"getContractSettle"})
    public CommonResponse<JSONObject> getContractSettle(@RequestBody QueryParam param) {
        try {
            List fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("billCode");
            fuzzyFields.add("orgName");
            fuzzyFields.add("employeeName");
            fuzzyFields.add("customerName");
            fuzzyFields.add("supplierName");
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getOrderMap().put("createTime", "desc");
            param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
            IPage pageData = this.purchaseSettleService.queryPage(param, false);
            List entityList = pageData.getRecords();
            ArrayList<PubContractSettleVO> voList = new ArrayList<PubContractSettleVO>();
            for (PurchaseSettlementEntity entity : entityList) {
                PubContractSettleVO vo = new PubContractSettleVO();
                vo.setId(entity.getId());
                vo.setBillCode(entity.getBillCode());
                vo.setSettleMny(entity.getSettlementTaxMny());
                vo.setCreateUserCode(entity.getCreateUserCode());
                vo.setCreateTime(entity.getCreateTime());
                voList.add(vo);
            }
            JSONObject page = new JSONObject();
            page.put("records", voList);
            page.put("total", (Object)pageData.getTotal());
            page.put("current", (Object)pageData.getCurrent());
            page.put("size", (Object)pageData.getSize());
            page.put("pages", (Object)pageData.getPages());
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @PostMapping(value={"getRentSettle"})
    public CommonResponse<JSONObject> getRentSettle(@RequestBody QueryParam param) {
        try {
            List fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("billCode");
            fuzzyFields.add("orgName");
            fuzzyFields.add("employeeName");
            fuzzyFields.add("customerName");
            fuzzyFields.add("supplierName");
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getOrderMap().put("createTime", "desc");
            param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
            IPage pageData = this.rentSettleService.queryPage(param, false);
            List entityList = pageData.getRecords();
            ArrayList<PubContractSettleVO> voList = new ArrayList<PubContractSettleVO>();
            for (RentSettlementEntity entity : entityList) {
                PubContractSettleVO vo = new PubContractSettleVO();
                vo.setId(entity.getId());
                vo.setBillCode(entity.getBillCode());
                vo.setSettleMny(entity.getSettlementTaxMny());
                vo.setCreateUserCode(entity.getCreateUserCode());
                vo.setCreateTime(entity.getCreateTime());
                voList.add(vo);
            }
            JSONObject page = new JSONObject();
            page.put("records", voList);
            page.put("total", (Object)pageData.getTotal());
            page.put("current", (Object)pageData.getCurrent());
            page.put("size", (Object)pageData.getSize());
            page.put("pages", (Object)pageData.getPages());
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @GetMapping(value={"updatePurchaseContractSumPayMny"})
    public CommonResponse<String> updatePurchaseContractSumPayMny(@RequestParam(value="contractId", required=true) Long contractId, @RequestParam(value="payMny") BigDecimal payMny, @RequestParam(value="prepayMny") BigDecimal prepayMny) {
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(contractId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u8bbe\u5907\u91c7\u8d2d\u5408\u540c\uff01");
        }
        BigDecimal sumPayMny = entity.getSumPayMny() != null ? entity.getSumPayMny() : new BigDecimal("0.00");
        sumPayMny = sumPayMny.add(payMny).setScale(8, 4);
        entity.setSumPayMny(sumPayMny);
        BigDecimal sumPrepayMny = entity.getSumPrepayMny() != null ? entity.getSumPrepayMny() : new BigDecimal("0.00");
        sumPrepayMny = sumPrepayMny.add(prepayMny).setScale(8, 4);
        entity.setSumPrepayMny(sumPrepayMny);
        this.purchaseContractService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u66f4\u65b0\u8bbe\u5907\u91c7\u8d2d\u5408\u540c\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u3001\u7d2f\u8ba1\u9884\u4ed8\u6b3e\u91d1\u989d\u6210\u529f\uff01");
    }

    @GetMapping(value={"updateRentContractSumPayMny"})
    public CommonResponse<String> updateRentContractSumPayMny(@RequestParam(value="contractId", required=true) Long contractId, @RequestParam(value="payMny") BigDecimal payMny, @RequestParam(value="prepayMny") BigDecimal prepayMny) {
        RentContractEntity entity = (RentContractEntity)((Object)this.rentContractService.selectById(contractId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u8bbe\u5907\u79df\u8d41\u5408\u540c\uff01");
        }
        BigDecimal sumPayMny = entity.getSumPayMny() != null ? entity.getSumPayMny() : new BigDecimal("0.00");
        sumPayMny = sumPayMny.add(payMny).setScale(8, 4);
        entity.setSumPayMny(sumPayMny);
        BigDecimal sumPrepayMny = entity.getSumPrepayMny() != null ? entity.getSumPrepayMny() : new BigDecimal("0.00");
        sumPrepayMny = sumPrepayMny.add(prepayMny).setScale(8, 4);
        entity.setSumPrepayMny(sumPrepayMny);
        this.rentContractService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u66f4\u65b0\u8bbe\u5907\u79df\u8d41\u5408\u540c\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u3001\u7d2f\u8ba1\u9884\u4ed8\u6b3e\u91d1\u989d\u6210\u529f\uff01");
    }

    @GetMapping(value={"updatePurchaseSettleSumPayMny"})
    public CommonResponse<String> updatePurchaseSettleSumPayMny(@RequestParam(value="settleId", required=true) Long settleId, @RequestParam(value="payMny") BigDecimal payMny) {
        PurchaseSettlementEntity entity = (PurchaseSettlementEntity)((Object)this.purchaseSettleService.selectById(settleId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u8bbe\u5907\u91c7\u8d2d\u7ed3\u7b97\u5355\uff01");
        }
        BigDecimal sumPayMny = entity.getSumPayMny() != null ? entity.getSumPayMny() : new BigDecimal("0.00");
        sumPayMny = sumPayMny.add(payMny).setScale(8, 4);
        entity.setSumPayMny(sumPayMny);
        this.purchaseSettleService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u66f4\u65b0\u8bbe\u5907\u91c7\u8d2d\u7ed3\u7b97\u5355\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u6210\u529f\uff01");
    }

    @GetMapping(value={"updateRentSettleSumPayMny"})
    public CommonResponse<String> updateRentSettleSumPayMny(@RequestParam(value="settleId", required=true) Long settleId, @RequestParam(value="payMny") BigDecimal payMny) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)this.rentSettleService.selectById(settleId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97\u5355\uff01");
        }
        BigDecimal sumPayMny = entity.getSumPayMny() != null ? entity.getSumPayMny() : new BigDecimal("0.00");
        sumPayMny = sumPayMny.add(payMny).setScale(8, 4);
        entity.setSumPayMny(sumPayMny);
        this.rentSettleService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u66f4\u65b0\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97\u5355\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u6210\u529f\uff01");
    }

    @PostMapping(value={"afterApproveInvoiceReceive"})
    public CommonResponse<JSONObject> afterApproveInvoiceReceive(@RequestParam(value="contractId") Long contractId, @RequestParam(value="invoiceMny") BigDecimal invoiceMny, @RequestParam(value="invoiceTaxMny") BigDecimal invoiceTaxMny) {
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(contractId));
        if (null != entity) {
            BigDecimal sumInvoiceMny = entity.getSumInvoiceMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceMny();
            BigDecimal sumInvoiceTaxMny = entity.getSumInvoiceTaxMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceTaxMny();
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)contractId);
            updateWrapper.set(PurchaseContractEntity::getSumInvoiceMny, (Object)sumInvoiceMny.add(invoiceMny));
            updateWrapper.set(PurchaseContractEntity::getSumInvoiceTaxMny, (Object)sumInvoiceTaxMny.add(invoiceTaxMny));
            boolean flag = this.purchaseContractService.update((Wrapper)updateWrapper);
            if (flag) {
                return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return CommonResponse.error((String)"\u66f4\u65b0\u5f02\u5e38");
        }
        return CommonResponse.error((String)"\u66f4\u65b0\u5f02\u5e38!\u672a\u83b7\u53d6\u5230\u5355\u636e\u4fe1\u606f");
    }

    @PostMapping(value={"afterRevocationInvoiceReceive"})
    public CommonResponse<JSONObject> afterRevocationInvoiceReceive(@RequestParam(value="contractId") Long contractId, @RequestParam(value="invoiceMny") BigDecimal invoiceMny, @RequestParam(value="invoiceTaxMny") BigDecimal invoiceTaxMny) {
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(contractId));
        if (null != entity) {
            BigDecimal sumInvoiceMny = entity.getSumInvoiceMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceMny();
            BigDecimal sumInvoiceTaxMny = entity.getSumInvoiceTaxMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceTaxMny();
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)contractId);
            updateWrapper.set(PurchaseContractEntity::getSumInvoiceMny, (Object)sumInvoiceMny.subtract(invoiceMny));
            updateWrapper.set(PurchaseContractEntity::getSumInvoiceTaxMny, (Object)sumInvoiceTaxMny.subtract(invoiceTaxMny));
            boolean flag = this.purchaseContractService.update((Wrapper)updateWrapper);
            if (flag) {
                return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return CommonResponse.error((String)"\u66f4\u65b0\u5f02\u5e38");
        }
        return CommonResponse.error((String)"\u66f4\u65b0\u5f02\u5e38!\u672a\u83b7\u53d6\u5230\u5355\u636e\u4fe1\u606f");
    }

    @GetMapping(value={"getContractById"})
    public CommonResponse<RentContractResVO> getContractById(@RequestParam(value="contractId") Long contractId) {
        RentContractEntity rentContractEntity = (RentContractEntity)((Object)this.rentContractService.selectById(contractId));
        RentContractResVO rentContractVO = (RentContractResVO)BeanMapper.map((Object)((Object)rentContractEntity), RentContractResVO.class);
        if (null != rentContractEntity) {
            CommonResponse supplierVOCommonResponse = this.supplierApi.queryById(rentContractEntity.getSupplierId());
            if (supplierVOCommonResponse.isSuccess()) {
                rentContractVO.setSupplierCreditCode(((SupplierVO)supplierVOCommonResponse.getData()).getSocialCreditCode());
            }
            CommonResponse customerVOCommonResponse = this.customerApi.detailById(rentContractEntity.getCustomerId());
            if (supplierVOCommonResponse.isSuccess()) {
                rentContractVO.setCustomerCreditCode(((CustomerVO)customerVOCommonResponse.getData()).getSocialCreditCode());
            }
        } else {
            return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25!");
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u6210\u529f", (Object)rentContractVO);
    }
}

