/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.bean.RentSettlementDetailEntity;
import com.ejianc.business.equipment.bean.RentSettlementEntity;
import com.ejianc.business.equipment.bean.RentUseRecordEntity;
import com.ejianc.business.equipment.mapper.RentSettlementMapper;
import com.ejianc.business.equipment.service.IRentContractDetailService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.service.IRentSettlementDetailService;
import com.ejianc.business.equipment.service.IRentSettlementService;
import com.ejianc.business.equipment.service.IRentUseRecordService;
import com.ejianc.business.equipment.vo.RentSettlementRecordVO;
import com.ejianc.business.equipment.vo.RentSettlementVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RentSettlementService")
public class RentSettlementServiceImpl
extends BaseServiceImpl<RentSettlementMapper, RentSettlementEntity>
implements IRentSettlementService {
    private static final String RENT_SETTLEMENT_BILL_CODE = "EQUIPMENT_RENT_SETTLEMENT";
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IRentContractDetailService rentContractDetailService;
    @Autowired
    private IRentSettlementDetailService rentSettlementDetailService;
    @Autowired
    private IRentUseRecordService rentUseRecordService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<RentSettlementVO> saveOrUpdate(RentSettlementVO rentSettlementVo) {
        BigDecimal sumOffsetMny;
        BigDecimal contractTaxMny;
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentSettlementEntity entity = null;
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(RentSettlementEntity::getContractId, (Object)rentSettlementVo.getContractId());
        if (null != rentSettlementVo.getId() && rentSettlementVo.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)rentSettlementVo.getId());
        }
        lambdachange.ne(RentSettlementEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(RentSettlementEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355!");
        }
        LambdaQueryWrapper lambdachange2 = Wrappers.lambdaQuery();
        lambdachange2.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange2.eq(RentSettlementEntity::getContractId, (Object)rentSettlementVo.getContractId());
        if (null != rentSettlementVo.getId() && rentSettlementVo.getId() > 0L) {
            lambdachange2.ne(BaseEntity::getId, (Object)rentSettlementVo.getId());
        }
        lambdachange2.in(RentSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambdachange2.gt(RentSettlementEntity::getSettlementDate, (Object)rentSettlementVo.getSettlementDate());
        int num2 = super.count((Wrapper)lambdachange2);
        if (num2 > 0) {
            throw new BusinessException("\u7ed3\u7b97\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u8be5\u5408\u540c\u5bf9\u5e94\u6700\u65b0\u7ed3\u7b97\u65e5\u671f!");
        }
        BigDecimal sumSettlementTaxMny = rentSettlementVo.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : rentSettlementVo.getSumSettlementTaxMny();
        BigDecimal settlementTaxMny = rentSettlementVo.getSettlementTaxMny() == null ? BigDecimal.ZERO : rentSettlementVo.getSettlementTaxMny();
        BigDecimal bigDecimal = contractTaxMny = rentSettlementVo.getContractTaxMny() == null ? BigDecimal.ZERO : rentSettlementVo.getContractTaxMny();
        if (contractTaxMny.compareTo(sumSettlementTaxMny.add(settlementTaxMny)) < 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u5df2\u7ecf\u8d85\u8fc7\u5408\u540c\u91d1\u989d!");
        }
        BigDecimal sumPayMny = rentSettlementVo.getSumPayMny() == null ? BigDecimal.ZERO : rentSettlementVo.getSumPayMny();
        BigDecimal offsetMny = rentSettlementVo.getOffsetMny() == null ? BigDecimal.ZERO : rentSettlementVo.getOffsetMny();
        BigDecimal bigDecimal2 = sumOffsetMny = rentSettlementVo.getSumOffsetMny() == null ? BigDecimal.ZERO : rentSettlementVo.getSumOffsetMny();
        if (StringUtils.isEmpty((CharSequence)rentSettlementVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(RENT_SETTLEMENT_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                rentSettlementVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity = (RentSettlementEntity)((Object)BeanMapper.map((Object)rentSettlementVo, RentSettlementEntity.class));
        super.saveOrUpdate((Object)entity, false);
        List<RentSettlementDetailEntity> rentdetail = entity.getRentdetail();
        if (rentdetail != null && rentdetail.size() > 0) {
            ArrayList<Long> useIds = new ArrayList<Long>();
            for (RentSettlementDetailEntity rentSettlementDetailEntity : rentdetail) {
                if (rentSettlementDetailEntity.getSource() != 3) continue;
                useIds.add(rentSettlementDetailEntity.getUseId());
            }
            if (useIds != null && useIds.size() > 0) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(BaseEntity::getId, useIds);
                updateWrapper.set(RentUseRecordEntity::getUseFlag, (Object)1);
                boolean bl = this.rentUseRecordService.update((Wrapper)updateWrapper);
            }
        }
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), RentSettlementVO.class));
    }

    @Override
    public RentSettlementVO queryDetail(Long id) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)super.selectById((Serializable)id));
        RentSettlementVO rentSettlementVo = (RentSettlementVO)BeanMapper.map((Object)((Object)entity), RentSettlementVO.class);
        return rentSettlementVo;
    }

    @Override
    public RentSettlementVO queryDetails(Long id) {
        RentContractEntity entity = (RentContractEntity)((Object)this.rentContractService.selectById(id));
        RentSettlementVO rentSettlementVO = (RentSettlementVO)BeanMapper.map((Object)((Object)entity), RentSettlementVO.class);
        rentSettlementVO.setContractId(rentSettlementVO.getId());
        rentSettlementVO.setId(null);
        rentSettlementVO.setBillCode(null);
        rentSettlementVO.setBillState(null);
        rentSettlementVO.setCreateUserCode(null);
        rentSettlementVO.setCreateTime(null);
        rentSettlementVO.setSettlementDate(new Date());
        rentSettlementVO.setUpdateUserCode(null);
        rentSettlementVO.setUpdateTime(null);
        rentSettlementVO.setRentdetail(null);
        rentSettlementVO.setRentfee(null);
        return rentSettlementVO;
    }

    @Override
    public void deleteRentSettlement(List<RentSettlementVO> vos) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (RentSettlementVO rentSettlementVO : vos) {
            ids.add(rentSettlementVO.getId());
        }
        if (ids != null && ids.size() > 0) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(RentSettlementDetailEntity::getSettlementId, ids);
            List rentSettlementDetailEntities = this.rentSettlementDetailService.list((Wrapper)lambda);
            if (rentSettlementDetailEntities != null && rentSettlementDetailEntities.size() > 0) {
                ArrayList<Long> useIds = new ArrayList<Long>();
                for (RentSettlementDetailEntity rentSettlementDetailEntity : rentSettlementDetailEntities) {
                    if (rentSettlementDetailEntity.getSource() != 3) continue;
                    useIds.add(rentSettlementDetailEntity.getUseId());
                }
                if (useIds != null && useIds.size() > 0) {
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.in(BaseEntity::getId, useIds);
                    updateWrapper.set(RentUseRecordEntity::getUseFlag, (Object)0);
                    boolean bl = this.rentUseRecordService.update((Wrapper)updateWrapper);
                }
            }
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public RentSettlementRecordVO querySettlementRecord(Long id) {
        RentSettlementRecordVO vo = new RentSettlementRecordVO();
        RentContractEntity entity = (RentContractEntity)((Object)this.rentContractService.selectById(id));
        BigDecimal sumSettlementTaxMny = entity.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : entity.getSumSettlementTaxMny();
        BigDecimal contractTaxMny = entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny();
        vo.setContractTaxMny(contractTaxMny);
        vo.setContractId(id);
        vo.setSumSettlementTaxMny(sumSettlementTaxMny);
        if (sumSettlementTaxMny.compareTo(BigDecimal.ZERO) > 0 && contractTaxMny.compareTo(BigDecimal.ZERO) > 0) {
            vo.setSumScale(new BigDecimal(100).multiply(sumSettlementTaxMny.divide(contractTaxMny, 8, 5)));
        } else {
            vo.setSumScale(BigDecimal.ZERO);
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(RentSettlementEntity::getContractId, (Object)id);
        lambda.in(RentSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            List rentSettlementVOList = BeanMapper.mapList((Iterable)entities, RentSettlementVO.class);
            rentSettlementVOList.forEach(vos -> vos.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vos.getBillState()).getDescription()));
            vo.setSettlementRecord(rentSettlementVOList);
        }
        return vo;
    }
}

