package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.PurchaseContractDetailEntity;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.bean.PurchaseSettlementEntity;
import com.ejianc.business.equipment.mapper.PurchaseSettlementMapper;
import com.ejianc.business.equipment.service.IPurchaseContractDetailService;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IPurchaseSettlementService;
import com.ejianc.business.equipment.vo.PurchaseSettlementDetailVO;
import com.ejianc.business.equipment.vo.PurchaseSettlementRecordVO;
import com.ejianc.business.equipment.vo.PurchaseSettlementVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * <p>
 * 设备合同结算表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("PurchaseSettlementService")
public class PurchaseSettlementServiceImpl extends BaseServiceImpl<PurchaseSettlementMapper, PurchaseSettlementEntity> implements IPurchaseSettlementService {

    private static final String PURCHASE_SETTLEMENT_BILL_CODE = "EQUIPMENT_SETTLEMENT";

    @Autowired
    private IPurchaseContractService purchaseContractService;


    @Autowired
    private IPurchaseContractDetailService purchaseContractDetailService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPayContractApi payContractApi;

    @Override
    public CommonResponse<PurchaseSettlementVO> saveOrUpdate(PurchaseSettlementVO purchaseSettlementVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseSettlementEntity entity = null;
        //合同只能存在一条未生效的
        LambdaQueryWrapper<PurchaseSettlementEntity> lambdachange = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambdachange.eq(PurchaseSettlementEntity::getTenantId, tenantId);
        lambdachange.eq(PurchaseSettlementEntity::getContractId,purchaseSettlementVo.getContractId());
        lambdachange.eq(PurchaseSettlementEntity::getOrgId,purchaseSettlementVo.getOrgId());
        if(null!=purchaseSettlementVo.getId()&&purchaseSettlementVo.getId()>0){
            lambdachange.ne(PurchaseSettlementEntity::getId,purchaseSettlementVo.getId());
        }
        lambdachange.ne(PurchaseSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(PurchaseSettlementEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同该组织下已存在未生效的结算单!");
        }

        LambdaQueryWrapper<PurchaseSettlementEntity> lambdachange2 = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambdachange2.eq(PurchaseSettlementEntity::getTenantId, tenantId);
        lambdachange2.eq(PurchaseSettlementEntity::getContractId,purchaseSettlementVo.getContractId());
        lambdachange2.eq(PurchaseSettlementEntity::getOrgId,purchaseSettlementVo.getOrgId());
        if(null!=purchaseSettlementVo.getId()&&purchaseSettlementVo.getId()>0){
            lambdachange2.ne(PurchaseSettlementEntity::getId,purchaseSettlementVo.getId());
        }
        lambdachange2.in(PurchaseSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambdachange2.gt(PurchaseSettlementEntity ::getSettlementDate,purchaseSettlementVo.getSettlementDate());
        int num2 = super.count(lambdachange2);
        if(num2>0){
            throw new BusinessException("结算日期必须大于等于该合同对应最新结算日期!");
        }
        BigDecimal settlementTaxMny = purchaseSettlementVo.getSettlementTaxMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getSettlementTaxMny();
        BigDecimal offsetMny = purchaseSettlementVo.getOffsetMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getOffsetMny();//本次冲抵金额
        BigDecimal syMny = purchaseSettlementVo.getSymny()==null?BigDecimal.ZERO:purchaseSettlementVo.getSymny();//剩余冲抵金额
        if(offsetMny.compareTo(syMny)>0){
            throw new BusinessException("本次冲抵金额不允许大于剩余可冲抵金额!");
        }
        if(offsetMny.compareTo(settlementTaxMny)>0){
            throw new BusinessException("本次冲抵金额不允许大于本期结算金额");
        }
        if(StringUtils.isEmpty(purchaseSettlementVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PURCHASE_SETTLEMENT_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                purchaseSettlementVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity = BeanMapper.map(purchaseSettlementVo, PurchaseSettlementEntity.class);
        super.saveOrUpdate(entity,false);
        PurchaseSettlementVO vo = BeanMapper.map(entity, PurchaseSettlementVO.class);
        BigDecimal c = purchaseSettlementVo.getContractTaxMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getContractTaxMny();
        BigDecimal cc = purchaseSettlementVo.getSumSettlementTaxMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getSumSettlementTaxMny();
        if(c.compareTo(BigDecimal.ZERO)>0&&cc.compareTo(BigDecimal.ZERO)>0){
            vo.setLjjsbl(new BigDecimal(100).multiply(cc.divide(c,8,ROUND_HALF_DOWN)));
        }
        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        BigDecimal sumPrePayMny =entity.getSumPrepayMny()==null?BigDecimal.ZERO:entity.getSumPrepayMny();
        BigDecimal sumOffsetMny =entity.getSumOffsetMny()==null?BigDecimal.ZERO:entity.getSumOffsetMny();
        vo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        return CommonResponse.success(vo);
    }
    
    @Override
    public PurchaseSettlementVO queryDetail(Long id) {
        PurchaseSettlementEntity entity = super.selectById(id);
        PurchaseSettlementVO purchaseSettlementVo = BeanMapper.map(entity, PurchaseSettlementVO.class);
        BigDecimal c = purchaseSettlementVo.getContractTaxMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getContractTaxMny();
        BigDecimal cc = purchaseSettlementVo.getSumSettlementTaxMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getSumSettlementTaxMny();
        if(c.compareTo(BigDecimal.ZERO)>0&&cc.compareTo(BigDecimal.ZERO)>0){
            purchaseSettlementVo.setLjjsbl(new BigDecimal(100).multiply(cc.divide(c,8,ROUND_HALF_DOWN)));
        }
        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        BigDecimal sumPrePayMny =entity.getSumPrepayMny()==null?BigDecimal.ZERO:entity.getSumPrepayMny();
        BigDecimal sumOffsetMny =entity.getSumOffsetMny()==null?BigDecimal.ZERO:entity.getSumOffsetMny();
        purchaseSettlementVo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        return purchaseSettlementVo;
    }
    @Override
    public PurchaseSettlementVO queryDetails(Long id) {
        PurchaseContractEntity entity = purchaseContractService.selectById(id);
        PurchaseSettlementVO purchaseSettlementVO = BeanMapper.map(entity, PurchaseSettlementVO.class);
        //新增逻辑处理
        purchaseSettlementVO.setContractId(purchaseSettlementVO.getId());
        //新增即点变更按钮穿透过来，此时ID为合同id
        purchaseSettlementVO.setId(null);
        purchaseSettlementVO.setBillCode(null);
        purchaseSettlementVO.setBillState(null);
        purchaseSettlementVO.setCreateUserCode(null);
        purchaseSettlementVO.setCreateTime(null);
        purchaseSettlementVO.setSettlementDate(new Date());
        purchaseSettlementVO.setUpdateUserCode(null);
        purchaseSettlementVO.setUpdateTime(null);
        purchaseSettlementVO.setPurchasedetail(null);
        purchaseSettlementVO.setPurchasefee(null);
        purchaseSettlementVO.setTaxMny(BigDecimal.ZERO);

        CommonResponse<SumPayMnyVO> sumPayMnyVO = payContractApi.getSumPayMny(id,entity.getOrgId());
        if(!sumPayMnyVO.isSuccess()) {
            throw new BusinessException("获取付款信息失败，请刷新后再试！");
        }
        BigDecimal sumPayMny = sumPayMnyVO.getData().getSumPayMny();
        BigDecimal sumPrePayMny = sumPayMnyVO.getData().getSumPrePayMny();
        purchaseSettlementVO.setSumPayMny(sumPayMny==null?BigDecimal.ZERO:sumPayMny);
        purchaseSettlementVO.setSumPrepayMny(sumPrePayMny==null?BigDecimal.ZERO:sumPrePayMny);
        LambdaQueryWrapper<PurchaseSettlementEntity> lambdachange = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambdachange.eq(PurchaseSettlementEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdachange.eq(PurchaseSettlementEntity::getContractId,id);
        lambdachange.eq(PurchaseSettlementEntity::getOrgId,entity.getOrgId());
        lambdachange.in(PurchaseSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<PurchaseSettlementEntity> list = super.list(lambdachange);
        if(CollectionUtils.isNotEmpty(list)){
            final BigDecimal[] settlementMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP),new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            list.forEach(e-> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettlementTaxMny()==null? BigDecimal.ZERO:e.getSettlementTaxMny());
                settlementMoney[1] = settlementMoney[1].add(e.getOffsetMny()==null? BigDecimal.ZERO:e.getOffsetMny());
            });
            //累计结算金额
            purchaseSettlementVO.setSumSettlementTaxMny(settlementMoney[0]);
            //累计冲抵金额
            purchaseSettlementVO.setSumOffsetMny(settlementMoney[1]);
        }
        BigDecimal sumOffsetMnys = purchaseSettlementVO.getSumOffsetMny()==null?BigDecimal.ZERO:purchaseSettlementVO.getSumOffsetMny();
        if(purchaseSettlementVO.getSumPrepayMny().compareTo(BigDecimal.ZERO)>=0&&sumOffsetMnys.compareTo(BigDecimal.ZERO)>=0){
            purchaseSettlementVO.setSymny(purchaseSettlementVO.getSumPrepayMny().subtract(sumOffsetMnys));
        }

        BigDecimal c = purchaseSettlementVO.getContractTaxMny()==null?BigDecimal.ZERO:purchaseSettlementVO.getContractTaxMny();
        BigDecimal cc = purchaseSettlementVO.getSumSettlementTaxMny()==null?BigDecimal.ZERO:purchaseSettlementVO.getSumSettlementTaxMny();
        if(c.compareTo(BigDecimal.ZERO)>0&&cc.compareTo(BigDecimal.ZERO)>0){
            purchaseSettlementVO.setLjjsbl(new BigDecimal(100).multiply(cc.divide(c,8,ROUND_HALF_DOWN)));
        }
        return purchaseSettlementVO;
    }
    @Override
    public void deletePurchaseSettlement(List<PurchaseSettlementVO> vos) {
        super.removeByIds(vos.stream().map(PurchaseSettlementVO::getId).collect(Collectors.toList()),false);
    }

    @Override
    public PurchaseSettlementRecordVO querySettlementRecord(Long id) {
        PurchaseSettlementRecordVO vo = new PurchaseSettlementRecordVO();
        PurchaseContractEntity entity = purchaseContractService.selectById(id);
        BigDecimal sumSettlementTaxMny = entity.getSumSettlementTaxMny()==null?BigDecimal.ZERO:entity.getSumSettlementTaxMny();//累计结算金额
        BigDecimal contractTaxMny = entity.getContractTaxMny()==null?BigDecimal.ZERO:entity.getContractTaxMny();//合同金额
        vo.setContractTaxMny(contractTaxMny);
        vo.setContractId(id);
        vo.setSumSettlementTaxMny(sumSettlementTaxMny);
        if(sumSettlementTaxMny.compareTo(BigDecimal.ZERO)>0&&contractTaxMny.compareTo(BigDecimal.ZERO)>0){
            vo.setSumScale(new BigDecimal(100).multiply(sumSettlementTaxMny.divide(contractTaxMny,8,ROUND_HALF_DOWN)));
        }else{
            vo.setSumScale(BigDecimal.ZERO);
        }

        LambdaQueryWrapper<PurchaseSettlementEntity> lambda = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambda.eq(PurchaseSettlementEntity::getContractId,id);
        lambda.in(PurchaseSettlementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<PurchaseSettlementEntity> entities = super.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)){
            vo.setSettlementRecord(BeanMapper.mapList(entities, PurchaseSettlementVO.class));
        }
        return vo;
    }
}
