/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.service.IApplyService;
import com.ejianc.business.equipment.vo.ApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"apply"})
public class ApplyController {
    @Autowired
    private IApplyService applyService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ApplyVO> saveOrUpdate(@RequestBody ApplyVO applyVo) {
        return this.applyService.saveOrUpdate(applyVo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ApplyVO> queryDetail(@RequestParam Long id) {
        ApplyVO applyVo = this.applyService.queryDetail(id);
        return CommonResponse.success((Object)applyVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplyVO> vos) {
        this.applyService.deleteApply(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("equipmentName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.applyService.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ApplyVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/applyRefTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> applyRefTree(@RequestParam(required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        List<ApplyVO> dataList = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            Long projectId = null;
            String signDate = null;
            if (StringUtils.isNotBlank((CharSequence)condition)) {
                Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
                if (null != conditionMap.get("projectId")) {
                    projectId = Long.valueOf(conditionMap.get("projectId").toString());
                    params.put("projectId", projectId);
                }
                if (null != conditionMap.get("signDate")) {
                    signDate = conditionMap.get("signDate").toString().substring(0, 10);
                    params.put("signDate", signDate);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                params.put("searchText", searchText);
            }
            params.put("tenantId", InvocationInfoProxy.getTenantid());
            ArrayList billState = new ArrayList();
            dataList = this.applyService.queryListTree(params);
            List map = new ArrayList();
            if (dataList != null && dataList.size() > 0) {
                for (ApplyVO applyVO : dataList) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                    String plandate = formatter.format(applyVO.getPlanDate());
                    applyVO.setName(applyVO.getBillCode() + "+" + plandate);
                }
                map = BeanMapper.mapList(dataList, Map.class);
                return ResultAsTree.createTreeData(map);
            }
            return ResultAsTree.createTreeData(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/applyTree"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ApplyVO>> applyTree() {
        List<ApplyVO> list = this.applyService.applyTree();
        return CommonResponse.success(list);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        IPage pageData;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("equipmentName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        if (null != (pageData = this.applyService.queryPage(param, false)).getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), ApplyVO.class);
            list.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
            HashMap<String, List> beans = new HashMap<String, List>();
            beans.put("records", list);
            ExcelExport.getInstance().export("applyExport.xlsx", beans, response);
        }
    }
}

