/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.vo.PurchaseContractVO;
import com.ejianc.business.equipment.vo.RentContractPayVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"purchaseContract"})
public class PurchaseContractController {
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IPayContractApi payContractApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseContractVO> saveOrUpdate(@RequestBody PurchaseContractVO purchaseContractVo) {
        return this.purchaseContractService.saveOrUpdate(purchaseContractVo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseContractVO> queryDetail(@RequestParam Long id) {
        PurchaseContractVO purchaseContractVo = this.purchaseContractService.queryDetail(id);
        return CommonResponse.success((Object)purchaseContractVo);
    }

    @RequestMapping(value={"/queryInvoiceDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceReceiveRecordVO> queryInvoiceDetail(@RequestParam Long id) {
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(id));
        CommonResponse res = this.invoiceApi.getInvoiceReceiveRecord(id);
        if (!res.isSuccess() || !res.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u6536\u7968\u4fe1\u606f\u5931\u8d25\uff01");
        }
        InvoiceReceiveRecordVO vo = (InvoiceReceiveRecordVO)res.getData();
        if (null != vo) {
            vo.setContractTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        }
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/queryPayDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentContractPayVO> queryPayDetail(@RequestParam Long id) {
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(id));
        RentContractPayVO rentContractPayVO = (RentContractPayVO)BeanMapper.map((Object)((Object)entity), RentContractPayVO.class);
        CommonResponse sumPayMnyVOList = this.payContractApi.getSumPayMnyVOList(id, null);
        if (!sumPayMnyVOList.isSuccess() || !sumPayMnyVOList.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u6536\u7968\u4fe1\u606f\u5931\u8d25\uff01");
        }
        BigDecimal sumPayMny = ((SumPayMnyVO)sumPayMnyVOList.getData()).getSumPayMny() == null ? BigDecimal.ZERO : ((SumPayMnyVO)sumPayMnyVOList.getData()).getSumPayMny();
        BigDecimal sumSettlementTaxMny = entity.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : entity.getSumSettlementTaxMny();
        rentContractPayVO.setContractId(((SumPayMnyVO)sumPayMnyVOList.getData()).getContractId());
        rentContractPayVO.setSumPayMny(sumPayMny);
        rentContractPayVO.setContractVOList(((SumPayMnyVO)sumPayMnyVOList.getData()).getContractVOList());
        rentContractPayVO.setSumUnPayMny(sumSettlementTaxMny.subtract(sumPayMny));
        return CommonResponse.success((Object)rentContractPayVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseContractVO> vos) {
        this.purchaseContractService.deletePurchaseContract(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getComplexParams().add(this.getPageQueryParam(null));
        IPage pageData = this.purchaseContractService.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.purchaseContractService.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), PurchaseContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("PurchaseCount", contractAmountMap);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @GetMapping(value={"/purchaseContractRef"})
    public CommonResponse<IPage<PurchaseContractVO>> projectListRefe(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        JSONObject jsonObject = new JSONObject();
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        Long orgId = null;
        String type = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
            if (null != conditionMap.get("type")) {
                type = conditionMap.get("type").toString();
            }
        }
        if (type != null && "pay".equals(type)) {
            queryParam.getComplexParams().add(this.getComplexParamForPay(orgId));
        } else {
            queryParam.getComplexParams().add(this.getPageQueryParam(null));
        }
        queryParam.getOrderMap().put("create_time", "desc");
        IPage pageData = this.purchaseContractService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), PurchaseContractVO.class));
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @PostMapping(value={"changeState"})
    public CommonResponse<String> changeState(@RequestBody PurchaseContractVO purchaseContractVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)purchaseContractVO.getId());
        updateWrapper.set(PurchaseContractEntity::getContractStatus, (Object)purchaseContractVO.getContractStatus());
        this.purchaseContractService.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u4fee\u6539\u5408\u540c\u72b6\u6001\u6210\u529f\uff01");
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        JSONObject resp = new JSONObject();
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("orgName");
        queryParam.getFuzzyFields().add("employeeName");
        queryParam.getFuzzyFields().add("customerName");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getComplexParams().add(this.getPageQueryParam(null));
        IPage pageData = this.purchaseContractService.queryPage(queryParam, false);
        HashMap<String, List> beans = new HashMap<String, List>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), PurchaseContractVO.class);
            list.forEach(vo -> {
                if ("1".equals(vo.getContractStatus())) {
                    vo.setContractStatus("\u672a\u7b7e\u8ba2");
                } else if ("2".equals(vo.getContractStatus())) {
                    vo.setContractStatus("\u5c65\u7ea6\u4e2d");
                } else if ("3".equals(vo.getContractStatus())) {
                    vo.setContractStatus("\u5df2\u5c01\u8d26");
                }
                vo.setPurchaseTypeName("1".equals(vo.getPurchaseType()) ? "\u81ea\u91c7" : "\u96c6\u91c7");
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            });
            beans.put("records", list);
            ExcelExport.getInstance().export("contract-export.xlsx", beans, response);
        }
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
        CommonResponse parentOrgResp = this.orgApi.findParentsByOrgId(orgId);
        if (!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList parentOrgIds = new ArrayList();
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(((List)parentOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("org_id", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        if (CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("purchase_type", new Parameter("eq", (Object)"2"));
            c3.getParams().put("org_id", new Parameter("in", parentOrgIds));
            c1.getComplexParams().add(c3);
        }
        c1.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        return c1;
    }

    public ComplexParam getComplexParamForPay(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        orgId = orgId != null ? orgId : InvocationInfoProxy.getOrgId();
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("purchase_type", new Parameter("eq", (Object)"1"));
        c2.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        c1.getComplexParams().add(c2);
        List<Long> allOrgIds = this.getOrgUpToDownList();
        if (!allOrgIds.isEmpty()) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("purchase_type", new Parameter("eq", (Object)"2"));
            c3.getParams().put("org_id", new Parameter("in", this.getOrgUpToDownList()));
            c1.getComplexParams().add(c3);
        }
        c1.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        return c1;
    }

    public List<Long> getOrgUpToDownList() {
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
        CommonResponse parentOrgResp = this.orgApi.findParentsByOrgId(orgId);
        if (!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u672c\u4e0a\u52a0\u672c\u4e0b\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList parentIds = new ArrayList();
        ArrayList<Long> childIds = new ArrayList<Long>();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentIds.addAll(((List)parentOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentIds.remove(orgId);
        childIds.addAll(parentIds);
        return childIds;
    }
}

