/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.bean.PurchaseSettlementEntity;
import com.ejianc.business.equipment.mapper.PurchaseSettlementMapper;
import com.ejianc.business.equipment.service.IPurchaseContractDetailService;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IPurchaseSettlementService;
import com.ejianc.business.equipment.vo.PurchaseSettlementRecordVO;
import com.ejianc.business.equipment.vo.PurchaseSettlementVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="PurchaseSettlementService")
public class PurchaseSettlementServiceImpl
extends BaseServiceImpl<PurchaseSettlementMapper, PurchaseSettlementEntity>
implements IPurchaseSettlementService {
    private static final String PURCHASE_SETTLEMENT_BILL_CODE = "EQUIPMENT_SETTLEMENT";
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IPurchaseContractDetailService purchaseContractDetailService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public CommonResponse<PurchaseSettlementVO> saveOrUpdate(PurchaseSettlementVO purchaseSettlementVo) {
        BigDecimal cc;
        BigDecimal syMny;
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseSettlementEntity entity = null;
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(PurchaseSettlementEntity::getContractId, (Object)purchaseSettlementVo.getContractId());
        lambdachange.eq(PurchaseSettlementEntity::getOrgId, (Object)purchaseSettlementVo.getOrgId());
        if (null != purchaseSettlementVo.getId() && purchaseSettlementVo.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)purchaseSettlementVo.getId());
        }
        lambdachange.ne(PurchaseSettlementEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(PurchaseSettlementEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u8be5\u7ec4\u7ec7\u4e0b\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355!");
        }
        LambdaQueryWrapper lambdachange2 = Wrappers.lambdaQuery();
        lambdachange2.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange2.eq(PurchaseSettlementEntity::getContractId, (Object)purchaseSettlementVo.getContractId());
        lambdachange2.eq(PurchaseSettlementEntity::getOrgId, (Object)purchaseSettlementVo.getOrgId());
        if (null != purchaseSettlementVo.getId() && purchaseSettlementVo.getId() > 0L) {
            lambdachange2.ne(BaseEntity::getId, (Object)purchaseSettlementVo.getId());
        }
        lambdachange2.in(PurchaseSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambdachange2.gt(PurchaseSettlementEntity::getSettlementDate, (Object)purchaseSettlementVo.getSettlementDate());
        int num2 = super.count((Wrapper)lambdachange2);
        if (num2 > 0) {
            throw new BusinessException("\u7ed3\u7b97\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8be5\u5408\u540c\u5bf9\u5e94\u6700\u65b0\u7ed3\u7b97\u65e5\u671f!");
        }
        BigDecimal settlementTaxMny = purchaseSettlementVo.getSettlementTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getSettlementTaxMny();
        BigDecimal offsetMny = purchaseSettlementVo.getOffsetMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getOffsetMny();
        BigDecimal bigDecimal = syMny = purchaseSettlementVo.getSymny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getSymny();
        if (offsetMny.compareTo(syMny) > 0) {
            throw new BusinessException("\u672c\u6b21\u51b2\u62b5\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5269\u4f59\u53ef\u51b2\u62b5\u91d1\u989d!");
        }
        if (offsetMny.compareTo(settlementTaxMny) > 0) {
            throw new BusinessException("\u672c\u6b21\u51b2\u62b5\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u672c\u671f\u7ed3\u7b97\u91d1\u989d");
        }
        if (StringUtils.isEmpty((CharSequence)purchaseSettlementVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PURCHASE_SETTLEMENT_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                purchaseSettlementVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity = (PurchaseSettlementEntity)((Object)BeanMapper.map((Object)purchaseSettlementVo, PurchaseSettlementEntity.class));
        super.saveOrUpdate((Object)entity, false);
        PurchaseSettlementVO vo = (PurchaseSettlementVO)BeanMapper.map((Object)((Object)entity), PurchaseSettlementVO.class);
        BigDecimal c = purchaseSettlementVo.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getContractTaxMny();
        BigDecimal bigDecimal2 = cc = purchaseSettlementVo.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getSumSettlementTaxMny();
        if (c.compareTo(BigDecimal.ZERO) > 0 && cc.compareTo(BigDecimal.ZERO) > 0) {
            vo.setLjjsbl(new BigDecimal(100).multiply(cc.divide(c, 8, 5)));
        }
        BigDecimal sumPrePayMny = entity.getSumPrepayMny() == null ? BigDecimal.ZERO : entity.getSumPrepayMny();
        BigDecimal sumOffsetMny = entity.getSumOffsetMny() == null ? BigDecimal.ZERO : entity.getSumOffsetMny();
        vo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        return CommonResponse.success((Object)vo);
    }

    @Override
    public PurchaseSettlementVO queryDetail(Long id) {
        BigDecimal cc;
        PurchaseSettlementEntity entity = (PurchaseSettlementEntity)((Object)super.selectById((Serializable)id));
        PurchaseSettlementVO purchaseSettlementVo = (PurchaseSettlementVO)BeanMapper.map((Object)((Object)entity), PurchaseSettlementVO.class);
        BigDecimal c = purchaseSettlementVo.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getContractTaxMny();
        BigDecimal bigDecimal = cc = purchaseSettlementVo.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getSumSettlementTaxMny();
        if (c.compareTo(BigDecimal.ZERO) > 0 && cc.compareTo(BigDecimal.ZERO) > 0) {
            purchaseSettlementVo.setLjjsbl(new BigDecimal(100).multiply(cc.divide(c, 8, 5)));
        }
        BigDecimal sumPrePayMny = entity.getSumPrepayMny() == null ? BigDecimal.ZERO : entity.getSumPrepayMny();
        BigDecimal sumOffsetMny = entity.getSumOffsetMny() == null ? BigDecimal.ZERO : entity.getSumOffsetMny();
        purchaseSettlementVo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        return purchaseSettlementVo;
    }

    @Override
    public PurchaseSettlementVO queryDetails(Long id) {
        BigDecimal cc;
        BigDecimal sumOffsetMnys;
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(id));
        PurchaseSettlementVO purchaseSettlementVO = (PurchaseSettlementVO)BeanMapper.map((Object)((Object)entity), PurchaseSettlementVO.class);
        purchaseSettlementVO.setContractId(purchaseSettlementVO.getId());
        purchaseSettlementVO.setId(null);
        purchaseSettlementVO.setBillCode(null);
        purchaseSettlementVO.setBillState(null);
        purchaseSettlementVO.setCreateUserCode(null);
        purchaseSettlementVO.setCreateTime(null);
        purchaseSettlementVO.setSettlementDate(new Date());
        purchaseSettlementVO.setUpdateUserCode(null);
        purchaseSettlementVO.setUpdateTime(null);
        purchaseSettlementVO.setPurchasedetail(null);
        purchaseSettlementVO.setPurchasefee(null);
        purchaseSettlementVO.setTaxMny(BigDecimal.ZERO);
        CommonResponse sumPayMnyVO = this.payContractApi.getSumPayMny(id, entity.getOrgId());
        if (!sumPayMnyVO.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\uff01");
        }
        BigDecimal sumPayMny = ((SumPayMnyVO)sumPayMnyVO.getData()).getSumPayMny();
        BigDecimal sumPrePayMny = ((SumPayMnyVO)sumPayMnyVO.getData()).getSumPrePayMny();
        purchaseSettlementVO.setSumPayMny(sumPayMny == null ? BigDecimal.ZERO : sumPayMny);
        purchaseSettlementVO.setSumPrepayMny(sumPrePayMny == null ? BigDecimal.ZERO : sumPrePayMny);
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambdachange.eq(PurchaseSettlementEntity::getContractId, (Object)id);
        lambdachange.eq(PurchaseSettlementEntity::getOrgId, (Object)entity.getOrgId());
        lambdachange.in(PurchaseSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = super.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal[] settlementMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4), new BigDecimal("0.00").setScale(2, 4)};
            list.forEach(e -> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettlementTaxMny() == null ? BigDecimal.ZERO : e.getSettlementTaxMny());
                settlementMoney[1] = settlementMoney[1].add(e.getOffsetMny() == null ? BigDecimal.ZERO : e.getOffsetMny());
            });
            purchaseSettlementVO.setSumSettlementTaxMny(settlementMoney[0]);
            purchaseSettlementVO.setSumOffsetMny(settlementMoney[1]);
        }
        BigDecimal bigDecimal = sumOffsetMnys = purchaseSettlementVO.getSumOffsetMny() == null ? BigDecimal.ZERO : purchaseSettlementVO.getSumOffsetMny();
        if (purchaseSettlementVO.getSumPrepayMny().compareTo(BigDecimal.ZERO) >= 0 && sumOffsetMnys.compareTo(BigDecimal.ZERO) >= 0) {
            purchaseSettlementVO.setSymny(purchaseSettlementVO.getSumPrepayMny().subtract(sumOffsetMnys));
        }
        BigDecimal c = purchaseSettlementVO.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVO.getContractTaxMny();
        BigDecimal bigDecimal2 = cc = purchaseSettlementVO.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVO.getSumSettlementTaxMny();
        if (c.compareTo(BigDecimal.ZERO) > 0 && cc.compareTo(BigDecimal.ZERO) > 0) {
            purchaseSettlementVO.setLjjsbl(new BigDecimal(100).multiply(cc.divide(c, 8, 5)));
        }
        return purchaseSettlementVO;
    }

    @Override
    public void deletePurchaseSettlement(List<PurchaseSettlementVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public PurchaseSettlementRecordVO querySettlementRecord(Long id) {
        PurchaseSettlementRecordVO vo = new PurchaseSettlementRecordVO();
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(id));
        BigDecimal contractTaxMny = entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny();
        vo.setContractTaxMny(contractTaxMny);
        vo.setContractId(id);
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PurchaseSettlementEntity::getContractId, (Object)id);
        lambda.in(PurchaseSettlementEntity::getOrgId, commonOrgIds);
        lambda.in(PurchaseSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List entities = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            BigDecimal sumSettlementTaxMny;
            BigDecimal[] settlementMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4)};
            entities.forEach(e -> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettlementTaxMny() == null ? BigDecimal.ZERO : e.getSettlementTaxMny());
            });
            vo.setSumSettlementTaxMny(settlementMoney[0]);
            BigDecimal bigDecimal = sumSettlementTaxMny = vo.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : vo.getSumSettlementTaxMny();
            if (sumSettlementTaxMny.compareTo(BigDecimal.ZERO) > 0 && contractTaxMny.compareTo(BigDecimal.ZERO) > 0) {
                vo.setSumScale(new BigDecimal(100).multiply(sumSettlementTaxMny.divide(contractTaxMny, 8, 5)));
            } else {
                vo.setSumScale(BigDecimal.ZERO);
            }
            vo.setSettlementRecord(BeanMapper.mapList((Iterable)entities, PurchaseSettlementVO.class));
        }
        return vo;
    }
}

