/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.RentChangeEntity;
import com.ejianc.business.equipment.bean.RentContractDetailEntity;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.mapper.RentChangeMapper;
import com.ejianc.business.equipment.service.IRentChangeService;
import com.ejianc.business.equipment.service.IRentContractDetailService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.vo.RentChangeDetailVO;
import com.ejianc.business.equipment.vo.RentChangeRecordVO;
import com.ejianc.business.equipment.vo.RentChangeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RentChangeService")
public class RentChangeServiceImpl
extends BaseServiceImpl<RentChangeMapper, RentChangeEntity>
implements IRentChangeService {
    private static final String RENT_CHANGE_BILL_CODE = "EQUIPMENT_RENT_CHANGE";
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IRentContractDetailService rentContractDetailService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<RentChangeVO> saveOrUpdate(RentChangeVO rentChangeVo) {
        QueryParam queryParam;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentChangeEntity entity = null;
        List entitiesc = null;
        List entities = null;
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(RentChangeEntity::getContractId, (Object)rentChangeVo.getContractId());
        if (rentChangeVo.getId() != null && rentChangeVo.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)rentChangeVo.getId());
        }
        lambdachange.ne(RentChangeEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(RentChangeEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        RentContractEntity pcentity = (RentContractEntity)((Object)this.rentContractService.selectById(rentChangeVo.getContractId()));
        if (StringUtils.isEmpty((CharSequence)rentChangeVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(RENT_CHANGE_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                rentChangeVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (rentChangeVo.getId() != null && rentChangeVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(RentChangeEntity::getBillCode, (Object)rentChangeVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(RentChangeEntity::getContractId, (Object)rentChangeVo.getContractId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)rentChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)rentChangeVo.getContractId()));
            entitiesc = this.rentContractService.queryList(queryParam, false);
            pcentity.setId(rentChangeVo.getContractId());
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(RentChangeEntity::getBillCode, (Object)rentChangeVo.getBillCode());
            lambda.ne(RentChangeEntity::getContractId, (Object)rentChangeVo.getContractId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)rentChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)rentChangeVo.getContractId()));
            entitiesc = this.rentContractService.queryList(queryParam, false);
            pcentity.setId(rentChangeVo.getContractId());
            pcentity.setChangeVersion(rentChangeVo.getChangeVersion() + 1);
            rentChangeVo.setChangeVersion(Integer.valueOf(rentChangeVo.getChangeVersion() + 1));
            rentChangeVo.setMakeTime(new Date());
        }
        if (CollectionUtils.isNotEmpty((Collection)rentChangeVo.getRentdetail())) {
            rentChangeVo.getRentdetail().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(rentChangeVo.getContractId());
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)rentChangeVo.getRentfee())) {
            rentChangeVo.getRentfee().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(rentChangeVo.getContractId());
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)rentChangeVo.getRentclause())) {
            rentChangeVo.getRentclause().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(rentChangeVo.getContractId());
                }
            });
        }
        if (entities != null && entities.size() > 0 && entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity = (RentChangeEntity)((Object)BeanMapper.map((Object)rentChangeVo, RentChangeEntity.class));
        super.saveOrUpdate((Object)entity, false);
        pcentity.setChangeStatus(2);
        pcentity.setChangingMny(entity.getContractMny());
        pcentity.setChangingTaxMny(entity.getContractTaxMny());
        pcentity.setChangeCode(entity.getBillCode());
        pcentity.setChangeId(entity.getId());
        this.rentContractService.update((Object)pcentity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)pcentity.getId()), false);
        RentChangeVO res = (RentChangeVO)BeanMapper.map((Object)((Object)entity), RentChangeVO.class);
        BigDecimal contractTaxMny = res.getContractTaxMny() == null ? BigDecimal.ZERO : res.getContractTaxMny();
        BigDecimal beforeChangeTaxMny = pcentity.getBeforeChangeTaxMny() == null ? BigDecimal.ZERO : pcentity.getBeforeChangeTaxMny();
        BigDecimal bb = contractTaxMny.subtract(beforeChangeTaxMny);
        if (bb.compareTo(BigDecimal.ZERO) != 0 && beforeChangeTaxMny.compareTo(BigDecimal.ZERO) != 0) {
            res.setScale(new BigDecimal(100).multiply(bb.divide(beforeChangeTaxMny, 8, 5)));
            res.setBb(bb);
        }
        return CommonResponse.success((Object)res);
    }

    @Override
    public RentChangeVO queryDetail(Long id) {
        BigDecimal beforeChangeTaxMny;
        RentChangeEntity entity = (RentChangeEntity)((Object)super.selectById((Serializable)id));
        RentChangeVO rentChangeVo = (RentChangeVO)BeanMapper.map((Object)((Object)entity), RentChangeVO.class);
        BigDecimal contractTaxMny = rentChangeVo.getContractTaxMny() == null ? BigDecimal.ZERO : rentChangeVo.getContractTaxMny();
        BigDecimal bb = contractTaxMny.subtract(beforeChangeTaxMny = rentChangeVo.getBeforeChangeTaxMny() == null ? BigDecimal.ZERO : rentChangeVo.getBeforeChangeTaxMny());
        if (bb.compareTo(BigDecimal.ZERO) != 0 && contractTaxMny.compareTo(BigDecimal.ZERO) != 0) {
            rentChangeVo.setScale(new BigDecimal(100).multiply(bb.divide(beforeChangeTaxMny, 8, 5)));
            rentChangeVo.setBb(bb);
        }
        return rentChangeVo;
    }

    @Override
    public RentChangeVO queryDetails(Long id) {
        RentContractEntity entity = (RentContractEntity)((Object)this.rentContractService.selectById(id));
        RentChangeVO rentChangeVo = (RentChangeVO)BeanMapper.map((Object)((Object)entity), RentChangeVO.class);
        rentChangeVo.setContractId(rentChangeVo.getId());
        rentChangeVo.setId(null);
        rentChangeVo.setBillState(null);
        rentChangeVo.setCreateUserCode(null);
        rentChangeVo.setCreateTime(null);
        rentChangeVo.setUpdateUserCode(null);
        rentChangeVo.setUpdateTime(null);
        rentChangeVo.setChangeDate(new Date());
        rentChangeVo.setBeforeContractName(entity.getContractName());
        rentChangeVo.setBeforeChangeMny(entity.getContractMny());
        rentChangeVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
        rentChangeVo.setBeforeContractName(rentChangeVo.getContractName());
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(RentContractDetailEntity::getContractId, (Object)id);
        lambda.ne(RentContractDetailEntity::getChangeType, (Object)"3");
        details = this.rentContractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            rentChangeVo.setRentdetail(BeanMapper.mapList((Iterable)details, RentChangeDetailVO.class));
            rentChangeVo.getRentdetail().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setContractId(rentChangeVo.getContractId());
                vo.setChangeType("4");
                vo.setRowState("add");
            });
        } else {
            rentChangeVo.setRentdetail(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)rentChangeVo.getRentfee())) {
            rentChangeVo.getRentfee().forEach(vo -> {
                vo.setContractId(rentChangeVo.getContractId());
                vo.setRowState("add");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)rentChangeVo.getRentclause())) {
            rentChangeVo.getRentclause().forEach(vo -> {
                vo.setContractId(rentChangeVo.getContractId());
                vo.setRowState("add");
            });
        }
        return rentChangeVo;
    }

    @Override
    public RentChangeRecordVO queryChangeRecord(Long id) {
        RentChangeRecordVO vo = new RentChangeRecordVO();
        RentContractEntity entity = (RentContractEntity)((Object)this.rentContractService.selectById(id));
        BigDecimal baseTaxMoney = entity.getBaseTaxMoney() == null ? BigDecimal.ZERO : entity.getBaseTaxMoney();
        BigDecimal contractTaxMny = entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny();
        vo.setBaseTaxMoney(baseTaxMoney);
        vo.setContractId(id);
        vo.setContractTaxMny(contractTaxMny);
        vo.setSumChangeMny(contractTaxMny.subtract(baseTaxMoney));
        if (vo.getSumChangeMny().compareTo(BigDecimal.ZERO) != 0 && baseTaxMoney.compareTo(BigDecimal.ZERO) != 0) {
            vo.setSumScale(new BigDecimal(100).multiply(vo.getSumChangeMny().divide(baseTaxMoney, 8, 5)));
        } else {
            vo.setSumScale(BigDecimal.ZERO);
        }
        if (entity.getChangeVersion() > 0) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(RentChangeEntity::getContractId, (Object)id);
            lambda.in(RentChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            List entities = super.list((Wrapper)lambda);
            vo.setChangeRecord(BeanMapper.mapList((Iterable)entities, RentChangeVO.class));
        }
        return vo;
    }

    @Override
    public void deleteRentChange(List<RentChangeVO> vos) {
        RentChangeVO rentChangeVo = vos.get(0);
        RentChangeEntity entity = (RentChangeEntity)((Object)super.selectById((Serializable)rentChangeVo.getId()));
        RentContractEntity pcentity = (RentContractEntity)((Object)this.rentContractService.selectById(entity.getContractId()));
        pcentity.setId(entity.getContractId());
        pcentity.setChangeVersion(pcentity.getChangeVersion() - 1);
        pcentity.setChangeStatus(1);
        pcentity.setChangingMny(BigDecimal.ZERO);
        pcentity.setChangingTaxMny(BigDecimal.ZERO);
        pcentity.setChangeCode(null);
        pcentity.setChangeId(null);
        this.rentContractService.update((Object)pcentity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)pcentity.getId()), false);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }
}

