package com.ejianc.business.equipment.bean;

import java.math.BigDecimal;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.util.ArrayList;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 设备合同表
 * </p>
 *
 * @author yqls
 * @since 2020-06-09
 */
@TableName("ejc_equipment_rent_change")
public class RentChangeEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;
     /**
        * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;


    /**
     * 合同编码
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 组织主键
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 项目主键
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 总包企业主键
     */
    @TableField("customer_id")
    private Long customerId;

    /**
     * 总包企业名称
     */
    @TableField("customer_name")
    private String customerName;

    /**
     * 设备供应商主键
     */
    @TableField("supplier_id")
    private Long supplierId;

    /**
     * 设备供应商名称
     */
    @TableField("supplier_name")
    private String supplierName;

    /**
     * 变更日期
     */
    @TableField("change_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate;

    /**
     * 签约日期
     */
    @TableField("sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 编制时间
     */
    @TableField("make_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date makeTime;

    /**
     * 生效时间
     */
    @TableField("change_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date changeTime;

    /**
     * 合同税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;

    /**
     * 合同支付比例
     */
    @TableField("pay_scale")
    private BigDecimal payScale;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;
    /**
     * 经办人名称
     */
    private String employeeName;



    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    @TableField("contract_status")
    private String contractStatus;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 合同金额(含税)
     */
    @TableField("contract_tax_mny")
    private BigDecimal contractTaxMny;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 合同金额(不含税)
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 单据状态（审批必须字段）
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 变更版本
     */
    @TableField("change_version")
    private Integer changeVersion;

    /**
     * 初始版本金额（不含税）
     */
    @TableField("base_money")
    private BigDecimal baseMoney;

    /**
     * 初始版本金额
     */
    @TableField("base_tax_money")
    private BigDecimal baseTaxMoney;

    /**
     * 变更前金额（不含税）
     */
    @TableField("before_change_mny")
    private BigDecimal beforeChangeMny;

    /**
     * 变更前金额
     */
    @TableField("before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny;

    /**
     * 变更状态1-未变更 2-变更中 3-已变更
     */
    @TableField("change_status")
    private Integer changeStatus;

    /**
     * 变更前合同名称
     */
    @TableField("before_contract_name")
    private String beforeContractName;
    /**
     *合同名称
     */
    @TableField("contract_name")
    private String contractName;
    /**
     * 变更原因
     */
    @TableField("change_reason")
    private String changeReason;
    // 设备明细子表
    @TableField(exist = false)
    @SubEntity(serviceName="RentChangeDetailService",pidName = "changeId")
    private List<RentChangeDetailEntity> rentdetail = new ArrayList<>();

    // 合同条款子表
    @TableField(exist = false)
    @SubEntity(serviceName="RentChangeClauseService",pidName = "changeId")
    private List<RentChangeClauseEntity> rentclause = new ArrayList<>();

    // 其他费用子表
    @TableField(exist = false)
    @SubEntity(serviceName="RentChangeFeeService",pidName = "changeId")
    private List<RentChangeFeeEntity> rentfee = new ArrayList<>();

    // 付款阶段子表
    @TableField(exist = false)
    @SubEntity(serviceName="RentChangeStageService",pidName = "changeId")
    private List<RentChangeStageEntity> rentstage = new ArrayList<>();

    public List<RentChangeStageEntity> getRentstage() {
        return rentstage;
    }

    public void setRentstage(List<RentChangeStageEntity> rentstage) {
        this.rentstage = rentstage;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public List<RentChangeDetailEntity> getRentdetail() {
        return rentdetail;
    }

    public void setRentdetail(List<RentChangeDetailEntity> rentdetail) {
        this.rentdetail = rentdetail;
    }

    public List<RentChangeClauseEntity> getRentclause() {
        return rentclause;
    }

    public void setRentclause(List<RentChangeClauseEntity> rentclause) {
        this.rentclause = rentclause;
    }

    public List<RentChangeFeeEntity> getRentfee() {
        return rentfee;
    }

    public void setRentfee(List<RentChangeFeeEntity> rentfee) {
        this.rentfee = rentfee;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public Date getMakeTime() {
        return makeTime;
    }

    public void setMakeTime(Date makeTime) {
        this.makeTime = makeTime;
    }

    public Date getChangeTime() {
        return changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public String getBeforeContractName() {
        return beforeContractName;
    }

    public void setBeforeContractName(String beforeContractName) {
        this.beforeContractName = beforeContractName;
    }


}
