package com.ejianc.business.equipment.bean;

import java.math.BigDecimal;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.util.ArrayList;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 租赁设备使用记录
 * </p>
 *
 * @author yqls
 * @since 2020-06-11
 */
@TableName("ejc_equipment_rent_use_record")
public class RentUseRecordEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 合同编码
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 设备供应商名称
     */
    @TableField("supplier_name")
    private String supplierName;

    /**
     * 设备供应商主键
     */
    @TableField("supplier_id")
    private Long supplierId;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 项目主键
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 开始日期
     */
    @TableField("start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;

    /**
     * 结束日期
     */
    @TableField("end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    /**
     * 使用部位主键
     */
    @TableField("part_id")
    private Long partId;

    /**
     * 使用金额
     */
    @TableField("use_mny")
    private BigDecimal useMny;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 单据状态（审批必须字段）
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    @TableField("contract_status")
    private String contractStatus;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 是否使用
     */
    @TableField("use_flag")
    private Integer useFlag;

    /**
     * 设备名称合集
     */
    @TableField("equipment_name")
    private String equipmentName;
    // 设备明细子表
    @TableField(exist = false)
    @SubEntity(serviceName="RentUseRecordDetailService",pidName = "useId")
    private List<RentUseRecordDetailEntity> rentdetail = new ArrayList<>();

    // 其他费用子表
    @TableField(exist = false)
    @SubEntity(serviceName="RentUseRecordFeeService",pidName = "useId")
    private List<RentUseRecordFeeEntity> rentfee = new ArrayList<>();

    public List<RentUseRecordDetailEntity> getRentdetail() {
        return rentdetail;
    }

    public void setRentdetail(List<RentUseRecordDetailEntity> rentdetail) {
        this.rentdetail = rentdetail;
    }

    public List<RentUseRecordFeeEntity> getRentfee() {
        return rentfee;
    }

    public void setRentfee(List<RentUseRecordFeeEntity> rentfee) {
        this.rentfee = rentfee;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public Long getPartId() {
        return partId;
    }

    public void setPartId(Long partId) {
        this.partId = partId;
    }
    public BigDecimal getUseMny() {
        return useMny;
    }

    public void setUseMny(BigDecimal useMny) {
        this.useMny = useMny;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Integer getUseFlag() {
        return useFlag;
    }

    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }
    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }


}
