package com.ejianc.business.equipment.controller;


import com.ejianc.business.equipment.service.IPurchaseRecordService;
import com.ejianc.business.equipment.vo.PurchaseRecordVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 设备合同历史表 前端控制器
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@RestController
@RequestMapping("purchaseRecord")
public class PurchaseRecordController {
    @Autowired
    private IPurchaseRecordService purchaseRecordService;
    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseRecordVO> queryDetail(@RequestParam Long id) {
        PurchaseRecordVO purchaseRecordVO = purchaseRecordService.queryDetail(id);
        return CommonResponse.success(purchaseRecordVO);
    }

}
