package com.ejianc.business.equipment.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.bean.RentContractDetailEntity;
import com.ejianc.business.equipment.service.IRentContractDetailService;
import com.ejianc.business.equipment.vo.RentContractDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * <p>
 * 设备明细 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-08
 */
@RestController
@RequestMapping("rentContractDetail")
public class RentContractDetailController {
    @Autowired
    private IRentContractDetailService rentContractDetailService;

    @Autowired
    private IOrgApi orgApi;
    @GetMapping("/rentContractDetailRef")
    public  CommonResponse<IPage<RentContractDetailVO>>  projectListRefe(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                             @RequestParam(defaultValue = "10") Integer pageSize,
                                                                             @RequestParam(value = "condition", required = false) String condition,
                                                                             @RequestParam(value = "searchText", required = false) String searchText) {

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("name");
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("contractId")) {
                queryParam.getParams().put("contract_id",new Parameter("eq",conditionMap.get("contractId")));
                queryParam.getParams().put("change_type",new Parameter("ne","3"));
            }
        }
        IPage<RentContractDetailEntity> pageData = rentContractDetailService.queryPage(queryParam,false);
        IPage<RentContractDetailVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), RentContractDetailVO.class));
        return CommonResponse.success("参照查询成功！", result);
    }
}
