package com.ejianc.business.equipment.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * @Author sunyj
 * @Date 2020/5/27 其他费用
 * @Description PurchaseCostEntity
 */

@TableName("ejc_equipment_purchase_contract_fee")
public class PurchaseContractFeeEntity extends BaseEntity {

    private static final long serialVersionUID = 2779265683222439571L;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 费用类型
     */
    @TableField("fee_type")
    private String feeType;

    /**
     * 金额
     */
    @TableField("money")
    private BigDecimal money;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    @TableField(value="src_supplement_flag")
    private java.lang.Integer srcSupplementFlag; // 是否来源补充协议(1:是，0：否)
    @TableField(value="src_supplement_id")
    private java.lang.Long srcSupplementId; // 来源补充协议主表ID
    @TableField(value="src_supplement_detail_id")
    private java.lang.Long srcSupplementDetailId; // 来源补充协议明细ID

    public Integer getSrcSupplementFlag() {
        return srcSupplementFlag;
    }

    public void setSrcSupplementFlag(Integer srcSupplementFlag) {
        this.srcSupplementFlag = srcSupplementFlag;
    }

    public Long getSrcSupplementId() {
        return srcSupplementId;
    }

    public void setSrcSupplementId(Long srcSupplementId) {
        this.srcSupplementId = srcSupplementId;
    }

    public Long getSrcSupplementDetailId() {
        return srcSupplementDetailId;
    }

    public void setSrcSupplementDetailId(Long srcSupplementDetailId) {
        this.srcSupplementDetailId = srcSupplementDetailId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getFeeType() {
        return feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
