package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.PurchaseChangeEntity;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.bean.SupplementPurchaseContractDetailEntity;
import com.ejianc.business.equipment.bean.SupplementPurchaseContractEntity;
import com.ejianc.business.equipment.mapper.SupplementPurchaseContractMapper;
import com.ejianc.business.equipment.service.IPurchaseChangeService;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.ISupplementPurchaseContractService;
import com.ejianc.business.equipment.vo.SupplementPurchaseContractRecordVO;
import com.ejianc.business.equipment.vo.SupplementPurchaseContractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 采购合同补充协议
 * 
 * @author generator
 * 
 */
@Service("supplementPurchaseContractService")
public class SupplementPurchaseContractServiceImpl extends BaseServiceImpl<SupplementPurchaseContractMapper, SupplementPurchaseContractEntity> implements ISupplementPurchaseContractService{
    private static final String EQUIPMENT_SUPPLEMENT_BILL_CODE = "EQUIPMENT_PURCHASE_BCXY";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPurchaseContractService contractService;

    @Autowired
    private IPurchaseChangeService changeService;

    @Autowired
    private SessionManager sessionManager;


    @Override
    public SupplementPurchaseContractVO addConvertByConId(Long contractId) {
        PurchaseContractEntity entity = contractService.selectById(contractId);
//        SupplementPurchaseContractVO supplementVO = BeanMapper.map(entity, SupplementPurchaseContractVO.class);
//        //新增逻辑处理
//        //新增即点变更按钮穿透过来，此时ID为合同id
//        supplementVO.setId(null);
//        supplementVO.setBillState(null);
//        supplementVO.setCreateUserCode(null);
//        supplementVO.setCreateTime(null);
//        supplementVO.setUpdateUserCode(null);
//        supplementVO.setUpdateTime(null);
//        supplementVO.setVersion(null);
//        supplementVO.setMainContractId(supplementVO.getId());
//        supplementVO.setMainContractCode(supplementVO.getBillCode());
//        supplementVO.setMainContractName(supplementVO.getContractName());
//        supplementVO.setPurchaseclause(null);
//        supplementVO.setPurchasedetail(null);
//        supplementVO.setPurchasefee(null);
//        supplementVO.setPurchasestage(null);
        SupplementPurchaseContractVO supplementVO = new SupplementPurchaseContractVO();
        supplementVO.setPurchaseType(entity.getPurchaseType());
        supplementVO.setPurchaseTypeName(entity.getPurchaseTypeName());
        supplementVO.setProjectId(entity.getProjectId());
        supplementVO.setProjectName(entity.getProjectName());
        supplementVO.setOrgId(entity.getOrgId());
        supplementVO.setOrgName(entity.getOrgName());
        supplementVO.setSupplierId(entity.getSupplierId());
        supplementVO.setSupplierName(entity.getSupplierName());
        supplementVO.setCustomerId(entity.getCustomerId());
        supplementVO.setCustomerName(entity.getCustomerName());
        supplementVO.setTaxRate(entity.getTaxRate());
        supplementVO.setSupplementFlag(1);
        supplementVO.setContractStatus("2");
        supplementVO.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        supplementVO.setEmployeeName(sessionManager.getUserContext().getUserName());
        supplementVO.setSignDate(new Date());
        supplementVO.setPayScale(entity.getPayScale());
        supplementVO.setMainContractId(entity.getId());
        supplementVO.setMainContractCode(entity.getBillCode());
        supplementVO.setMainContractName(entity.getContractName());
        return supplementVO;
    }

    @Override
    public SupplementPurchaseContractRecordVO queryDetailRecord(Long id) {
        PurchaseContractEntity contractEntity = contractService.selectById(id);
        SupplementPurchaseContractRecordVO recordVO = new SupplementPurchaseContractRecordVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal baseTaxMny = contractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMoney();
        recordVO.setContractId(id);
        recordVO.setContractTaxMny(contractTaxMny);
        recordVO.setBaseTaxMoney(baseTaxMny);
        recordVO.setSettlementType(contractEntity.getSettlementType());
        LambdaQueryWrapper<SupplementPurchaseContractEntity> lambda = Wrappers.<SupplementPurchaseContractEntity>lambdaQuery();
        lambda.eq(SupplementPurchaseContractEntity::getMainContractId, id);
        lambda.orderByDesc(SupplementPurchaseContractEntity::getSignDate);
//        lambda.in(SupplementPurchaseContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<SupplementPurchaseContractEntity> entities = super.list(lambda);
        recordVO.setSupplementRecord(BeanMapper.mapList(entities, SupplementPurchaseContractVO.class));
        return recordVO;
    }

    @Override
    public SupplementPurchaseContractVO insertOrUpdate(SupplementPurchaseContractVO supplementVO) {
        if(checkFinishContract(supplementVO)){
            throw new BusinessException("该合同在相同组织下已经完工，不允许变更！");
        }

        Long tenantId = InvocationInfoProxy.getTenantid();
        List<SupplementPurchaseContractEntity> entities = null;

        //补充协议只能存在一条未生效的
        LambdaQueryWrapper<SupplementPurchaseContractEntity> lambdaQuery = Wrappers.<SupplementPurchaseContractEntity>lambdaQuery();
        lambdaQuery.eq(SupplementPurchaseContractEntity::getTenantId, tenantId);
        lambdaQuery.eq(SupplementPurchaseContractEntity::getMainContractId, supplementVO.getMainContractId());
        if(supplementVO.getId() != null && supplementVO.getId() > 0) {
            lambdaQuery.ne(SupplementPurchaseContractEntity::getId, supplementVO.getId());
        }
        lambdaQuery.ne(SupplementPurchaseContractEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery.ne(SupplementPurchaseContractEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdaQuery);
        if(num > 0){
            throw new BusinessException("该合同已存在未生效的补充协议!");
        }

        //补充协议只能存在一条未生效的变更单
        LambdaQueryWrapper<PurchaseChangeEntity> lambdachange = Wrappers.<PurchaseChangeEntity>lambdaQuery();
        lambdachange.eq(PurchaseChangeEntity::getTenantId, tenantId);
        lambdachange.eq(PurchaseChangeEntity::getContractId, supplementVO.getMainContractId());
        lambdachange.ne(PurchaseChangeEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(PurchaseChangeEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int changeNum = changeService.count(lambdachange);
        if(changeNum > 0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }
        if(StringUtils.isEmpty(supplementVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(EQUIPMENT_SUPPLEMENT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                supplementVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(supplementVO.getId() != null && supplementVO.getId() > 0) {
            //修改 校验合同编号唯一
            LambdaQueryWrapper<SupplementPurchaseContractEntity> lambda = Wrappers.<SupplementPurchaseContractEntity>lambdaQuery();
            lambda.eq(SupplementPurchaseContractEntity::getBillCode, supplementVO.getBillCode());
            lambda.eq(SupplementPurchaseContractEntity::getTenantId, tenantId);
            lambda.eq(SupplementPurchaseContractEntity::getSupplementFlag, 1);//过滤非合同补充协议
            lambda.ne(SupplementPurchaseContractEntity::getId, supplementVO.getId());
            entities = super.list(lambda);
        }else{
            LambdaQueryWrapper<SupplementPurchaseContractEntity> lambda = Wrappers.<SupplementPurchaseContractEntity>lambdaQuery();
            lambda.eq(SupplementPurchaseContractEntity::getBillCode, supplementVO.getBillCode());
            lambda.eq(SupplementPurchaseContractEntity::getSupplementFlag, 1);//过滤非合同补充协议
            lambda.eq(SupplementPurchaseContractEntity::getTenantId, tenantId);
            entities = super.list(lambda);
        }

        if(entities != null && entities.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        SupplementPurchaseContractEntity supplementEntity = BeanMapper.map(supplementVO, SupplementPurchaseContractEntity.class);
        //保存前清空主键和父主键，重新生成
        List<SupplementPurchaseContractDetailEntity> beforeDetails = supplementEntity.getPurchasedetail();
        if(CollectionUtils.isNotEmpty(beforeDetails) && null == supplementEntity.getId()){
            for(SupplementPurchaseContractDetailEntity cdEntity : beforeDetails){
                cdEntity.setId(null);
            }
        }
        super.saveOrUpdate(supplementEntity, false);
        return BeanMapper.map(supplementEntity, SupplementPurchaseContractVO.class);
    }

    private Boolean checkFinishContract(SupplementPurchaseContractVO supplementVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<PurchaseContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(PurchaseContractEntity::getId, supplementVO.getMainContractId());
        lambda.eq(PurchaseContractEntity::getTenantId, tenantId);
        lambda.eq(PurchaseContractEntity::getSettlementType, 1);
        return contractService.list(lambda).size() > 0;
    }
}
