/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.archives.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.archives.bean.EquipmentEntity;
import com.ejianc.business.archives.controller.SparepartController;
import com.ejianc.business.archives.service.IEquipmentService;
import com.ejianc.business.archives.vo.EquipmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"equipment"})
public class EquipmentController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SparepartController sparepartController;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "equipment-equipment";
    @Autowired
    private IEquipmentService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<EquipmentVO> saveOrUpdate(@RequestBody EquipmentVO saveorUpdateVO) {
        EquipmentEntity entity = (EquipmentEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), EquipmentEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        EquipmentVO vo = (EquipmentVO)((Object)BeanMapper.map((Object)((Object)entity), EquipmentVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EquipmentVO> queryDetail(Long id) {
        EquipmentEntity entity = (EquipmentEntity)((Object)this.service.selectById(id));
        EquipmentVO vo = (EquipmentVO)((Object)BeanMapper.map((Object)((Object)entity), EquipmentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EquipmentVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<EquipmentVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EquipmentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Equipment-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refEquipmentData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<EquipmentVO>> refEquipmentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            String id = _con.getString("id");
            System.out.println(id);
            if (id.contains(",")) {
                param.getParams().put("funtionstate", new Parameter("not_in", (Object)id));
            } else {
                param.getParams().put("eccode", new Parameter("eq", (Object)id));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), EquipmentVO.class);
        if (ListUtil.isNotEmpty((List)records)) {
            records.forEach(e -> {
                try {
                    JSONArray showname = ReferObjectUtil.getReferEntityValue((String)e.getShopcode().toString(), (String)"equworkshop");
                    JSONArray pname = ReferObjectUtil.getReferEntityValue((String)e.getPcode().toString(), (String)"equplacefiles");
                    JSONArray proname = ReferObjectUtil.getReferEntityValue((String)e.getProcode().toString(), (String)"equproduction");
                    e.setShopName(((JSONObject)showname.get(0)).getString("name"));
                    e.setPname(((JSONObject)pname.get(0)).getString("name"));
                    e.setProName(((JSONObject)proname.get(0)).getString("name"));
                    JSONArray eccode = ReferObjectUtil.getReferEntityValue((String)e.getEccode().toString(), (String)"support-defdoc");
                    e.setEcname(((JSONObject)eccode.get(0)).getString("name"));
                    JSONArray comcode = ReferObjectUtil.getReferEntityValue((String)e.getComcode().toString(), (String)"idm-org");
                    e.setComname(((JSONObject)comcode.get(0)).getString("name"));
                    JSONArray supcode = ReferObjectUtil.getReferEntityValue((String)e.getSupcode().toString(), (String)"equsupplier");
                    e.setSupname(((JSONObject)supcode.get(0)).getString("name"));
                    JSONArray depcode = ReferObjectUtil.getReferEntityValue((String)e.getDepcode().toString(), (String)"idm-dept");
                    e.setDepname(((JSONObject)depcode.get(0)).getString("name"));
                    JSONArray uscode = ReferObjectUtil.getReferEntityValue((String)e.getUscode().toString(), (String)"idm-user");
                    e.setUsname(((JSONObject)uscode.get(0)).getString("name"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

