/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.work.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.archives.controller.EquipmentController;
import com.ejianc.business.archives.vo.EquipmentVO;
import com.ejianc.business.work.bean.ReportrepairEntity;
import com.ejianc.business.work.service.IReportrepairService;
import com.ejianc.business.work.vo.ReportrepairVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"reportrepair"})
public class ReportrepairController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private EquipmentController equipmentController;
    private static final String BILL_CODE = "equipment-reportrepair";
    @Autowired
    private IReportrepairService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ReportrepairVO> saveOrUpdate(@RequestBody ReportrepairVO saveorUpdateVO) {
        ReportrepairEntity entity = (ReportrepairEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), ReportrepairEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        CommonResponse<IPage<EquipmentVO>> list = this.equipmentController.refEquipmentData(1, 10, null, "{\"id\":\"" + entity.getEqucode().toString() + "\"}", null);
        ReportrepairVO vo = (ReportrepairVO)((Object)BeanMapper.map((Object)((Object)entity), ReportrepairVO.class));
        for (EquipmentVO exlist : ((IPage)list.getData()).getRecords()) {
            vo.setShopName(exlist.getShopName());
            vo.setPname(exlist.getPname());
            vo.setProName(exlist.getProName());
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReportrepairVO> queryDetail(Long id) {
        ReportrepairEntity entity = (ReportrepairEntity)((Object)this.service.selectById(id));
        CommonResponse<IPage<EquipmentVO>> list = this.equipmentController.refEquipmentData(1, 10, null, "{\"id\":\"" + entity.getEqucode().toString() + "\"}", null);
        ReportrepairVO vo = (ReportrepairVO)((Object)BeanMapper.map((Object)((Object)entity), ReportrepairVO.class));
        for (EquipmentVO exlist : ((IPage)list.getData()).getRecords()) {
            vo.setShopName(exlist.getShopName());
            vo.setPname(exlist.getPname());
            vo.setProName(exlist.getProName());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReportrepairVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ReportrepairVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReportrepairVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Reportrepair-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refReportrepairData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ReportrepairVO>> refReportrepairData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            String id = _con.getString("id");
            String repairid = _con.getString("repairid");
            System.out.println(id);
            System.out.println("\u7ef4\u4fee\u72b6\u6001id=" + repairid);
            param.getParams().put("isxuweixiu", new Parameter("eq", (Object)id));
            param.getParams().put("repairstatus", new Parameter("eq", (Object)repairid));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), ReportrepairVO.class);
        if (ListUtil.isNotEmpty((List)records)) {
            records.forEach(e -> {
                try {
                    JSONArray scource;
                    JSONArray urgent;
                    JSONArray repairtype;
                    JSONArray handlestate;
                    JSONArray fauletypename;
                    JSONArray equcode = ReferObjectUtil.getReferEntityValue((String)e.getEqucode().toString(), (String)"equequipment");
                    if (!equcode.isEmpty()) {
                        e.setEqunum(((JSONObject)equcode.get(0)).getString("code"));
                        e.setEqunames(((JSONObject)equcode.get(0)).getString("name"));
                        e.setEquspecs(((JSONObject)equcode.get(0)).getString("equspecs"));
                    }
                    if (!(fauletypename = ReferObjectUtil.getReferEntityValue((String)e.getFauletype().toString(), (String)"support-defdoc")).isEmpty()) {
                        e.setFauletypename(((JSONObject)fauletypename.get(0)).getString("name"));
                    }
                    if (!(handlestate = ReferObjectUtil.getReferEntityValue((String)e.getHandlestate().toString(), (String)"support-defdoc")).isEmpty()) {
                        e.setHandlestatename(((JSONObject)handlestate.get(0)).getString("name"));
                    }
                    if (!(repairtype = ReferObjectUtil.getReferEntityValue((String)e.getRepairtype().toString(), (String)"support-defdoc")).isEmpty()) {
                        e.setRepairtypename(((JSONObject)repairtype.get(0)).getString("name"));
                    }
                    if (!(urgent = ReferObjectUtil.getReferEntityValue((String)e.getUrgent().toString(), (String)"support-defdoc")).isEmpty()) {
                        e.setUrgentnanme(((JSONObject)urgent.get(0)).getString("name"));
                    }
                    if (!(scource = ReferObjectUtil.getReferEntityValue((String)e.getScource().toString(), (String)"support-defdoc")).isEmpty()) {
                        e.setScourcename(((JSONObject)scource.get(0)).getString("name"));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

