package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.PurchaseChangeEntity;
import com.ejianc.business.equipment.bean.PurchaseContractDetailEntity;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.mapper.PurchaseChangeMapper;
import com.ejianc.business.equipment.service.IPurchaseChangeService;
import com.ejianc.business.equipment.service.IPurchaseContractDetailService;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.vo.PurchaseChangeDetailVO;
import com.ejianc.business.equipment.vo.PurchaseChangeRecordVO;
import com.ejianc.business.equipment.vo.PurchaseChangeVO;
import com.ejianc.business.equipment.vo.PurchaseContractDetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * <p>
 * 设备合同变更表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("PurchaseChangeService")
public class PurchaseChangeServiceImpl extends BaseServiceImpl<PurchaseChangeMapper, PurchaseChangeEntity> implements IPurchaseChangeService {

    private static final String PURCHASE_CHANGE_BILL_CODE = "EQUIPMENT_PURCHASE";

    @Autowired
    private IPurchaseContractService purchaseContractService;

    @Autowired
    private IPurchaseContractDetailService purchaseContractDetailService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Override
    public CommonResponse<PurchaseChangeVO> saveOrUpdate(PurchaseChangeVO purchaseChangeVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseChangeEntity entity = null;
        List<PurchaseContractEntity> entitiesc = null;
        List<PurchaseChangeEntity> entities = null;


        //变更合同只能存在一条未生效的
        LambdaQueryWrapper<PurchaseChangeEntity> lambdachange = Wrappers.<PurchaseChangeEntity>lambdaQuery();
        lambdachange.eq(PurchaseChangeEntity::getTenantId, tenantId);
        lambdachange.eq(PurchaseChangeEntity::getContractId,purchaseChangeVo.getContractId());
        if(purchaseChangeVo.getId() != null && purchaseChangeVo.getId() > 0) {
            lambdachange.ne(PurchaseChangeEntity::getId,purchaseChangeVo.getId());
        }
        lambdachange.ne(PurchaseChangeEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(PurchaseChangeEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }

        PurchaseContractEntity pcentity = purchaseContractService.selectById(purchaseChangeVo.getContractId());
        if(StringUtils.isEmpty(purchaseChangeVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PURCHASE_CHANGE_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                purchaseChangeVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(purchaseChangeVo.getId() != null && purchaseChangeVo.getId() > 0) {
            //修改 校验合同编号唯一，变更单除去本单，采购合同  同时唯一
            LambdaQueryWrapper<PurchaseChangeEntity> lambda = Wrappers.<PurchaseChangeEntity>lambdaQuery();
            lambda.eq(PurchaseChangeEntity::getBillCode, purchaseChangeVo.getBillCode());
            lambda.eq(PurchaseChangeEntity::getTenantId, tenantId);
            lambda.ne(PurchaseChangeEntity::getContractId,purchaseChangeVo.getContractId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,purchaseChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE,purchaseChangeVo.getContractId()));
            entitiesc = purchaseContractService.queryList(queryParam,false);

            pcentity.setId(purchaseChangeVo.getContractId());

        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<PurchaseChangeEntity> lambda = Wrappers.<PurchaseChangeEntity>lambdaQuery();
            lambda.eq(PurchaseChangeEntity::getTenantId, tenantId);
            lambda.eq(PurchaseChangeEntity::getBillCode, purchaseChangeVo.getBillCode());
            lambda.ne(PurchaseChangeEntity::getContractId,purchaseChangeVo.getContractId());
            entities = super.list(lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,purchaseChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE,purchaseChangeVo.getContractId()));
            entitiesc = purchaseContractService.queryList(queryParam,false);
            //新增即点变更按钮穿透过来，此时ID为合同id
            pcentity.setId(purchaseChangeVo.getContractId());
            pcentity.setChangeVersion(purchaseChangeVo.getChangeVersion()+1);
            purchaseChangeVo.setChangeVersion(purchaseChangeVo.getChangeVersion()+1);
            purchaseChangeVo.setMakeTime(new Date());
        }

        if(CollectionUtils.isNotEmpty(purchaseChangeVo.getPurchasedetail())){
            purchaseChangeVo.getPurchasedetail().forEach(vo -> {
                //变更类型1-增补，2-变更，3-中止
                if("add".equals(vo.getRowState())){
//                        vo.setContractDetailId(vo.getId());
                    vo.setContractId(purchaseChangeVo.getContractId());
//                        vo.setChangeType(1);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(purchaseChangeVo.getPurchasefee())){
            purchaseChangeVo.getPurchasefee().forEach(vo -> {
                if("add".equals(vo.getRowState())){
                    vo.setContractId(purchaseChangeVo.getContractId());
                }
            });
        }
        if(CollectionUtils.isNotEmpty(purchaseChangeVo.getPurchaseclause())){
            purchaseChangeVo.getPurchaseclause().forEach(vo -> {
                if("add".equals(vo.getRowState())){
                    vo.setContractId(purchaseChangeVo.getContractId());
                }
            });
        }
        if(entities != null && entities.size() > 0  && entitiesc != null && entitiesc.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity = BeanMapper.map(purchaseChangeVo, PurchaseChangeEntity.class);
        super.saveOrUpdate(entity,false);
        //会写合同表
        pcentity.setChangeStatus(2);
        pcentity.setChangingMny(entity.getContractMny());//修改变更中金额
        pcentity.setChangingTaxMny(entity.getContractTaxMny());
        pcentity.setChangeCode(entity.getBillCode());
        pcentity.setChangeId(entity.getId());
        purchaseContractService.update(pcentity, new QueryWrapper<PurchaseContractEntity>().eq("id",pcentity.getId()),false);
        PurchaseChangeVO res = BeanMapper.map(entity, PurchaseChangeVO.class);
        BigDecimal contractTaxMny = res.getContractTaxMny()==null?BigDecimal.ZERO:res.getContractTaxMny();
        BigDecimal beforeChangeTaxMny = pcentity.getBeforeChangeTaxMny()==null?BigDecimal.ZERO:pcentity.getBeforeChangeTaxMny();
        BigDecimal bb = contractTaxMny.subtract(beforeChangeTaxMny);
        if(bb.compareTo(BigDecimal.ZERO)!=0&&beforeChangeTaxMny.compareTo(BigDecimal.ZERO)!=0){
            res.setScale(new BigDecimal(100).multiply(bb.divide(beforeChangeTaxMny,8,ROUND_HALF_DOWN)));
        }else{
            res.setScale(BigDecimal.ZERO);
        }
        res.setBb(bb);
        return CommonResponse.success(res);
    }

    @Override
    public PurchaseChangeVO queryDetail(Long id) {
        PurchaseChangeEntity entity = super.selectById(id);
        PurchaseChangeVO purchaseChangeVo = BeanMapper.map(entity, PurchaseChangeVO.class);
        BigDecimal contractTaxMny = purchaseChangeVo.getContractTaxMny()==null?BigDecimal.ZERO:purchaseChangeVo.getContractTaxMny();
        BigDecimal beforeChangeTaxMny = purchaseChangeVo.getBeforeChangeTaxMny()==null?BigDecimal.ZERO:purchaseChangeVo.getBeforeChangeTaxMny();
        BigDecimal bb = contractTaxMny.subtract(beforeChangeTaxMny);
        if(bb.compareTo(BigDecimal.ZERO)!=0&&beforeChangeTaxMny.compareTo(BigDecimal.ZERO)!=0){
            purchaseChangeVo.setScale(new BigDecimal(100).multiply(bb.divide(beforeChangeTaxMny,8,ROUND_HALF_DOWN)));
        }else{
            purchaseChangeVo.setScale(BigDecimal.ZERO);
        }
        purchaseChangeVo.setBb(bb);
        return purchaseChangeVo;
    }

    @Override
    public PurchaseChangeVO queryDetails(Long id) {
        PurchaseContractEntity entity = purchaseContractService.selectById(id);
        PurchaseChangeVO purchaseChangeVo = BeanMapper.map(entity, PurchaseChangeVO.class);
        //新增逻辑处理
        purchaseChangeVo.setContractId(purchaseChangeVo.getId());
        //新增即点变更按钮穿透过来，此时ID为合同id
        purchaseChangeVo.setId(null);
        purchaseChangeVo.setBillState(null);
        purchaseChangeVo.setCreateUserCode(null);
        purchaseChangeVo.setCreateTime(null);
        purchaseChangeVo.setUpdateUserCode(null);
        purchaseChangeVo.setUpdateTime(null);
        purchaseChangeVo.setChangeDate(new Date());
        purchaseChangeVo.setBeforeContractName(entity.getContractName());
        purchaseChangeVo.setBeforeChangeMny(entity.getContractMny());
        purchaseChangeVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
        purchaseChangeVo.setBeforeContractName(purchaseChangeVo.getContractName());

        List<PurchaseContractDetailEntity> details = null;
        LambdaQueryWrapper<PurchaseContractDetailEntity> lambda = Wrappers.<PurchaseContractDetailEntity>lambdaQuery();
        lambda.eq(PurchaseContractDetailEntity::getContractId,id);
        lambda.ne(PurchaseContractDetailEntity::getChangeType,"3");
        details = purchaseContractDetailService.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            purchaseChangeVo.setPurchasedetail(BeanMapper.mapList(details,PurchaseChangeDetailVO.class));
            purchaseChangeVo.getPurchasedetail().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setChangeType("4");
                vo.setRowState("add");
//                vo.setId(null);
            });
        }else{
            purchaseChangeVo.setPurchasedetail(null);
        }
        if(CollectionUtils.isNotEmpty(purchaseChangeVo.getPurchasefee())){
            purchaseChangeVo.getPurchasefee().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
//                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(purchaseChangeVo.getPurchaseclause())){
            purchaseChangeVo.getPurchaseclause().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
//                vo.setId(null);
            });
        }
        return purchaseChangeVo;
    }

    @Override
    public PurchaseChangeRecordVO queryChangeRecord(Long id) {
        PurchaseChangeRecordVO vo = new PurchaseChangeRecordVO();
        PurchaseContractEntity entity = purchaseContractService.selectById(id);
        BigDecimal baseTaxMoney = entity.getBaseTaxMoney()==null?BigDecimal.ZERO:entity.getBaseTaxMoney();
        BigDecimal contractTaxMny = entity.getContractTaxMny()==null?BigDecimal.ZERO:entity.getContractTaxMny();
        vo.setBaseTaxMoney(baseTaxMoney);
        vo.setContractId(id);
        vo.setContractTaxMny(contractTaxMny);
        vo.setSumChangeMny(contractTaxMny.subtract(baseTaxMoney));
        vo.setContractStatus(entity.getContractStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        if(vo.getSumChangeMny().compareTo(BigDecimal.ZERO)!=0&&baseTaxMoney.compareTo(BigDecimal.ZERO)!=0){
            vo.setSumScale(new BigDecimal(100).multiply(vo.getSumChangeMny().divide(baseTaxMoney,8,ROUND_HALF_DOWN)));
        }else{
            vo.setSumScale(BigDecimal.ZERO);
        }

        if(entity.getChangeVersion()>0){
            //合同版本号>0说明会有变更记录
            LambdaQueryWrapper<PurchaseChangeEntity> lambda = Wrappers.<PurchaseChangeEntity>lambdaQuery();
            lambda.eq(PurchaseChangeEntity::getContractId,id);
            lambda.in(PurchaseChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
            List<PurchaseChangeEntity> entities = super.list(lambda);
//            entities.forEach(changevo -> {
//                if(changevo.getChangeVersion()<10){
//                    changevo.setBillCode(changevo.getBillCode()+"-0"+changevo.getChangeVersion());
//                }else{
//                    changevo.setBillCode(changevo.getBillCode()+"-"+changevo.getChangeVersion());
//                }
//              }
//            );
            vo.setChangeRecord(BeanMapper.mapList(entities, PurchaseChangeVO.class));
        }
        return vo;
    }

    @Override
    public void deletePurchaseChange(List<PurchaseChangeVO> vos) {
        PurchaseChangeVO purchaseChangeVo = vos.get(0);
        PurchaseChangeEntity entity = super.selectById(purchaseChangeVo.getId());
        //合同变更只有详情页有删除
        PurchaseContractEntity pcentity = purchaseContractService.selectById(entity.getContractId());
        //会写合同表
        pcentity.setId(entity.getContractId());
        pcentity.setChangeVersion(pcentity.getChangeVersion()-1);
        pcentity.setChangeStatus(1);
        pcentity.setChangingMny(BigDecimal.ZERO);//修改变更中金额
        pcentity.setChangingTaxMny(BigDecimal.ZERO);
        pcentity.setChangeCode(null);
        pcentity.setChangeId(null);
        purchaseContractService.update(pcentity, new QueryWrapper<PurchaseContractEntity>().eq("id",pcentity.getId()),false);
        super.removeByIds(vos.stream().map(PurchaseChangeVO::getId).collect(Collectors.toList()),false);
    }


}
