package com.ejianc.business.equipment.controller.api;

import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.vo.warn.EquipmentWarnVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/equipmentApi/")
public class EquipmentWarnApi {
    @Autowired
    private IPurchaseContractService purchaseContractService;
    /**
     * 租户下，按照项目分类，支出合同累计金额-设备租赁，设备采购合同累计
     * @param tenantIds
     * @return
     */
    @PostMapping(value = "equipmentProjectOutMny")
    public CommonResponse<List<EquipmentWarnVo>> equipmentProjectOutMny(@RequestBody List<Long> tenantIds) {
        return CommonResponse.success("获取物资合同支出累计",purchaseContractService.equipmentProjectOutMny(tenantIds));
    }
}
