package com.ejianc.business.equipment.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.equipment.bean.PurchaseChangeEntity;
import com.ejianc.business.equipment.bean.PurchaseContractDetailEntity;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.mapper.PurchaseChangeMapper;
import com.ejianc.business.equipment.service.IPurchaseChangeService;
import com.ejianc.business.equipment.service.IPurchaseContractDetailService;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * <p>
 * 设备合同变更表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("PurchaseChangeService")
public class PurchaseChangeServiceImpl extends BaseServiceImpl<PurchaseChangeMapper, PurchaseChangeEntity> implements IPurchaseChangeService {

    private static final String PURCHASE_CHANGE_BILL_CODE = "EQUIPMENT_PURCHASE";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PARAM_TOTAL_MNY = "P-oIwZ5646"; // 【预算机械费总金额】控 【设备合同总金额】
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IPurchaseContractService purchaseContractService;

    @Autowired
    private IPurchaseContractDetailService purchaseContractDetailService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Override
    public CommonResponse<PurchaseChangeVO> saveOrUpdate(PurchaseChangeVO purchaseChangeVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseChangeEntity entity = null;
        List<PurchaseContractEntity> entitiesc = null;
        List<PurchaseChangeEntity> entities = null;


        //变更合同只能存在一条未生效的
        LambdaQueryWrapper<PurchaseChangeEntity> lambdachange = Wrappers.<PurchaseChangeEntity>lambdaQuery();
        lambdachange.eq(PurchaseChangeEntity::getTenantId, tenantId);
        lambdachange.eq(PurchaseChangeEntity::getContractId,purchaseChangeVo.getContractId());
        if(purchaseChangeVo.getId() != null && purchaseChangeVo.getId() > 0) {
            lambdachange.ne(PurchaseChangeEntity::getId,purchaseChangeVo.getId());
        }
        lambdachange.ne(PurchaseChangeEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(PurchaseChangeEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }

        PurchaseContractEntity pcentity = purchaseContractService.selectById(purchaseChangeVo.getContractId());
        if(StringUtils.isEmpty(purchaseChangeVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PURCHASE_CHANGE_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                purchaseChangeVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(purchaseChangeVo.getId() != null && purchaseChangeVo.getId() > 0) {
            //修改 校验合同编号唯一，变更单除去本单，采购合同  同时唯一
            LambdaQueryWrapper<PurchaseChangeEntity> lambda = Wrappers.<PurchaseChangeEntity>lambdaQuery();
            lambda.eq(PurchaseChangeEntity::getBillCode, purchaseChangeVo.getBillCode());
            lambda.eq(PurchaseChangeEntity::getTenantId, tenantId);
            lambda.ne(PurchaseChangeEntity::getContractId,purchaseChangeVo.getContractId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,purchaseChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE,purchaseChangeVo.getContractId()));
            entitiesc = purchaseContractService.queryList(queryParam,false);

            pcentity.setId(purchaseChangeVo.getContractId());

        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<PurchaseChangeEntity> lambda = Wrappers.<PurchaseChangeEntity>lambdaQuery();
            lambda.eq(PurchaseChangeEntity::getTenantId, tenantId);
            lambda.eq(PurchaseChangeEntity::getBillCode, purchaseChangeVo.getBillCode());
            lambda.ne(PurchaseChangeEntity::getContractId,purchaseChangeVo.getContractId());
            entities = super.list(lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,purchaseChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE,purchaseChangeVo.getContractId()));
            entitiesc = purchaseContractService.queryList(queryParam,false);
            //新增即点变更按钮穿透过来，此时ID为合同id
            pcentity.setId(purchaseChangeVo.getContractId());
            pcentity.setChangeVersion(purchaseChangeVo.getChangeVersion()+1);
            purchaseChangeVo.setChangeVersion(purchaseChangeVo.getChangeVersion()+1);
            purchaseChangeVo.setMakeTime(new Date());
        }

        if(CollectionUtils.isNotEmpty(purchaseChangeVo.getPurchasedetail())){
            purchaseChangeVo.getPurchasedetail().forEach(vo -> {
                //变更类型1-增补，2-变更，3-中止
                if("add".equals(vo.getRowState())){
//                        vo.setContractDetailId(vo.getId());
                    vo.setContractId(purchaseChangeVo.getContractId());
//                        vo.setChangeType(1);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(purchaseChangeVo.getPurchasefee())){
            purchaseChangeVo.getPurchasefee().forEach(vo -> {
                if("add".equals(vo.getRowState())){
                    vo.setContractId(purchaseChangeVo.getContractId());
                }
            });
        }
        if(CollectionUtils.isNotEmpty(purchaseChangeVo.getPurchaseclause())){
            purchaseChangeVo.getPurchaseclause().forEach(vo -> {
                if("add".equals(vo.getRowState())){
                    vo.setContractId(purchaseChangeVo.getContractId());
                }
            });
        }
        if(entities != null && entities.size() > 0  && entitiesc != null && entitiesc.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity = BeanMapper.map(purchaseChangeVo, PurchaseChangeEntity.class);
        super.saveOrUpdate(entity,false);
        //会写合同表
        pcentity.setChangeStatus(2);
        pcentity.setChangingMny(entity.getContractMny());//修改变更中金额
        pcentity.setChangingTaxMny(entity.getContractTaxMny());
        pcentity.setChangeCode(entity.getBillCode());
        pcentity.setChangeId(entity.getId());
        purchaseContractService.update(pcentity, new QueryWrapper<PurchaseContractEntity>().eq("id",pcentity.getId()),false);
        PurchaseChangeVO res = BeanMapper.map(entity, PurchaseChangeVO.class);
        BigDecimal contractTaxMny = res.getContractTaxMny()==null?BigDecimal.ZERO:res.getContractTaxMny();
        BigDecimal beforeChangeTaxMny = pcentity.getBeforeChangeTaxMny()==null?BigDecimal.ZERO:pcentity.getBeforeChangeTaxMny();
        BigDecimal bb = contractTaxMny.subtract(beforeChangeTaxMny);
        if(bb.compareTo(BigDecimal.ZERO)!=0&&beforeChangeTaxMny.compareTo(BigDecimal.ZERO)!=0){
            res.setScale(new BigDecimal(100).multiply(bb.divide(beforeChangeTaxMny,8,ROUND_HALF_DOWN)));
        }else{
            res.setScale(BigDecimal.ZERO);
        }
        res.setBb(bb);
        return CommonResponse.success(res);
    }

    @Override
    public PurchaseChangeVO queryDetail(Long id) {
        PurchaseChangeEntity entity = super.selectById(id);
        PurchaseChangeVO purchaseChangeVo = BeanMapper.map(entity, PurchaseChangeVO.class);
        BigDecimal contractTaxMny = purchaseChangeVo.getContractTaxMny()==null?BigDecimal.ZERO:purchaseChangeVo.getContractTaxMny();
        BigDecimal beforeChangeTaxMny = purchaseChangeVo.getBeforeChangeTaxMny()==null?BigDecimal.ZERO:purchaseChangeVo.getBeforeChangeTaxMny();
        BigDecimal bb = contractTaxMny.subtract(beforeChangeTaxMny);
        if(bb.compareTo(BigDecimal.ZERO)!=0&&beforeChangeTaxMny.compareTo(BigDecimal.ZERO)!=0){
            purchaseChangeVo.setScale(new BigDecimal(100).multiply(bb.divide(beforeChangeTaxMny,8,ROUND_HALF_DOWN)));
        }else{
            purchaseChangeVo.setScale(BigDecimal.ZERO);
        }
        purchaseChangeVo.setBb(bb);
        return purchaseChangeVo;
    }

    @Override
    public PurchaseChangeVO queryDetails(Long id) {
        PurchaseContractEntity entity = purchaseContractService.selectById(id);
        PurchaseChangeVO purchaseChangeVo = BeanMapper.map(entity, PurchaseChangeVO.class);
        //新增逻辑处理
        purchaseChangeVo.setContractId(purchaseChangeVo.getId());
        //新增即点变更按钮穿透过来，此时ID为合同id
        purchaseChangeVo.setId(null);
        purchaseChangeVo.setBillState(null);
        purchaseChangeVo.setCreateUserCode(null);
        purchaseChangeVo.setCreateTime(null);
        purchaseChangeVo.setUpdateUserCode(null);
        purchaseChangeVo.setUpdateTime(null);
        purchaseChangeVo.setChangeDate(new Date());
        purchaseChangeVo.setBeforeContractName(entity.getContractName());
        purchaseChangeVo.setBeforeChangeMny(entity.getContractMny());
        purchaseChangeVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
        purchaseChangeVo.setBeforeContractName(purchaseChangeVo.getContractName());

        List<PurchaseContractDetailEntity> details = null;
        LambdaQueryWrapper<PurchaseContractDetailEntity> lambda = Wrappers.<PurchaseContractDetailEntity>lambdaQuery();
        lambda.eq(PurchaseContractDetailEntity::getContractId,id);
        lambda.ne(PurchaseContractDetailEntity::getChangeType,"3");
        details = purchaseContractDetailService.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            purchaseChangeVo.setPurchasedetail(BeanMapper.mapList(details,PurchaseChangeDetailVO.class));
            purchaseChangeVo.getPurchasedetail().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setChangeType("4");
                vo.setRowState("add");
//                vo.setId(null);
            });
        }else{
            purchaseChangeVo.setPurchasedetail(null);
        }
        if(CollectionUtils.isNotEmpty(purchaseChangeVo.getPurchasefee())){
            purchaseChangeVo.getPurchasefee().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
//                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(purchaseChangeVo.getPurchaseclause())){
            purchaseChangeVo.getPurchaseclause().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
//                vo.setId(null);
            });
        }
        return purchaseChangeVo;
    }

    @Override
    public PurchaseChangeRecordVO queryChangeRecord(Long id) {
        PurchaseChangeRecordVO vo = new PurchaseChangeRecordVO();
        PurchaseContractEntity entity = purchaseContractService.selectById(id);
        BigDecimal baseTaxMoney = entity.getBaseTaxMoney()==null?BigDecimal.ZERO:entity.getBaseTaxMoney();
        BigDecimal contractTaxMny = entity.getContractTaxMny()==null?BigDecimal.ZERO:entity.getContractTaxMny();
        vo.setBaseTaxMoney(baseTaxMoney);
        vo.setContractId(id);
        vo.setContractTaxMny(contractTaxMny);
        vo.setSumChangeMny(contractTaxMny.subtract(baseTaxMoney));
        vo.setContractStatus(entity.getContractStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        if(vo.getSumChangeMny().compareTo(BigDecimal.ZERO)!=0&&baseTaxMoney.compareTo(BigDecimal.ZERO)!=0){
            vo.setSumScale(new BigDecimal(100).multiply(vo.getSumChangeMny().divide(baseTaxMoney,8,ROUND_HALF_DOWN)));
        }else{
            vo.setSumScale(BigDecimal.ZERO);
        }

        if(entity.getChangeVersion()>0){
            //合同版本号>0说明会有变更记录
            LambdaQueryWrapper<PurchaseChangeEntity> lambda = Wrappers.<PurchaseChangeEntity>lambdaQuery();
            lambda.eq(PurchaseChangeEntity::getContractId,id);
            lambda.in(PurchaseChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
            List<PurchaseChangeEntity> entities = super.list(lambda);
//            entities.forEach(changevo -> {
//                if(changevo.getChangeVersion()<10){
//                    changevo.setBillCode(changevo.getBillCode()+"-0"+changevo.getChangeVersion());
//                }else{
//                    changevo.setBillCode(changevo.getBillCode()+"-"+changevo.getChangeVersion());
//                }
//              }
//            );
            vo.setChangeRecord(BeanMapper.mapList(entities, PurchaseChangeVO.class));
        }
        return vo;
    }

    @Override
    public void deletePurchaseChange(List<PurchaseChangeVO> vos) {
        PurchaseChangeVO purchaseChangeVo = vos.get(0);
        PurchaseChangeEntity entity = super.selectById(purchaseChangeVo.getId());
        //合同变更只有详情页有删除
        PurchaseContractEntity pcentity = purchaseContractService.selectById(entity.getContractId());
        //会写合同表
        pcentity.setId(entity.getContractId());
        pcentity.setChangeVersion(pcentity.getChangeVersion()-1);
        pcentity.setChangeStatus(1);
        pcentity.setChangingMny(BigDecimal.ZERO);//修改变更中金额
        pcentity.setChangingTaxMny(BigDecimal.ZERO);
        pcentity.setChangeCode(null);
        pcentity.setChangeId(null);
        purchaseContractService.update(pcentity, new QueryWrapper<PurchaseContractEntity>().eq("id",pcentity.getId()),false);
        super.removeByIds(vos.stream().map(PurchaseChangeVO::getId).collect(Collectors.toList()),false);
    }


    @Override
    public BigDecimal totalContractMny(PurchaseChangeVO vo){
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        QueryWrapper<PurchaseContractEntity> queryPro = new QueryWrapper<>();
        queryPro.eq("project_Id",vo.getProjectId());
//        queryPro.in("bill_state", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode()));
//        queryPro.eq("contract_status",2);
        queryPro.in("change_status",Arrays.asList(1,3));
        if (vo.getContractId()!=null){
            queryPro.ne("id",vo.getContractId());
        }
        queryPro.select("sum(contract_tax_mny) as contractTaxMny");
        PurchaseContractEntity one = purchaseContractService.getOne(queryPro);
        if(one!=null &&null != one.getContractTaxMny()&&!"0".equals(one.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(one.getContractTaxMny());
        }
        //统计变更中的金额
        QueryWrapper<PurchaseChangeEntity> changeQuery = new QueryWrapper<>();
        changeQuery.eq("project_Id", vo.getProjectId());
        if (vo.getId()!=null){
            changeQuery.ne("id",vo.getId());
        }
        if (vo.getContractTaxMny()!=null){
            contractTaxMny =contractTaxMny.add(vo.getContractTaxMny());
        }
        changeQuery.in("bill_state", Arrays.asList(
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        changeQuery.select("sum(contract_tax_mny) as contractTaxMny");
        PurchaseChangeEntity changeEntity = super.getOne(changeQuery);
        if(changeEntity!=null &&null != changeEntity.getContractTaxMny()&&!"0".equals(changeEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(changeEntity.getContractTaxMny());
        }
        return  contractTaxMny;
    }

    @Override
    public ParamsCheckVO checkParams(PurchaseChangeVO vo) {

        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        //获取 预算机械费总金额
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType());
        CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(requestVo);
        logger.info("预算机械费总金额 返回内容:{}", JSONObject.toJSONString(res));
        if (!res.isSuccess()){
            throw new BusinessException("网络错误"+res.getMsg());
        }
        // 没有预算不控制，预算不包含不控制
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO data = res.getData();
            //      预算机械费总金额
            BigDecimal budgetTaxMny =  data.getMechanicalTaxMny()==null ? BigDecimal.ZERO : data.getMechanicalTaxMny();
            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, InvocationInfoProxy.getOrgId());
            if (!response.isSuccess()) {
                throw new BusinessException("【预算机械费总金额】控 【设备合同总金额】，获取控制参数失败，失败原因：" + response.getMsg());
            }
            //设备采购总金额
            BigDecimal purchaseContractTaxMny = totalContractMny(vo);
            //设备租赁总金额
            RentContractVO rentContract = new RentContractVO();
            rentContract.setProjectId(vo.getProjectId());
            BigDecimal rentContractTaxMny = rentContractService.totalContractMny(rentContract);
            BigDecimal totalContractMny = purchaseContractTaxMny.add(rentContractTaxMny);
            List<BillParamVO> billParamVOS = response.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                        logger.info("预算机械费总金额 :{},设置金额:{}", JSONObject.toJSONString(budgetTaxMnyResult),JSONObject.toJSONString(totalContractMny));
                        // 设备合同总金额 和 预算机械费总金额
                        if (totalContractMny.compareTo(budgetTaxMnyResult) > 0) {
                            // 超出金额 = 设备合同总金额 - 预算机械费总金额 * X%
                            BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            // 设备合同总金额：{}元，预算机械费总金额
                            paramsCheckDsVO.setWarnItem("设备合同总金额超预算机械费总金额");
                            paramsCheckDsVO.setWarnName("设备合同总金额大于预算机械费总金额 * " + roleValue + "%");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("设备合同总金额：")
                                    .append(totalContractMny.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，预算机械费总金额 * ")
                                    .append(roleValue).append("%：")
                                    .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，超出金额：")
                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                    .append("元。");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }

                }
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }

    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

}
