package com.ejianc.business.equipment.service.impl;

import cn.hutool.log.Log;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.equipment.bean.*;
import com.ejianc.business.equipment.controller.PurchaseContractController;
import com.ejianc.business.equipment.controller.SqlParam;
import com.ejianc.business.equipment.mapper.PurchaseContractMapper;
import com.ejianc.business.equipment.service.*;
import com.ejianc.business.equipment.utils.ListSplitUtil;
import com.ejianc.business.equipment.vo.*;
import com.ejianc.business.equipment.vo.warn.EquipmentWarnVo;
import com.ejianc.business.equipment.vo.ParamsCheckDsVO;
import com.ejianc.business.equipment.vo.ParamsCheckVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

@Service("PurchaseContractService")
public class PurchaseContractServiceImpl extends BaseServiceImpl<PurchaseContractMapper, PurchaseContractEntity> implements IPurchaseContractService {

    private static final String PURCHASE_CONTRACT_BILL_CODE = "EQUIPMENT_PURCHASE";
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    private static final String PARAM_TOTAL_MNY = "P-oIwZ5646"; // 【预算机械费总金额】控 【设备合同总金额】

    @Autowired
    private IPurchaseChangeService purchaseChangeService;
    @Autowired
    private IPurchaseContractDetailService purchaseContractDetailService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IRentSettlementService settlementService;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Override
    public CommonResponse<PurchaseContractVO> saveOrUpdate(PurchaseContractVO purchaseContractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseContractEntity entity = BeanMapper.map(purchaseContractVo, PurchaseContractEntity.class);
        String operateType = null;
        List<PurchaseContractEntity> entities = null;
        List<PurchaseChangeEntity> entitiesc = null;
        if(StringUtils.isEmpty(purchaseContractVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PURCHASE_CONTRACT_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(purchaseContractVo.getId() != null && purchaseContractVo.getId() > 0) {
            //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
            LambdaQueryWrapper<PurchaseContractEntity> lambda = Wrappers.<PurchaseContractEntity>lambdaQuery();
            lambda.eq(PurchaseContractEntity::getBillCode, purchaseContractVo.getBillCode());
            lambda.eq(PurchaseContractEntity::getTenantId, tenantId);
            lambda.ne(PurchaseContractEntity::getId, purchaseContractVo.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,purchaseContractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE,purchaseContractVo.getId()));
            entitiesc = purchaseChangeService.queryList(queryParam,false);
        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<PurchaseContractEntity> lambda = Wrappers.<PurchaseContractEntity>lambdaQuery();
            lambda.eq(PurchaseContractEntity::getTenantId, tenantId);
            lambda.eq(PurchaseContractEntity::getBillCode, purchaseContractVo.getBillCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,purchaseContractVo.getBillCode()));
            entitiesc = purchaseChangeService.queryList(queryParam,false);

            entity.setChangeVersion(0);
            entity.setChangeStatus(1);
        }
        if(entities != null && entities.size() > 0  && entitiesc != null && entitiesc.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setBaseMoney(purchaseContractVo.getContractMny()==null?BigDecimal.ZERO:purchaseContractVo.getContractMny());
        entity.setBaseTaxMoney(purchaseContractVo.getContractTaxMny()==null?BigDecimal.ZERO:purchaseContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(purchaseContractVo.getContractMny()==null?BigDecimal.ZERO:purchaseContractVo.getContractMny());
        entity.setBeforeChangeTaxMny(purchaseContractVo.getContractTaxMny()==null?BigDecimal.ZERO:purchaseContractVo.getContractTaxMny());
//        entity.setDr(0);

        //


        super.saveOrUpdate(entity,false);

        return CommonResponse.success(BeanMapper.map(entity, PurchaseContractVO.class));
    }

    @Override
    public PurchaseContractVO queryDetail(Long id) {
        PurchaseContractEntity entity = super.selectById(id);
        //先请客详情表
        entity.setPurchasedetail(null);
        PurchaseContractVO purchaseContractVo = BeanMapper.map(entity, PurchaseContractVO.class);
        List<PurchaseContractDetailEntity> details = null;
        LambdaQueryWrapper<PurchaseContractDetailEntity> lambda = Wrappers.<PurchaseContractDetailEntity>lambdaQuery();
        lambda.eq(PurchaseContractDetailEntity::getContractId,id);
        lambda.ne(PurchaseContractDetailEntity::getChangeType,"3");
        details = purchaseContractDetailService.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            purchaseContractVo.setPurchasedetail(BeanMapper.mapList(details,PurchaseContractDetailVO.class));
        }
        return purchaseContractVo;
    }
    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("sum(base_tax_money) as originalAmount, sum(contract_tax_mny) as curAmount");
        resp = super.getMap(wrapper);
//
        return resp;
    }
    @Override
    public void deletePurchaseContract(List<PurchaseContractVO> vos) {
        super.removeByIds(vos.stream().map(PurchaseContractVO::getId).collect(Collectors.toList()),false);
    }

    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(baseMapper.querySettleWarnContract(list));
        }
        return result;
    }
    @Override
    public List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(baseMapper.queryPayWarnContract(list));
        }
        return result;
    }
    @Override
    public List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(baseMapper.queryPrePayWarnContract(list));
        }
        return result;
    }
    @Override
    public List<Map<String, Object>> invoicePayMnyWarn(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(baseMapper.invoicePayMnyWarn(list));
        }
        return result;
    }
    @Override
    public List<Map<String, Object>> invoiceContractMnyWarn(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(baseMapper.invoiceContractMnyWarn(list));
        }
        return result;
    }

    @Override
    public List<EquipmentWarnVo> equipmentProjectOutMny(List<Long> tenantIds) {
        return baseMapper.equipmentProjectOutMny(tenantIds);
    }

    @Override
    public List<EquipmentReportVo> getMonthEquipmentMny(Long projectId, Integer lastDay) {
        return baseMapper.getMonthEquipmentMny(projectId,lastDay);
    }

    @Override
    public List<EquipmentReportVo> getEquipment(Long projectId) {
        BigDecimal cgmny = BigDecimal.ZERO;//采购
        BigDecimal cgsettleMny = BigDecimal.ZERO;//采购结算
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper<PurchaseContractEntity> lambda = Wrappers.<PurchaseContractEntity>lambdaQuery();
        lambda.eq(PurchaseContractEntity::getProjectId, projectId);
        lambda.eq(PurchaseContractEntity::getDr, 0);
        lambda.in(PurchaseContractEntity::getBillState, billStatus);
        List<PurchaseContractEntity> quoteEntities = super.list(lambda);
        for (PurchaseContractEntity ce : quoteEntities) {
            cgmny = cgmny.add(ce.getContractTaxMny() == null?BigDecimal.ZERO:ce.getContractTaxMny());
        }
        LambdaQueryWrapper<PurchaseSettlementEntity> lambda2 = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambda2.eq(PurchaseSettlementEntity::getProjectId, projectId);
        lambda2.eq(PurchaseSettlementEntity::getDr, 0);
        lambda2.in(PurchaseSettlementEntity::getBillState, billStatus);
        List<PurchaseSettlementEntity> purchaseSettlementEntities = purchaseSettlementService.list(lambda2);
        for (PurchaseSettlementEntity ce : purchaseSettlementEntities) {
            cgsettleMny = cgsettleMny.add(ce.getSettlementTaxMny() == null?BigDecimal.ZERO:ce.getSettlementTaxMny());
        }
        EquipmentReportVo vo =new EquipmentReportVo();
        vo.setMny(cgmny);
        vo.setNum(quoteEntities.size());
        vo.setSettleMny(cgsettleMny);

        BigDecimal zlmny = BigDecimal.ZERO;//租赁
        BigDecimal zlsettleMny = BigDecimal.ZERO;//租赁结算
        LambdaQueryWrapper<RentContractEntity> lambda3 = Wrappers.<RentContractEntity>lambdaQuery();
        lambda3.eq(RentContractEntity::getProjectId, projectId);
        lambda3.eq(RentContractEntity::getDr, 0);
        lambda3.in(RentContractEntity::getBillState, billStatus);
        List<RentContractEntity> rentContractEntities = rentContractService.list(lambda3);
        for (RentContractEntity ce : rentContractEntities) {
            zlmny = zlmny.add(ce.getContractTaxMny() == null?BigDecimal.ZERO:ce.getContractTaxMny());
        }
        LambdaQueryWrapper<RentSettlementEntity> lambda4 = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambda4.eq(RentSettlementEntity::getProjectId, projectId);
        lambda4.eq(RentSettlementEntity::getDr, 0);
        lambda4.in(RentSettlementEntity::getBillState, billStatus);
        List<RentSettlementEntity> rentSettlementEntities = settlementService.list(lambda4);
        for (RentSettlementEntity ce : rentSettlementEntities) {
            zlsettleMny = zlsettleMny.add(ce.getSettlementTaxMny() == null?BigDecimal.ZERO:ce.getSettlementTaxMny());
        }
        EquipmentReportVo vo2 =new EquipmentReportVo();
        vo2.setMny(zlmny);
        vo2.setNum(rentContractEntities.size());
        vo2.setSettleMny(zlsettleMny);
        List<EquipmentReportVo> list=new ArrayList<>();
        list.add(vo);
        list.add(vo2);
        return list;
    }

    @Override
    public List<SettlementVO> getSettleMny(List<Long> projectIds) {
        return baseMapper.getSettleMny(projectIds);
    }

    @Override
    public BigDecimal totalContractMny(PurchaseContractVO vo){
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        QueryWrapper<PurchaseContractEntity> queryPro = new QueryWrapper<>();
        queryPro.eq("project_Id",vo.getProjectId());
//        queryPro.in("bill_state", Arrays.asList(
//                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
//                BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode()));
//        queryPro.eq("contract_status",2);
        queryPro.ne("change_status",2);
        if (vo.getId()!=null){
            queryPro.ne("id",vo.getId());

        }
        if (vo.getContractTaxMny()!=null){
            contractTaxMny =contractTaxMny.add(vo.getContractTaxMny());
        }
        queryPro.select("sum(contract_tax_mny) as contractTaxMny");
        PurchaseContractEntity one = super.getOne(queryPro);
        if(one!=null &&null != one.getContractTaxMny()&&!"0".equals(one.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(one.getContractTaxMny());
        }
        //统计变更中的金额
        QueryWrapper<PurchaseChangeEntity> changeQuery = new QueryWrapper<>();
        changeQuery.eq("project_Id", vo.getProjectId());
        changeQuery.in("bill_state", Arrays.asList(
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        changeQuery.select("sum(contract_tax_mny) as contractTaxMny");
        PurchaseChangeEntity changeEntity = purchaseChangeService.getOne(changeQuery);
        if(changeEntity!=null &&null != changeEntity.getContractTaxMny()&&!"0".equals(changeEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(changeEntity.getContractTaxMny());
        }
        return  contractTaxMny;
    }



    /**
     * 参数控制
     *
     * @param vo 预算机械费总金额  设备采购总金额
     *
     * @return {@link ParamsCheckVO}
     */
    public ParamsCheckVO checkParams(PurchaseContractVO vo) {
        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        //获取 预算机械费总金额
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType());
        CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(requestVo);
        logger.info("预算机械费总金额 返回内容:{}", JSONObject.toJSONString(res));
        if (!res.isSuccess()){
            throw new BusinessException("网络错误"+res.getMsg());
        }
        // 没有预算不控制，预算不包含不控制
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO data = res.getData();
            //      预算机械费总金额
            BigDecimal budgetTaxMny =  data.getMechanicalTaxMny()==null ? BigDecimal.ZERO : data.getMechanicalTaxMny();
            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, InvocationInfoProxy.getOrgId());
            if (!response.isSuccess()) {
                throw new BusinessException("【预算机械费总金额】控 【设备合同总金额】，获取控制参数失败，失败原因：" + response.getMsg());
            }
            //设备采购总金额
            BigDecimal purchaseContractTaxMny = totalContractMny(vo);
            //设备租赁总金额
            RentContractVO rentContract = new RentContractVO();
            rentContract.setProjectId(vo.getProjectId());
            BigDecimal rentContractTaxMny = rentContractService.totalContractMny(rentContract);
            BigDecimal totalContractMny = purchaseContractTaxMny.add(rentContractTaxMny);
            List<BillParamVO> billParamVOS = response.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                        logger.info("预算机械费总金额 :{},设置金额:{}", JSONObject.toJSONString(budgetTaxMnyResult),JSONObject.toJSONString(totalContractMny));
                        // 设备合同总金额 和 预算机械费总金额
                        if (totalContractMny.compareTo(budgetTaxMnyResult) > 0) {
                            // 超出金额 = 设备合同总金额 - 预算机械费总金额 * X%
                            BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            // 设备合同总金额：{}元，预算机械费总金额
                            paramsCheckDsVO.setWarnItem("设备合同总金额超预算机械费总金额");
                            paramsCheckDsVO.setWarnName("设备合同总金额大于预算机械费总金额 * " + roleValue + "%");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("设备合同总金额：")
                                    .append(totalContractMny.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，预算机械费总金额 * ")
                                    .append(roleValue).append("%：")
                                    .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，超出金额：")
                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                    .append("元。");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }

                }
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
    private Integer totalMnyControl(PurchaseContractVO vo, List<ParamsCheckDsVO> checkDsVOS, Integer controlType) {
        //获取 预算机械费总金额
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType());
        CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(requestVo);
//        logger.info("预算机械费总金额 返回内容:{}", JSONObject.toJSONString(res));
        if (!res.isSuccess()){
            throw new BusinessException("网络错误"+res.getMsg());
        }

        // 没有预算不控制，预算不包含不控制
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO data = res.getData();
            //      预算机械费总金额
            BigDecimal budgetTaxMny =  data.getMechanicalTaxMny()==null ? BigDecimal.ZERO : data.getMechanicalTaxMny();
            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, InvocationInfoProxy.getOrgId());

            if (!response.isSuccess()) {
                throw new BusinessException("【预算机械费总金额】控 【设备合同总金额】，获取控制参数失败，失败原因：" + response.getMsg());
            } //设备采购总金额
            BigDecimal purchaseContractTaxMny = totalContractMny(vo);
            //设备租赁总金额
            RentContractVO rentContract = new RentContractVO();
            rentContract.setProjectId(vo.getProjectId());
            BigDecimal rentContractTaxMny = rentContractService.totalContractMny(rentContract);
            BigDecimal totalContractMny = purchaseContractTaxMny.add(rentContractTaxMny);
            List<BillParamVO> billParamVOS = response.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                    BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                    logger.info("预算机械费总金额 :{},设置金额:{}", JSONObject.toJSONString(budgetTaxMnyResult),JSONObject.toJSONString(totalContractMny));
                    // 设备合同总金额 和 预算机械费总金额
                    if (totalContractMny.compareTo(budgetTaxMnyResult) > 0) {
                        controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;

                        // 超出金额 = 设备合同总金额 - 预算机械费总金额 * X%
                        BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
//                       设备合同总金额：{}元，预算机械费总金额
                        paramsCheckDsVO.setWarnItem("设备合同总金额超预算机械费总金额");
                        paramsCheckDsVO.setWarnName("设备合同总金额大于预算机械费总金额 * " + roleValue + "%");
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("设备合同总金额：")
                                .append(totalContractMny.setScale(2, RoundingMode.HALF_UP))
                                .append("元，预算机械费总金额 * ")
                                .append(roleValue).append("%：")
                                .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                .append("元，超出金额：")
                                .append(over.setScale(2, RoundingMode.HALF_UP))
                                .append("元。");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                }
            }

        }
        return controlType;
    }












}