package com.ejianc.business.equipment.service;

import com.ejianc.business.equipment.bean.RentUseRecordEntity;
import com.ejianc.business.equipment.vo.ParamsCheckVO;
import com.ejianc.business.equipment.vo.RentUseRecordVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * <p>
 * 租赁设备使用记录 服务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-11
 */
public interface IRentUseRecordService extends IBaseService<RentUseRecordEntity> {
    /**
     * 保存或修改信息
     *
     * @param RentUseRecordVo
     * @return
     */
    CommonResponse<RentUseRecordVO> saveOrUpdate(RentUseRecordVO RentUseRecordVo);

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    RentUseRecordVO queryDetail(Long id);

    /**
     * 删除信息
     *
     * @param vos
     */
    void deleteRentUseRecord(List<RentUseRecordVO> vos);

    RentUseRecordVO queryDetails(Long id);

    ParamsCheckVO checkContractUseMnyRatio(RentUseRecordVO rentUseRecordVo);
}
