/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.equipment.bean.RentChangeEntity;
import com.ejianc.business.equipment.bean.RentContractDetailEntity;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.controller.SqlParam;
import com.ejianc.business.equipment.mapper.RentContractMapper;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IRentChangeService;
import com.ejianc.business.equipment.service.IRentContractDetailService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.utils.ListSplitUtil;
import com.ejianc.business.equipment.vo.ParamsCheckDsVO;
import com.ejianc.business.equipment.vo.ParamsCheckVO;
import com.ejianc.business.equipment.vo.PurchaseContractVO;
import com.ejianc.business.equipment.vo.RentContractDetailVO;
import com.ejianc.business.equipment.vo.RentContractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RentContractService")
public class RentContractServiceImpl
extends BaseServiceImpl<RentContractMapper, RentContractEntity>
implements IRentContractService {
    private static final String RENT_CONTRACT_BILL_CODE = "EQUIPMENT_RENT";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PARAM_TOTAL_MNY = "P-oIwZ5646";
    @Autowired
    private IRentChangeService rentChangeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentContractDetailService rentContractDetailService;
    @Autowired
    private RentContractMapper rentContractMapper;
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Override
    public CommonResponse<RentContractVO> saveOrUpdate(RentContractVO rentContractVo) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentContractEntity entity = (RentContractEntity)((Object)BeanMapper.map((Object)rentContractVo, RentContractEntity.class));
        Object operateType = null;
        List entities = null;
        List entitiesc = null;
        if (StringUtils.isEmpty((CharSequence)rentContractVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(RENT_CONTRACT_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (rentContractVo.getId() != null && rentContractVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(RentContractEntity::getBillCode, (Object)rentContractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)rentContractVo.getId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)rentContractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)rentContractVo.getId()));
            entitiesc = this.rentChangeService.queryList(queryParam, false);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(RentContractEntity::getBillCode, (Object)rentContractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)rentContractVo.getBillCode()));
            entitiesc = this.rentChangeService.queryList(queryParam, false);
            entity.setChangeVersion(0);
            entity.setChangeStatus(1);
        }
        if (CollectionUtils.isNotEmpty((Collection)entities) || CollectionUtils.isNotEmpty((Collection)entitiesc)) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBaseMoney(rentContractVo.getContractMny() == null ? BigDecimal.ZERO : rentContractVo.getContractMny());
        entity.setBaseTaxMoney(rentContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : rentContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(rentContractVo.getContractMny() == null ? BigDecimal.ZERO : rentContractVo.getContractMny());
        entity.setBeforeChangeTaxMny(rentContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : rentContractVo.getContractTaxMny());
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), RentContractVO.class));
    }

    @Override
    public RentContractVO queryDetail(Long id) {
        RentContractEntity entity = (RentContractEntity)((Object)super.selectById((Serializable)id));
        entity.setRentdetail(null);
        RentContractVO rentContractVo = (RentContractVO)BeanMapper.map((Object)((Object)entity), RentContractVO.class);
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(RentContractDetailEntity::getContractId, (Object)id);
        lambda.ne(RentContractDetailEntity::getChangeType, (Object)"3");
        details = this.rentContractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            rentContractVo.setRentdetail(BeanMapper.mapList((Iterable)details, RentContractDetailVO.class));
        }
        return rentContractVo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = RentContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"sum(base_tax_money) as originalAmount, sum(contract_tax_mny) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public void deleteRentContract(List<RentContractVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List lists = ListSplitUtil.splistList(sqlParamList, (int)10);
        for (List list : lists) {
            result.addAll(this.rentContractMapper.querySettleWarnContract(list));
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List lists = ListSplitUtil.splistList(sqlParamList, (int)10);
        for (List list : lists) {
            result.addAll(this.rentContractMapper.queryPayWarnContract(list));
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List lists = ListSplitUtil.splistList(sqlParamList, (int)10);
        for (List list : lists) {
            result.addAll(this.rentContractMapper.queryPrePayWarnContract(list));
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> queryTaxWarnContract(List<SqlParam> sqlParamList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List lists = ListSplitUtil.splistList(sqlParamList, (int)10);
        for (List list : lists) {
            result.addAll(this.rentContractMapper.queryTaxWarnContract(list));
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> queryContractTaxWarnContract(List<SqlParam> sqlParamList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List lists = ListSplitUtil.splistList(sqlParamList, (int)10);
        for (List list : lists) {
            result.addAll(this.rentContractMapper.queryContractTaxWarnContract(list));
        }
        return result;
    }

    @Override
    public BigDecimal totalContractMny(RentContractVO vo) {
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        QueryWrapper rentQuery = new QueryWrapper();
        rentQuery.eq((Object)"project_Id", (Object)vo.getProjectId());
        rentQuery.in((Object)"change_status", Arrays.asList(1, 3));
        if (vo.getId() != null) {
            rentQuery.ne((Object)"id", (Object)vo.getId());
        }
        if (vo.getContractTaxMny() != null) {
            contractTaxMny = contractTaxMny.add(vo.getContractTaxMny());
        }
        rentQuery.select(new String[]{"sum(contract_tax_mny) as contractTaxMny"});
        RentContractEntity rentContract = (RentContractEntity)((Object)super.getOne((Wrapper)rentQuery));
        if (rentContract != null && null != rentContract.getContractTaxMny() && !"0".equals(rentContract.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(rentContract.getContractTaxMny());
        }
        QueryWrapper changeQuery = new QueryWrapper();
        changeQuery.eq((Object)"project_Id", (Object)vo.getProjectId());
        changeQuery.in((Object)"bill_state", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        changeQuery.select(new String[]{"sum(contract_tax_mny) as contractTaxMny"});
        RentChangeEntity changeEntity = (RentChangeEntity)((Object)this.rentChangeService.getOne((Wrapper)changeQuery));
        if (changeEntity != null && null != changeEntity.getContractTaxMny() && !"0".equals(changeEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(changeEntity.getContractTaxMny());
        }
        return contractTaxMny;
    }

    @Override
    public ParamsCheckVO checkParams(RentContractVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType());
        CommonResponse res = this.budgetProjectProApi.fetchQuantityAndMny(requestVo);
        this.logger.info("\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d \u8fd4\u56de\u5185\u5bb9:{}", (Object)JSONObject.toJSONString((Object)res));
        if (!res.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u9519\u8bef" + res.getMsg());
        }
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO data = (BudgetProjectProQuantityAndMnyVO)res.getData();
            BigDecimal budgetTaxMny = data.getMechanicalTaxMny() == null ? BigDecimal.ZERO : data.getMechanicalTaxMny();
            CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, InvocationInfoProxy.getOrgId());
            if (!response.isSuccess()) {
                throw new BusinessException("\u3010\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d\u3011\u63a7 \u3010\u8bbe\u5907\u5408\u540c\u603b\u91d1\u989d\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
            }
            BigDecimal rentContractTaxMny = this.totalContractMny(vo);
            PurchaseContractVO purchaseContract = new PurchaseContractVO();
            purchaseContract.setProjectId(vo.getProjectId());
            BigDecimal purchaseContractTaxMny = this.purchaseContractService.totalContractMny(purchaseContract);
            BigDecimal totalContractMny = purchaseContractTaxMny.add(rentContractTaxMny);
            List billParamVOS = (List)response.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    BigDecimal roleValue;
                    BigDecimal scale;
                    BigDecimal budgetTaxMnyResult;
                    if (0 == billParamVO.getControlType() || totalContractMny.compareTo(budgetTaxMnyResult = budgetTaxMny.multiply(scale = (roleValue = billParamVO.getRoleValue()).divide(new BigDecimal("100")))) <= 0) continue;
                    BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("\u8bbe\u5907\u5408\u540c\u603b\u91d1\u989d\u8d85\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d");
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    paramsCheckDsVO.setWarnName("\u8bbe\u5907\u5408\u540c\u603b\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d * " + roleValue + "%");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u8bbe\u5907\u5408\u540c\u603b\u91d1\u989d\uff1a").append(totalContractMny.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d * ").append(roleValue).append("%\uff1a").append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u5143\u3002");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    RentContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                }
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }

    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
}

