package com.ejianc.business.equipment.service;

import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.controller.SqlParam;
import com.ejianc.business.equipment.vo.ParamsCheckVO;
import com.ejianc.business.equipment.vo.RentContractVO;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 设备合同表 服务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-08
 */
public interface IRentContractService extends IBaseService<RentContractEntity> {
    /**
     * 保存或修改信息
     *
     * @param RentContractVo
     * @return
     */
    CommonResponse<RentContractVO> saveOrUpdate(RentContractVO RentContractVo);

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    RentContractVO queryDetail(Long id);

    /**
     * 删除信息
     *
     */
    void deleteRentContract(List<RentContractVO> vos);
    /**
     　* @Description: 统计页面原合同总金额，现合同总金额
     　* @param [queryParam]
     　* @return java.util.Map<java.lang.String,java.math.BigDecimal>
     　* @throws
     　* @author CJ
     　* @date 2020/6/8 11:28
     　*/
    Map<String, Object> countContractAmount(QueryParam queryParam);

    List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryPayWarnContract(List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList);
    List<Map<String,Object>> queryTaxWarnContract(List<SqlParam> sqlParamList);
    List<Map<String,Object>> queryContractTaxWarnContract(List<SqlParam> sqlParamList);

    /**
     *  根据项查询当前 租赁合同总金额
     * @param vo
     * @return
     */
    BigDecimal totalContractMny(RentContractVO vo);

    /**
     * 参数控制
     *
     * @param entity 预算机械费总金额  设备租赁总金额
     *
     * @return {@link ParamsCheckVO}
     */
    ParamsCheckVO checkParams(RentContractVO entity);

    BigDecimal fetchSjzcjeRent(Long projectId);

    /**
     * @return {@link PicketageVO}
     *
     * @description: 根据定标单回写已签合同数量和金额
     * @author songlx
     * @date: 2023/11/8
     */
    PicketageVO countContractNumAndMnyByEnquiry(Long... enquiryPriceBillIds);
}
