package com.ejianc.business.equipment.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.equipment.bean.RentChangeEntity;
import com.ejianc.business.equipment.bean.RentContractDetailEntity;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.mapper.PurchaseContractMapper;
import com.ejianc.business.equipment.mapper.RentChangeMapper;
import com.ejianc.business.equipment.mapper.RentContractMapper;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IRentChangeService;
import com.ejianc.business.equipment.service.IRentContractDetailService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.vo.*;
import com.ejianc.business.finance.api.IFinanceLoadReimburseApi;
import com.ejianc.business.finance.api.IFinancePayReimburseApi;
import com.ejianc.business.finance.api.IFinancePaySporadicApi;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * <p>
 * 设备合同表 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-09
 */
@Service("RentChangeService")
public class RentChangeServiceImpl extends BaseServiceImpl<RentChangeMapper, RentChangeEntity> implements IRentChangeService {
    private static final String RENT_CHANGE_BILL_CODE = "EQUIPMENT_RENT_CHANGE";

    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IRentContractDetailService rentContractDetailService;
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PARAM_TOTAL_MNY = "P-oIwZ5646"; // 【预算机械费总金额】控 【设备合同总金额】
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private PurchaseContractMapper purchaseContractMapper;
    @Autowired
    private RentContractMapper rentContractMapper;

    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IFinancePayReimburseApi financePayReimburseApi;
    @Autowired
    private IFinancePaySporadicApi financePaySporadicApi;
    @Autowired
    private IFinanceLoadReimburseApi financeLoadReimburseApi;

    @Override
    public CommonResponse<RentChangeVO> saveOrUpdate(RentChangeVO rentChangeVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentChangeEntity entity = null;
        List<RentContractEntity> entitiesc = null;
        List<RentChangeEntity> entities = null;


        //变更合同只能存在一条未生效的
        LambdaQueryWrapper<RentChangeEntity> lambdachange = Wrappers.<RentChangeEntity>lambdaQuery();
        lambdachange.eq(RentChangeEntity::getTenantId, tenantId);
        lambdachange.eq(RentChangeEntity::getContractId,rentChangeVo.getContractId());
        if(rentChangeVo.getId() != null && rentChangeVo.getId() > 0) {
            lambdachange.ne(RentChangeEntity::getId,rentChangeVo.getId());
        }
        lambdachange.ne(RentChangeEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(RentChangeEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }

        RentContractEntity pcentity = rentContractService.selectById(rentChangeVo.getContractId());
        if(StringUtils.isEmpty(rentChangeVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RENT_CHANGE_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                rentChangeVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(rentChangeVo.getId() != null && rentChangeVo.getId() > 0) {
            //修改 校验合同编号唯一，变更单除去本单，采购合同  同时唯一
            LambdaQueryWrapper<RentChangeEntity> lambda = Wrappers.<RentChangeEntity>lambdaQuery();
            lambda.eq(RentChangeEntity::getBillCode, rentChangeVo.getBillCode());
            lambda.eq(RentChangeEntity::getTenantId, tenantId);
            lambda.ne(RentChangeEntity::getContractId,rentChangeVo.getContractId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,rentChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE,rentChangeVo.getContractId()));
            entitiesc = rentContractService.queryList(queryParam,false);

            pcentity.setId(rentChangeVo.getContractId());

        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<RentChangeEntity> lambda = Wrappers.<RentChangeEntity>lambdaQuery();
            lambda.eq(RentChangeEntity::getTenantId, tenantId);
            lambda.eq(RentChangeEntity::getBillCode, rentChangeVo.getBillCode());
            lambda.ne(RentChangeEntity::getContractId,rentChangeVo.getContractId());
            entities = super.list(lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,rentChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE,rentChangeVo.getContractId()));
            entitiesc = rentContractService.queryList(queryParam,false);
            //新增即点变更按钮穿透过来，此时ID为合同id
            pcentity.setId(rentChangeVo.getContractId());
            pcentity.setChangeVersion(rentChangeVo.getChangeVersion()+1);
            rentChangeVo.setChangeVersion(rentChangeVo.getChangeVersion()+1);
            rentChangeVo.setMakeTime(new Date());
        }

        if(CollectionUtils.isNotEmpty(rentChangeVo.getRentdetail())){
            rentChangeVo.getRentdetail().forEach(vo -> {
                //变更类型1-增补，2-变更，3-中止
                if("add".equals(vo.getRowState())){
//                        vo.setContractDetailId(vo.getId());
                    vo.setContractId(rentChangeVo.getContractId());
//                        vo.setChangeType(1);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(rentChangeVo.getRentfee())){
            rentChangeVo.getRentfee().forEach(vo -> {
                if("add".equals(vo.getRowState())){
                    vo.setContractId(rentChangeVo.getContractId());
                }
            });
        }
        if(CollectionUtils.isNotEmpty(rentChangeVo.getRentclause())){
            rentChangeVo.getRentclause().forEach(vo -> {
                if("add".equals(vo.getRowState())){
                    vo.setContractId(rentChangeVo.getContractId());
                }
            });
        }
        if(CollectionUtils.isNotEmpty(entities) || CollectionUtils.isNotEmpty(entitiesc)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity = BeanMapper.map(rentChangeVo, RentChangeEntity.class);
        super.saveOrUpdate(entity,false);
        //会写合同表
        pcentity.setChangeStatus(2);
        pcentity.setChangingMny(entity.getContractMny());//修改变更中金额
        pcentity.setChangingTaxMny(entity.getContractTaxMny());
        pcentity.setChangeCode(entity.getBillCode());
        pcentity.setChangeId(entity.getId());
        rentContractService.update(pcentity, new QueryWrapper<RentContractEntity>().eq("id",pcentity.getId()),false);
        RentChangeVO res = BeanMapper.map(entity, RentChangeVO.class);
        BigDecimal contractTaxMny = res.getContractTaxMny()==null?BigDecimal.ZERO:res.getContractTaxMny();
        BigDecimal beforeChangeTaxMny = pcentity.getBeforeChangeTaxMny()==null?BigDecimal.ZERO:pcentity.getBeforeChangeTaxMny();
        BigDecimal bb = contractTaxMny.subtract(beforeChangeTaxMny);
        if(beforeChangeTaxMny.compareTo(BigDecimal.ZERO)!= 0){
            res.setScale(new BigDecimal(100).multiply(bb.divide(beforeChangeTaxMny,8,ROUND_HALF_DOWN)));
        }else {
            res.setScale(BigDecimal.ZERO);
        }
        res.setBb(bb);
        return CommonResponse.success(res);
    }

    @Override
    public RentChangeVO queryDetail(Long id) {
        RentChangeEntity entity = super.selectById(id);
        RentChangeVO rentChangeVo = BeanMapper.map(entity, RentChangeVO.class);
        BigDecimal contractTaxMny = rentChangeVo.getContractTaxMny()==null?BigDecimal.ZERO:rentChangeVo.getContractTaxMny();
        BigDecimal beforeChangeTaxMny = rentChangeVo.getBeforeChangeTaxMny()==null?BigDecimal.ZERO:rentChangeVo.getBeforeChangeTaxMny();
        BigDecimal bb = contractTaxMny.subtract(beforeChangeTaxMny);
        if(beforeChangeTaxMny.compareTo(BigDecimal.ZERO) != 0){
            rentChangeVo.setScale(new BigDecimal(100).multiply(bb.divide(beforeChangeTaxMny,8,ROUND_HALF_DOWN)));
        }else {
            rentChangeVo.setScale(BigDecimal.ZERO);
        }
        rentChangeVo.setBb(bb);
        return rentChangeVo;
    }

    @Override
    public RentChangeVO queryDetails(Long id) {
        RentContractEntity entity = rentContractService.selectById(id);
        RentChangeVO rentChangeVo = BeanMapper.map(entity, RentChangeVO.class);
        //新增逻辑处理
        rentChangeVo.setContractId(rentChangeVo.getId());
        //新增即点变更按钮穿透过来，此时ID为合同id
        rentChangeVo.setId(null);
        rentChangeVo.setBillState(null);
        rentChangeVo.setCreateUserCode(null);
        rentChangeVo.setCreateTime(null);
        rentChangeVo.setUpdateUserCode(null);
        rentChangeVo.setUpdateTime(null);
        rentChangeVo.setChangeDate(new Date());
        rentChangeVo.setBeforeContractName(entity.getContractName());
        rentChangeVo.setBeforeChangeMny(entity.getContractMny());
        rentChangeVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
        rentChangeVo.setBeforeContractName(rentChangeVo.getContractName());

        List<RentContractDetailEntity> details = null;
        LambdaQueryWrapper<RentContractDetailEntity> lambda = Wrappers.<RentContractDetailEntity>lambdaQuery();
        lambda.eq(RentContractDetailEntity::getContractId,id);
        lambda.ne(RentContractDetailEntity::getChangeType,"3");
        details = rentContractDetailService.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            rentChangeVo.setRentdetail(BeanMapper.mapList(details,RentChangeDetailVO.class));
            rentChangeVo.getRentdetail().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setContractId(rentChangeVo.getContractId());
                vo.setChangeType("4");
                vo.setRowState("add");
//                vo.setId(null);
            });
        }else{
            rentChangeVo.setRentdetail(null);
        }
        if(CollectionUtils.isNotEmpty(rentChangeVo.getRentfee())){
            rentChangeVo.getRentfee().forEach(vo -> {
                vo.setContractId(rentChangeVo.getContractId());
                vo.setRowState("add");
//                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(rentChangeVo.getRentclause())){
            rentChangeVo.getRentclause().forEach(vo -> {
                vo.setContractId(rentChangeVo.getContractId());
                vo.setRowState("add");
//                vo.setId(null);
            });
        }
        return rentChangeVo;
    }

    @Override
    public RentChangeRecordVO queryChangeRecord(Long id) {
        RentChangeRecordVO vo = new RentChangeRecordVO();
        RentContractEntity entity = rentContractService.selectById(id);
        BigDecimal baseTaxMoney = entity.getBaseTaxMoney()==null?BigDecimal.ZERO:entity.getBaseTaxMoney();
        BigDecimal contractTaxMny = entity.getContractTaxMny()==null?BigDecimal.ZERO:entity.getContractTaxMny();
        vo.setBaseTaxMoney(baseTaxMoney);
        vo.setContractId(id);
        vo.setContractTaxMny(contractTaxMny);
        vo.setSumChangeMny(contractTaxMny.subtract(baseTaxMoney));
        vo.setContractStatus(entity.getContractStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        if(vo.getSumChangeMny().compareTo(BigDecimal.ZERO)!=0&&baseTaxMoney.compareTo(BigDecimal.ZERO)!=0){
            vo.setSumScale(new BigDecimal(100).multiply(vo.getSumChangeMny().divide(baseTaxMoney,8,ROUND_HALF_DOWN)));
        }else{
            vo.setSumScale(BigDecimal.ZERO);
        }

        if(entity.getChangeVersion()>0){
            //合同版本号>0说明会有变更记录
            LambdaQueryWrapper<RentChangeEntity> lambda = Wrappers.<RentChangeEntity>lambdaQuery();
            lambda.eq(RentChangeEntity::getContractId,id);
            lambda.in(RentChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
            lambda.orderByDesc(RentChangeEntity::getChangeTime);
            List<RentChangeEntity> entities = super.list(lambda);
//            entities.forEach(changevo -> {
//                if(changevo.getChangeVersion()<10){
//                    changevo.setBillCode(changevo.getBillCode()+"-0"+changevo.getChangeVersion());
//                }else{
//                    changevo.setBillCode(changevo.getBillCode()+"-"+changevo.getChangeVersion());
//                }
//              }
//            );
            vo.setChangeRecord(BeanMapper.mapList(entities, RentChangeVO.class));
        }
        return vo;
    }

    @Override
    public void deleteRentChange(List<RentChangeVO> vos) {
        RentChangeVO rentChangeVo = vos.get(0);
        RentChangeEntity entity = super.selectById(rentChangeVo.getId());
        //合同变更只有详情页有删除
        RentContractEntity pcentity = rentContractService.selectById(entity.getContractId());
        //会写合同表
        pcentity.setId(entity.getContractId());
        pcentity.setChangeVersion(pcentity.getChangeVersion()-1);
        pcentity.setChangeStatus(1);
        pcentity.setChangingMny(BigDecimal.ZERO);//修改变更中金额
        pcentity.setChangingTaxMny(BigDecimal.ZERO);
        pcentity.setChangeCode(null);
        pcentity.setChangeId(null);
        rentContractService.update(pcentity, new QueryWrapper<RentContractEntity>().eq("id",pcentity.getId()),false);
        super.removeByIds(vos.stream().map(RentChangeVO::getId).collect(Collectors.toList()),false);
    }

    @Override
    public BigDecimal totalContractMny(RentChangeVO vo){
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        QueryWrapper<RentContractEntity> rentQuery = new QueryWrapper<>();
        rentQuery.eq("project_Id", vo.getProjectId());
//        rentQuery.in("change_status",Arrays.asList(1,3));
//        rentQuery.in("bill_state", Arrays.asList(
//                BillStateEnum.COMMITED_STATE.getBillStateCode(),
//                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
//                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
//                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),
//                BillStateEnum.PASSED_STATE.getBillStateCode()));
        rentQuery.eq("contract_status",2);
        if (vo.getContractId()!=null){
            rentQuery.ne("id",vo.getContractId());
        }
        rentQuery.select("sum(contract_tax_mny) as contractTaxMny");
        RentContractEntity rentContract = rentContractService.getOne(rentQuery);
        if(rentContract!=null &&null != rentContract.getContractTaxMny()&&!"0".equals(rentContract.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(rentContract.getContractTaxMny());
        }
        //统计变更中的金额
        QueryWrapper<RentChangeEntity> changeQuery = new QueryWrapper<>();
        changeQuery.eq("project_Id", vo.getProjectId());
        changeQuery.in("bill_state", Arrays.asList(
                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        if (vo.getId()!=null){
            changeQuery.ne("id",vo.getId());
        }
        if (vo.getContractTaxMny()!=null){
            contractTaxMny =contractTaxMny.add(vo.getContractTaxMny());
        }
        changeQuery.select("sum(contract_tax_mny) as contractTaxMny");
        RentChangeEntity changeEntity = super.getOne(changeQuery);
        if(changeEntity!=null &&null != changeEntity.getContractTaxMny()&&!"0".equals(changeEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(changeEntity.getContractTaxMny());
        }
        return  contractTaxMny;
    }

    /**
     * 参数控制
     *
     * @param vo 预算机械费总金额  设备租赁总金额
     *
     * @return {@link ParamsCheckVO}
     */
    @Override
    public ParamsCheckVO checkParams(RentChangeVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        //获取 预算机械费总金额
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType());
        CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(requestVo);
        logger.info("预算机械费总金额 返回内容:{}", JSONObject.toJSONString(res));
        if (!res.isSuccess()){
            throw new BusinessException("网络错误"+res.getMsg());
        }
        // 没有预算不控制，预算不包含不控制
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO data = res.getData();
            //预算机械费总金额
            BigDecimal budgetTaxMny =  data.getMechanicalTaxMny()==null ? BigDecimal.ZERO : data.getMechanicalTaxMny();
            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, curOrgId);
            if (!response.isSuccess()) {
                throw new BusinessException("【预算机械费总金额】控 【设备合同总金额】，获取控制参数失败，失败原因：" + response.getMsg());
            }
            //设备采购总金额
            BigDecimal  rentContractTaxMny= totalContractMny(vo);
            //设备租赁总金额
            PurchaseContractVO purchaseContract = new PurchaseContractVO();
            purchaseContract.setProjectId(vo.getProjectId());
            BigDecimal purchaseContractTaxMny = purchaseContractService.totalContractMny(purchaseContract);
            BigDecimal totalContractMny = purchaseContractTaxMny.add(rentContractTaxMny);
            List<BillParamVO> billParamVOS = response.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                        // 设备合同总金额 和 预算机械费总金额
                        if (totalContractMny.compareTo(budgetTaxMnyResult) > 0) {
                            // 超出金额 = 设备合同总金额 - 预算机械费总金额 * X%
                            BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            //设备合同总金额：{}元，预算机械费总金额
                            paramsCheckDsVO.setWarnItem("设备合同总金额超预算机械费总金额");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnName("设备合同总金额大于预算机械费总金额 * " + roleValue + "%");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("设备合同总金额：")
                                    .append(totalContractMny.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，预算机械费总金额 * ")
                                    .append(roleValue).append("%：")
                                    .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，超出金额：")
                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                    .append("元。");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }

                }
            }
        }

        // 施工合同金额控制支出
        CommonResponse<List<BillParamVO>> sghtkzc = paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, curOrgId);
        if (sghtkzc.isSuccess() && null != sghtkzc.getData()) {
            List<BillParamVO> billParamVOS = sghtkzc.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                BigDecimal sjzcje = this.getSjzcje(vo.getId(), vo.getContractId(), vo.getProjectId(), vo.getContractTaxMny());
                CommonResponse<BigDecimal> res996 = incomeContractApi.fetchSghtzje(vo.getProjectId());
                if (!res996.isSuccess()) {
                    throw new BusinessException("获取施工合同工总金额失败");
                }
                BigDecimal sght = res996.getData();
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = NumberUtil.div(roleValue, new BigDecimal("100"), 8);
                        BigDecimal sghtzje = NumberUtil.mul(sght, scale);
                        if (sjzcje.compareTo(sghtzje) > 0) {
//                            controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("该项目实际支出总金额：")
                                    .append(sjzcje.setScale(2, RoundingMode.HALF_UP))
                                    .append("，施工合同工总金额*")
                                    .append(roleValue)
                                    .append("%：")
                                    .append(sghtzje.setScale(2, RoundingMode.HALF_UP))
                                    .append("，超出金额：")
                                    .append(com.ejianc.framework.core.util.ComputeUtil.safeSub(sjzcje, sghtzje).setScale(2, RoundingMode.HALF_UP));
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem("实际支出总金额超施工合同总金额");
                            paramsCheckDsVO.setWarnName("实际支出总金额大于施工合同总金额");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
//                            checkDsVOS.add(paramsCheckDsVO);
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
        }

        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }

    private BigDecimal getSjzcje(Long changeId, Long contractId, Long projectId, BigDecimal mny) {
        CommonResponse<BigDecimal> fbCommonResponse = subContractApi.fetchSjzcje(projectId);
        if (!fbCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "分包" + "实际支出金额失败");
        }
        BigDecimal fb = fbCommonResponse.getData();
        CommonResponse<BigDecimal> wzCommonResponse = materialContractApi.fetchSjzcje(projectId);
        if (!wzCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "物资" + "实际支出金额失败");
        }
        BigDecimal wz = wzCommonResponse.getData();
        CommonResponse<BigDecimal> zzcCommonResponse = rmatContractApi.fetchSjzcje(projectId);
        if (!zzcCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "周转材" + "实际支出金额失败");
        }
        BigDecimal zzc = zzcCommonResponse.getData();
        BigDecimal sbcg = purchaseContractMapper.fetchSjzcje(projectId, null, null);
        BigDecimal sbzl = rentContractMapper.fetchSjzcje(projectId, changeId, contractId);
        CommonResponse<BigDecimal> qtCommonResponse = otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "其他" + "实际支出金额失败");
        }
        BigDecimal qt = qtCommonResponse.getData();
        CommonResponse<BigDecimal> fybxCommonResponse = financePayReimburseApi.fetchSjzcje(projectId);
        if (!fybxCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "费用报销" + "实际支出金额失败");
        }
        BigDecimal fybx = fybxCommonResponse.getData();
        CommonResponse<BigDecimal> lxCommonResponse = financePaySporadicApi.fetchSjzcje(projectId);
        if (!lxCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "零星" + "实际支出金额失败");
        }
        BigDecimal lx = lxCommonResponse.getData();
        CommonResponse<BigDecimal> yjCommonResponse = financeLoadReimburseApi.fetchSjzcje(projectId);
        if (!yjCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "备用金" + "实际支出金额失败");
        }
        BigDecimal yj = yjCommonResponse.getData();
        return NumberUtil.add(mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj);
    }

    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
}
