package com.ejianc.business.equipment.service.impl;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.equipment.bean.*;
import com.ejianc.business.equipment.mapper.RentSettlementMapper;
import com.ejianc.business.equipment.service.*;
import com.ejianc.business.equipment.vo.ParamsCheckDsVO;
import com.ejianc.business.equipment.vo.ParamsCheckVO;
import com.ejianc.business.equipment.vo.RentSettlementRecordVO;
import com.ejianc.business.equipment.vo.RentSettlementVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

/**
 * <p>
 * 设备合同结算表 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-10
 */
@Service("RentSettlementService")
public class RentSettlementServiceImpl extends BaseServiceImpl<RentSettlementMapper, RentSettlementEntity> implements IRentSettlementService {
    private static final String RENT_SETTLEMENT_BILL_CODE = "EQUIPMENT_RENT_SETTLEMENT";
    private static final String EQUIPMENT_RENT_SETTLE = "EQUIPMENT_RENT_SETTLE";
    private static final String EQUIPMENT_RENT_SETTLE_DETAIL = "EQUIPMENT_RENT_SETTLE_DETAIL";
    private static final String EQUIPMENT_RENT_SETTLE_FEE = "EQUIPMENT_RENT_SETTLE_FEE";
    private final Logger logger = LoggerFactory.getLogger(getClass());
    private static final String CHECK_PARAM_CODE = "P-5kO0W220";
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private IRentContractDetailService rentContractDetailService;
    @Autowired
    private IRentSettlementDetailService rentSettlementDetailService;
    @Autowired
    private IRentSettlementFeeService rentSettlementFeeService;
    @Autowired
    private IRentUseRecordService rentUseRecordService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IInvoiceApi invoiceApi;


    @Override
    public CommonResponse<RentSettlementVO> saveOrUpdate(RentSettlementVO rentSettlementVo) {
        //保存时校验合同version是否一致
        if (rentSettlementVo.getContractVersion() != null && rentSettlementVo.getContractVersion() != 0) {
            Jedis jedis = jedisPool.getResource();
            boolean locked = false;
            try {
                locked = RedisTool.tryLock(jedis, String.valueOf(rentSettlementVo.getContractId()), "saveOrUpdate", 1000);
                logger.info("判断单据单据锁结果------" + locked);
                if (locked) {
                    RentContractEntity contractEntity = rentContractService.selectById(rentSettlementVo.getContractId());
                    Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                    Integer conVersion = rentSettlementVo.getContractVersion();
                    if (!version.equals(conVersion)) {
                        return CommonResponse.error("该合同已被更新，请刷新后重做！");
                    }
                } else {
                    return CommonResponse.error("出现并发操作,请稍后重试！");
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                if (locked) {
                    RedisTool.releaseLock(jedis, String.valueOf(rentSettlementVo.getContractId()), "saveOrUpdate");
                }
                jedis.close();
            }

        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentSettlementEntity entity = null;
        //合同只能存在一条未生效的
        LambdaQueryWrapper<RentSettlementEntity> lambdachange = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambdachange.eq(RentSettlementEntity::getTenantId, tenantId);
        lambdachange.eq(RentSettlementEntity::getContractId, rentSettlementVo.getContractId());
        lambdachange.eq(RentSettlementEntity::getOrgId, rentSettlementVo.getOrgId());
        if (null != rentSettlementVo.getId() && rentSettlementVo.getId() > 0) {
            lambdachange.ne(RentSettlementEntity::getId, rentSettlementVo.getId());
        }
        lambdachange.ne(RentSettlementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(RentSettlementEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if (num > 0) {
            throw new BusinessException("该合同该组织下已存在未生效的结算单!");
        }

        LambdaQueryWrapper<RentSettlementEntity> lambdachange2 = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambdachange2.eq(RentSettlementEntity::getTenantId, tenantId);
        lambdachange2.eq(RentSettlementEntity::getContractId, rentSettlementVo.getContractId());
        lambdachange2.eq(RentSettlementEntity::getOrgId, rentSettlementVo.getOrgId());
        if (null != rentSettlementVo.getId() && rentSettlementVo.getId() > 0) {
            lambdachange2.ne(RentSettlementEntity::getId, rentSettlementVo.getId());
        }
        lambdachange2.in(RentSettlementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambdachange2.gt(RentSettlementEntity::getSettlementDate, rentSettlementVo.getSettlementDate());
        int num2 = super.count(lambdachange2);
        if (num2 > 0) {
            throw new BusinessException("结算日期必须大于等于该合同对应最新结算日期!");
        }
        BigDecimal settlementTaxMny = rentSettlementVo.getSettlementTaxMny() == null ? BigDecimal.ZERO : rentSettlementVo.getSettlementTaxMny();
        BigDecimal offsetMny = rentSettlementVo.getOffsetMny() == null ? BigDecimal.ZERO : rentSettlementVo.getOffsetMny();//本次冲抵金额
        BigDecimal syMny = rentSettlementVo.getSymny() == null ? BigDecimal.ZERO : rentSettlementVo.getSymny();//剩余冲抵金额
        if (offsetMny.compareTo(syMny) > 0) {
            throw new BusinessException("本次冲抵金额不允许大于剩余可冲抵金额!");
        }
        if (offsetMny.compareTo(settlementTaxMny) > 0 && settlementTaxMny.compareTo(BigDecimal.ZERO) >= 0) {
            throw new BusinessException("本次冲抵金额不允许大于本期结算金额");
        }
        if (StringUtils.isEmpty(rentSettlementVo.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RENT_SETTLEMENT_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                rentSettlementVo.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //设备使用记录引用标识修改
        LambdaQueryWrapper<RentSettlementDetailEntity> queryWrapperDetail = Wrappers.<RentSettlementDetailEntity>lambdaQuery();
        queryWrapperDetail.eq(RentSettlementDetailEntity::getSettlementId, rentSettlementVo.getId());
        List<RentSettlementDetailEntity> detailList = rentSettlementDetailService.list(queryWrapperDetail);
        List<Long> useOldIdList = new ArrayList<>();
        if (detailList != null && detailList.size() > 0) {
            for (RentSettlementDetailEntity rentSettlementDetailEntity : detailList) {
                if (rentSettlementDetailEntity.getSource() == 3) {
                    useOldIdList.add(rentSettlementDetailEntity.getUseId());
                }
            }
            if (useOldIdList != null && useOldIdList.size() > 0) {
                LambdaUpdateWrapper<RentUseRecordEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.in(RentUseRecordEntity::getId, useOldIdList);
                updateWrapper.set(RentUseRecordEntity::getUseFlag, 0);//(1:是，0：否)
                boolean flag = rentUseRecordService.update(updateWrapper);
            }
        }

        //成本改造
        //设置是否关联
        rentSettlementVo.setRelationFlag("0");
        rentSettlementVo.setProportionFlag("0");
        entity = BeanMapper.map(rentSettlementVo, RentSettlementEntity.class);

        //获取已收票金额
        CommonResponse<BigDecimal> invoiceReceiceMnyRes = invoiceApi.getInvoiceReceiceMny(entity.getContractId(), entity.getOrgId());
        if(invoiceReceiceMnyRes.isSuccess()){
            entity.setSumInvoiceTaxMny(ComputeUtil.nullToZero(invoiceReceiceMnyRes.getData()));
        }
        super.saveOrUpdate(entity, false);

        List<RentSettlementDetailEntity> rentdetail = entity.getRentdetail();
        if (rentdetail != null && rentdetail.size() > 0) {
            List<Long> useIds = new ArrayList<Long>();
            for (RentSettlementDetailEntity rentSettlementDetailEntity : rentdetail) {
                if (rentSettlementDetailEntity.getSource() == 3) {
                    useIds.add(rentSettlementDetailEntity.getUseId());
                }

            }
            //更新设备使用记录-为已引用,
            if (useIds != null && useIds.size() > 0) {
                LambdaUpdateWrapper<RentUseRecordEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.in(RentUseRecordEntity::getId, useIds);
                updateWrapper.set(RentUseRecordEntity::getUseFlag, 1);//(1:是，0：否)
                boolean flag = rentUseRecordService.update(updateWrapper);
            }
        }

        RentSettlementVO vo = BeanMapper.map(entity, RentSettlementVO.class);
        BigDecimal c = rentSettlementVo.getContractTaxMny() == null ? BigDecimal.ZERO : rentSettlementVo.getContractTaxMny();
        BigDecimal cc = rentSettlementVo.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : rentSettlementVo.getSumSettlementTaxMny();
        if (c.compareTo(BigDecimal.ZERO) > 0 && cc.compareTo(BigDecimal.ZERO) > 0) {
            vo.setLjjsbl(new BigDecimal(100).multiply(cc.divide(c, 8, ROUND_HALF_DOWN)));
        }
        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        BigDecimal sumPrePayMny = entity.getSumPrepayMny() == null ? BigDecimal.ZERO : entity.getSumPrepayMny();
        BigDecimal sumOffsetMny = entity.getSumOffsetMny() == null ? BigDecimal.ZERO : entity.getSumOffsetMny();
        vo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        return CommonResponse.success(vo);
    }

    @Override
    public RentSettlementVO queryDetail(Long id) {
        RentSettlementEntity entity = super.selectById(id);
        RentSettlementVO rentSettlementVo = BeanMapper.map(entity, RentSettlementVO.class);
        BigDecimal c = rentSettlementVo.getContractTaxMny() == null ? BigDecimal.ZERO : rentSettlementVo.getContractTaxMny();
        BigDecimal cc = rentSettlementVo.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : rentSettlementVo.getSumSettlementTaxMny();
        if (c.compareTo(BigDecimal.ZERO) > 0 && cc.compareTo(BigDecimal.ZERO) > 0) {
            rentSettlementVo.setSumSettleRate(new BigDecimal(100).multiply(cc.divide(c, 8, ROUND_HALF_DOWN)));
        }
        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        BigDecimal sumPrePayMny = entity.getSumPrepayMny() == null ? BigDecimal.ZERO : entity.getSumPrepayMny();
        BigDecimal sumOffsetMny = entity.getSumOffsetMny() == null ? BigDecimal.ZERO : entity.getSumOffsetMny();
        rentSettlementVo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        return rentSettlementVo;
    }

    @Override
    public RentSettlementVO queryDetails(Long id) {
        RentContractEntity entity = rentContractService.selectById(id);
        RentSettlementVO rentSettlementVO = BeanMapper.map(entity, RentSettlementVO.class);
        //新增逻辑处理
        rentSettlementVO.setContractId(rentSettlementVO.getId());
        //新增即点变更按钮穿透过来，此时ID为合同id
        rentSettlementVO.setId(null);
        rentSettlementVO.setBillCode(null);
        rentSettlementVO.setBillState(null);
        rentSettlementVO.setCreateUserCode(null);
        rentSettlementVO.setCreateTime(null);
        rentSettlementVO.setSettlementDate(new Date());
        rentSettlementVO.setUpdateUserCode(null);
        rentSettlementVO.setUpdateTime(null);
        rentSettlementVO.setRentdetail(null);
        rentSettlementVO.setRentfee(null);
        rentSettlementVO.setMemo(null);
        rentSettlementVO.setTaxMny(BigDecimal.ZERO);
        rentSettlementVO.setEmployeeId(UserContext.getUserContext().getEmployeeId());
        rentSettlementVO.setEmployeeName(UserContext.getUserContext().getUserName());
        rentSettlementVO.setSettlementType("0");
        rentSettlementVO.setSumInvoiceTaxMny(null);

        CommonResponse<SumPayMnyVO> sumPayMnyVO = payContractApi.getSumPayMny(id, entity.getOrgId());
        if (!sumPayMnyVO.isSuccess()) {
            throw new BusinessException("获取付款信息失败，请刷新后再试！");
        }
        BigDecimal sumPayMny = sumPayMnyVO.getData().getSumPayMny();
        BigDecimal sumPrePayMny = sumPayMnyVO.getData().getSumPrePayMny();
        rentSettlementVO.setSumPayMny(sumPayMny == null ? BigDecimal.ZERO : sumPayMny);
        rentSettlementVO.setSumPrepayMny(sumPrePayMny == null ? BigDecimal.ZERO : sumPrePayMny);
        LambdaQueryWrapper<RentSettlementEntity> lambdachange = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambdachange.eq(RentSettlementEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdachange.eq(RentSettlementEntity::getContractId, id);
        lambdachange.eq(RentSettlementEntity::getOrgId, entity.getOrgId());
        lambdachange.in(RentSettlementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<RentSettlementEntity> list = super.list(lambdachange);
        if (CollectionUtils.isNotEmpty(list)) {
            final BigDecimal[] settlementMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP), new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            list.forEach(e -> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettlementTaxMny() == null ? BigDecimal.ZERO : e.getSettlementTaxMny());
                settlementMoney[1] = settlementMoney[1].add(e.getOffsetMny() == null ? BigDecimal.ZERO : e.getOffsetMny());
            });
            //累计结算金额
            rentSettlementVO.setSumSettlementTaxMny(settlementMoney[0]);
            //累计冲抵金额
            rentSettlementVO.setSumOffsetMny(settlementMoney[1]);
        }else {
            //累计结算金额
            rentSettlementVO.setSumSettlementTaxMny(BigDecimal.ZERO);
            //累计冲抵金额
            rentSettlementVO.setSumOffsetMny(BigDecimal.ZERO);
        }
        BigDecimal sumOffsetMnys = rentSettlementVO.getSumOffsetMny() == null ? BigDecimal.ZERO : rentSettlementVO.getSumOffsetMny();
        if (rentSettlementVO.getSumPrepayMny().compareTo(BigDecimal.ZERO) >= 0 && sumOffsetMnys.compareTo(BigDecimal.ZERO) >= 0) {
            rentSettlementVO.setSymny(rentSettlementVO.getSumPrepayMny().subtract(sumOffsetMnys));
        }

        BigDecimal c = rentSettlementVO.getContractTaxMny() == null ? BigDecimal.ZERO : rentSettlementVO.getContractTaxMny();
        BigDecimal cc = rentSettlementVO.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : rentSettlementVO.getSumSettlementTaxMny();
        if (c.compareTo(BigDecimal.ZERO) > 0 && cc.compareTo(BigDecimal.ZERO) > 0) {
            rentSettlementVO.setSumSettleRate(new BigDecimal(100).multiply(cc.divide(c, 8, ROUND_HALF_DOWN)));
        }
        return rentSettlementVO;
    }

    @Override
    public void deleteRentSettlement(List<RentSettlementVO> vos) {
        //获取删除的主键
        List<Long> ids = new ArrayList<Long>();
        for (RentSettlementVO rentSettlementVO : vos) {
            ids.add(rentSettlementVO.getId());
        }
        if (ids != null && ids.size() > 0) {
            LambdaQueryWrapper<RentSettlementDetailEntity> lambda = Wrappers.<RentSettlementDetailEntity>lambdaQuery();
            lambda.in(RentSettlementDetailEntity::getSettlementId, ids);
            List<RentSettlementDetailEntity> rentSettlementDetailEntities = rentSettlementDetailService.list(lambda);
            if (rentSettlementDetailEntities != null && rentSettlementDetailEntities.size() > 0) {
                List<Long> useIds = new ArrayList<Long>();
                for (RentSettlementDetailEntity rentSettlementDetailEntity : rentSettlementDetailEntities) {
                    if (rentSettlementDetailEntity.getSource() == 3) {
                        useIds.add(rentSettlementDetailEntity.getUseId());
                    }
                }
                if (useIds != null && useIds.size() > 0) {
                    LambdaUpdateWrapper<RentUseRecordEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.in(RentUseRecordEntity::getId, useIds);
                    updateWrapper.set(RentUseRecordEntity::getUseFlag, 0);//(1:是，0：否)
                    boolean flag = rentUseRecordService.update(updateWrapper);
                }

            }
        }
        super.removeByIds(vos.stream().map(RentSettlementVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public CommonResponse<RentSettlementVO> pushCost(RentSettlementVO rentSettlementVo) {
        RentSettlementEntity rentSettlementEntity = baseMapper.selectById(rentSettlementVo.getId());
        if (ListUtil.isNotEmpty(rentSettlementVo.getRentdetail())) {
            List<RentSettlementDetailEntity> rentSettleDetail = BeanMapper.mapList(rentSettlementVo.getRentdetail(), RentSettlementDetailEntity.class);
            rentSettlementEntity.setRentdetail(rentSettleDetail);
        }
        if (ListUtil.isNotEmpty(rentSettlementVo.getRentfee())) {
            List<RentSettlementFeeEntity> rentSettleFee = BeanMapper.mapList(rentSettlementVo.getRentfee(), RentSettlementFeeEntity.class);
            rentSettlementEntity.setRentfee(rentSettleFee);
        }
        super.saveOrUpdate(rentSettlementEntity, false);
        //推送数据
        costPush(rentSettlementEntity);
        return CommonResponse.success(BeanMapper.map(rentSettlementEntity, RentSettlementVO.class));
    }

    @Override
    public void pullCost(Long id) {
        ////更新关联状态为未关联
        LambdaUpdateWrapper<RentSettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(RentSettlementEntity::getId, id);
        updateWrapper.set(RentSettlementEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
        //删除成本中心数据
        costDetailApi.deleteSubject(id);
    }

    @Override
    public RentSettlementRecordVO querySettlementRecord(Long id) {
        RentSettlementRecordVO vo = new RentSettlementRecordVO();
        RentContractEntity entity = rentContractService.selectById(id);
        BigDecimal contractTaxMny = entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny();//合同金额
        vo.setContractTaxMny(contractTaxMny);
        vo.setContractId(id);
        vo.setContractStatus(entity.getContractStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        LambdaQueryWrapper<RentSettlementEntity> lambda = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambda.eq(RentSettlementEntity::getContractId, id);
        lambda.in(RentSettlementEntity::getOrgId, commonOrgIds);
        lambda.orderByDesc(RentSettlementEntity::getCreateTime);
        List<RentSettlementEntity> entitiesAllState = super.list(lambda);
        lambda.in(RentSettlementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<RentSettlementEntity> entities = super.list(lambda);
        if (CollectionUtils.isNotEmpty(entities)) {
            final BigDecimal[] settlementMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            entities.forEach(e -> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettlementTaxMny() == null ? BigDecimal.ZERO : e.getSettlementTaxMny());
            });
            //累计结算金额
            vo.setSumSettlementTaxMny(settlementMoney[0]);
            BigDecimal sumSettlementTaxMny = vo.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : vo.getSumSettlementTaxMny();//累计结算金额
            if (sumSettlementTaxMny.compareTo(BigDecimal.ZERO) != 0 && contractTaxMny.compareTo(BigDecimal.ZERO) > 0) {
                vo.setSumScale(new BigDecimal(100).multiply(sumSettlementTaxMny.divide(contractTaxMny, 8, ROUND_HALF_DOWN)));
            } else {
                vo.setSumScale(BigDecimal.ZERO);
            }
        }
        vo.setSettlementRecord(BeanMapper.mapList(entitiesAllState, RentSettlementVO.class));
        return vo;
    }

    @Override
    public void costPush(RentSettlementEntity settlementEntity) {
        logger.info("开始Push");
        //1.判断结算单所有子表是否全部关联科目
        List<RentSettlementDetailEntity> rentdetail = settlementEntity.getRentdetail();
        boolean newRelationFlag = true;
        //查询费用表是否全部关联费用科目
        List<RentSettlementFeeEntity> rentfee = settlementEntity.getRentfee();
//        if (ListUtil.isEmpty(rentdetail) && ListUtil.isEmpty(rentfee)) {
//            newRelationFlag = false;
//        }
        for (RentSettlementDetailEntity detailVO : rentdetail) {
            if (detailVO.getSubjectId() == null || detailVO.getSubjectId() <= 0) {
                newRelationFlag = false;
            }
        }
        for (RentSettlementFeeEntity otherVO : rentfee) {
            if (otherVO.getSubjectId() == null || otherVO.getSubjectId() <= 0) {
                newRelationFlag = false;
            }
        }

        //更新是否关联
        LambdaUpdateWrapper<RentSettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(RentSettlementEntity::getId, settlementEntity.getId());
        updateWrapper.set(RentSettlementEntity::getRelationFlag, newRelationFlag ? "1" : "0");//(1:是，0：否)
        super.update(updateWrapper);

        //判断之前的单据是否关联
        String oldRelationFlag = settlementEntity.getRelationFlag();
        //之前已关联
        if (oldRelationFlag.equals("1")) {
            if (newRelationFlag) {
                saveCost(settlementEntity);
            }
            if (!newRelationFlag) {
                //删除成本中心之前的数据
                costDetailApi.deleteSubject(settlementEntity.getId());
            }
        }
        //之前未关联
        if (oldRelationFlag.equals("0")) {
                //税率
            saveCost(settlementEntity);
        }
    }

    private void saveCost(RentSettlementEntity entity) {
        //税率
        BigDecimal taxRate = entity.getTaxRate().divide(new BigDecimal(100));
        BigDecimal number = taxRate.add(new BigDecimal(1));
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<RentSettlementDetailEntity> pushRentDetail = entity.getRentdetail();
        if (ListUtil.isNotEmpty(pushRentDetail)) {
            for (RentSettlementDetailEntity detail : pushRentDetail) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(detail.getSubjectId());
                costDetailVO.setSourceId(detail.getSettlementId());
                costDetailVO.setSourceDetailId(detail.getId());
                costDetailVO.setHappenTaxMny(detail.getSettlementMny());
                //无税值计算
                BigDecimal pushSettlementMny = detail.getSettlementMny();
                BigDecimal happenMny = pushSettlementMny.divide(number, 2, BigDecimal.ROUND_HALF_UP);
                costDetailVO.setHappenMny(happenMny);
                costDetailVO.setHappenDate(entity.getSettlementDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(EQUIPMENT_RENT_SETTLE);
                costDetailVO.setSourceTabType(EQUIPMENT_RENT_SETTLE_DETAIL);
                costDetailVO.setProjectId(entity.getProjectId());
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
                LocalDate settlementDate = entity.getSettlementDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

                costDetailVO.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
                costDetailVO.setCostTypeName(CostTypeEnum.MECHANICAL_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
                costDetailVO.setPeriod(settlementDate.format(df)); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
                costDetailVO.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
                // c.setShareId(); // 归集单据id 说明：不用传
                costDetailVO.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
                costDetailVO.setSourceBillName("设备租赁合同结算"); // 来源单据名称 说明：材料验收单
                costDetailVO.setSourceBillUrl("/ejc-equipment-frontend/#/rentSettlement?id=" + entity.getId()); // 来源单据url 说明：/ejc-promaterial-frontend/#/check/contractCard?id=585483774737809479
                costDetailVO.setNum(detail.getNum() == null ? BigDecimal.ZERO : detail.getNum()); // 发生数量 说明：子表有数量的都传，包含分包清单工程量

                // 以下信息物资、设备、周转材档案类传
                costDetailVO.setMaterialId(detail.getEquipmentId()); // 物资主键
                // c.setMaterialCode(sub.getMaterialCode()); // 物料编码
                costDetailVO.setMaterialName(detail.getName()); // 物资名称
//                costDetailVO.setMaterialTypeId(); // 物资类别
//                costDetailVO.setMaterialTypeName(); // 物资类别名称
                costDetailVO.setUnit(detail.getUnitName()); // 单位名称
                // c.setUnitId(); // 单位主键
//                costDetailVO.setSpec(); // 规格型号
                costDetailVOList.add(costDetailVO);

            }
        }
        //费用
        List<RentSettlementFeeEntity> pushRentFee = entity.getRentfee();
        if (ListUtil.isNotEmpty(pushRentFee)) {
            for (RentSettlementFeeEntity detail : pushRentFee) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(detail.getSubjectId());
                costDetailVO.setSourceId(detail.getSettlementId());
                costDetailVO.setSourceDetailId(detail.getId());
                costDetailVO.setHappenTaxMny(detail.getFeemoney());
                //无税值计算
                BigDecimal pushSettlementMny = detail.getFeemoney();
                BigDecimal happenMny = pushSettlementMny.divide(number, 2, BigDecimal.ROUND_HALF_UP);
                costDetailVO.setHappenMny(happenMny);
                costDetailVO.setHappenDate(entity.getSettlementDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(EQUIPMENT_RENT_SETTLE);
                costDetailVO.setSourceTabType(EQUIPMENT_RENT_SETTLE_FEE);
                costDetailVO.setProjectId(entity.getProjectId());
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
                LocalDate settlementDate = entity.getSettlementDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

                costDetailVO.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
                costDetailVO.setCostTypeName(CostTypeEnum.MECHANICAL_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
                costDetailVO.setPeriod(settlementDate.format(df)); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
                costDetailVO.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
                // c.setShareId(); // 归集单据id 说明：不用传
                costDetailVO.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
                costDetailVO.setSourceBillName("设备租赁合同结算"); // 来源单据名称 说明：材料验收单
                costDetailVO.setSourceBillUrl("/ejc-equipment-frontend/#/rentSettlement?id=" + entity.getId()); // 来源单据url 说明：/ejc-promaterial-frontend/#/check/contractCard?id=585483774737809479
//                costDetailVO.setNum(detail.getNum() == null ? BigDecimal.ZERO : detail.getNum()); // 发生数量 说明：子表有数量的都传，包含分包清单工程量
                // 以下信息物资、设备、周转材档案类传
//                costDetailVO.setMaterialId(detail.getSettlementId()); // 物资主键
                // c.setMaterialCode(sub.getMaterialCode()); // 物料编码
//                costDetailVO.setMaterialName(detail.getName()); // 物资名称
//                costDetailVO.setMaterialTypeId(); // 物资类别
//                costDetailVO.setMaterialTypeName(detail.getFeeType()); // 物资类别名称
//                costDetailVO.setUnit(detail.getUnitName()); // 单位名称
                // c.setUnitId(); // 单位主键
//                costDetailVO.setSpec(); // 规格型号
                costDetailVOList.add(costDetailVO);
//                costDetailVOList.add(costDetailVO);
            }
        }

        if (CollectionUtils.isEmpty(pushRentDetail) && CollectionUtils.isEmpty(pushRentFee)) {
            CostDetailVO costDetailVO = new CostDetailVO();
//            costDetailVO.setSubjectId(detail.getSubjectId());
            costDetailVO.setSourceId(entity.getId());
//            costDetailVO.setSourceDetailId(detail.getId());
            costDetailVO.setHappenTaxMny(entity.getSettlementTaxMny());
            //无税值计算
            BigDecimal pushSettlementMny = entity.getSettlementMny();
            BigDecimal happenMny = pushSettlementMny.divide(number, 2, BigDecimal.ROUND_HALF_UP);
            costDetailVO.setHappenMny(happenMny);
            costDetailVO.setHappenDate(entity.getSettlementDate());
            costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
            costDetailVO.setSourceType(EQUIPMENT_RENT_SETTLE);
//            costDetailVO.setSourceTabType(EQUIPMENT_RENT_SETTLE_FEE);
            costDetailVO.setProjectId(entity.getProjectId());
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
            LocalDate settlementDate = entity.getSettlementDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

            costDetailVO.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
            costDetailVO.setCostTypeName(CostTypeEnum.MECHANICAL_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
            costDetailVO.setPeriod(settlementDate.format(df)); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
            costDetailVO.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
            // c.setShareId(); // 归集单据id 说明：不用传
            costDetailVO.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
            costDetailVO.setSourceBillName("设备租赁合同结算"); // 来源单据名称 说明：材料验收单
            costDetailVO.setSourceBillUrl("/ejc-equipment-frontend/#/rentSettlement?id=" + entity.getId()); // 来源单据url 说明：/ejc-promaterial-frontend/#/check/contractCard?id=585483774737809479
//                costDetailVO.setNum(detail.getNum() == null ? BigDecimal.ZERO : detail.getNum()); // 发生数量 说明：子表有数量的都传，包含分包清单工程量
            // 以下信息物资、设备、周转材档案类传
//                costDetailVO.setMaterialId(detail.getSettlementId()); // 物资主键
            // c.setMaterialCode(sub.getMaterialCode()); // 物料编码
//                costDetailVO.setMaterialName(detail.getName()); // 物资名称
//                costDetailVO.setMaterialTypeId(); // 物资类别
//                costDetailVO.setMaterialTypeName(detail.getFeeType()); // 物资类别名称
//                costDetailVO.setUnit(detail.getUnitName()); // 单位名称
            // c.setUnitId(); // 单位主键
//                costDetailVO.setSpec(); // 规格型号
            costDetailVOList.add(costDetailVO);
//                costDetailVOList.add(costDetailVO);
        }
        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送成本数据:{}",JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            if (stringCommonResponse.isSuccess()) {
                logger.info("推送成本返回:{}",JSONObject.toJSONString(stringCommonResponse));

            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public ParamsCheckVO checkParams(BigDecimal sumPayMny, BigDecimal payMny, BigDecimal contractMny, Long projectId, Long orgId) {
        Long curOrgId = Optional.ofNullable(orgId).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        logger.info("sumPayMny:{},payMny:{},contractMny:{} ",
                JSONObject.toJSONString(sumPayMny),
                JSONObject.toJSONString(payMny),
                JSONObject.toJSONString(contractMny)
        );
        CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, curOrgId);
        if (!response.isSuccess()) {
            logger.info(response.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        List<BillParamVO> billParamVOS = response.getData();
        if (CollectionUtils.isNotEmpty(billParamVOS)) {
            for (BillParamVO billParamVO : billParamVOS) {
                if (0 != billParamVO.getControlType()) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal sumPayWithThisMny = sumPayMny.add(payMny);
                    BigDecimal comMny = contractMny.multiply(roleValue.divide(BigDecimal.valueOf(100)));
                    if (sumPayWithThisMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("合同超结");
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        paramsCheckDsVO.setWarnName("结算金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次结算金额：")
                                .append(payMny.toString()).append("元，含本次累计金额")
                                .append(sumPayWithThisMny.toString()).append("元,合同金额*")
                                .append(roleValue).append("%:").append(comMny).append("元。超出金额：")
                                .append(sumPayWithThisMny.subtract(comMny)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);

                    }
                }
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }
    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
}

