package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.bean.RentUseRecordDetailEntity;
import com.ejianc.business.equipment.bean.RentUseRecordEntity;
import com.ejianc.business.equipment.mapper.RentUseRecordMapper;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.service.IRentUseRecordDetailService;
import com.ejianc.business.equipment.service.IRentUseRecordService;
import com.ejianc.business.equipment.vo.ParamsCheckDsVO;
import com.ejianc.business.equipment.vo.ParamsCheckVO;
import com.ejianc.business.equipment.vo.RentUseRecordVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 租赁设备使用记录 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-11
 */
@Service("RentUseRecordService")
public class RentUseRecordServiceImpl extends BaseServiceImpl<RentUseRecordMapper, RentUseRecordEntity> implements IRentUseRecordService {
    private static final String RENT_USE_BILL_CODE = "EQUIPMENT_RENT_USE";
    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentUseRecordDetailService rentUseRecordDetailService;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IRentUseRecordService rentUseRecordService;
    @Autowired
    private IParamConfigApi paramConfigApi;

    private static final String PARAM_EQUIPMENT_RENT_USE_RECORD_COUNT = "P-84Y87h31";
    @Override
    public CommonResponse<RentUseRecordVO> saveOrUpdate(RentUseRecordVO rentUseRecordVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentUseRecordEntity entity = null;
        String operateType = null;
        if(StringUtils.isEmpty(rentUseRecordVo.getBillCode())){
        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RENT_USE_BILL_CODE,tenantId);
        if(billCode.isSuccess()) {
            rentUseRecordVo.setBillCode(billCode.getData());
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        }
        if(rentUseRecordVo.getId() != null && rentUseRecordVo.getId() > 0) {
        //修改  校验合同编号是否重复
        LambdaQueryWrapper<RentUseRecordEntity> lambda = Wrappers.<RentUseRecordEntity>lambdaQuery();
        lambda.eq(RentUseRecordEntity::getBillCode, rentUseRecordVo.getBillCode());
        lambda.eq(RentUseRecordEntity::getTenantId, tenantId);
        lambda.ne(RentUseRecordEntity::getId, rentUseRecordVo.getId());
        List<RentUseRecordEntity> entities = super.list(lambda);
        if(entities != null && entities.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
    }else{
        //校验合同编号是否重复
        LambdaQueryWrapper<RentUseRecordEntity> lambda = Wrappers.<RentUseRecordEntity>lambdaQuery();
        lambda.eq(RentUseRecordEntity::getTenantId, tenantId);
        lambda.eq(RentUseRecordEntity::getBillCode, rentUseRecordVo.getBillCode());
        List<RentUseRecordEntity> entities = super.list(lambda);
        if(entities != null && entities.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
    }
        entity = BeanMapper.map(rentUseRecordVo, RentUseRecordEntity.class);
        entity.setDr(0);
        List<RentUseRecordDetailEntity> entityRentdetail = entity.getRentdetail();
        String equipmentName = "";
        if(entityRentdetail != null && entityRentdetail.size() > 0){
            for(RentUseRecordDetailEntity rentUseRecordDetailEntity : entityRentdetail){
                equipmentName = equipmentName + rentUseRecordDetailEntity.getName() + ",";
            }
            String substring = equipmentName.substring(0, equipmentName.length() - 1);
            entity.setEquipmentName(substring);
        }
        entity.setUseFlag(0);
        entity.setSporadicUseFlag(0);
        super.saveOrUpdate(entity,false);

        return CommonResponse.success(BeanMapper.map(entity, RentUseRecordVO .class));
}

    @Override
    public RentUseRecordVO queryDetail(Long id) {
        RentUseRecordEntity entity = super.selectById(id);
        RentUseRecordVO rentUseRecordVo = new RentUseRecordVO();
        if(entity !=null){
            rentUseRecordVo = BeanMapper.map(entity, RentUseRecordVO.class);
        }
        return rentUseRecordVo;
    }

    @Override
    public void deleteRentUseRecord(List<RentUseRecordVO> vos) {
        super.removeByIds(vos.stream().map(RentUseRecordVO::getId).collect(Collectors.toList()),false);
    }

    @Override
    public RentUseRecordVO queryDetails(Long id) {
        RentContractEntity entity = rentContractService.selectById(id);
        RentUseRecordVO rentUseRecordVO = BeanMapper.map(entity, RentUseRecordVO.class);
        //新增逻辑处理
        rentUseRecordVO.setContractId(rentUseRecordVO.getId());
        //新增即点变更按钮穿透过来，此时ID为合同id
        rentUseRecordVO.setId(null);
        rentUseRecordVO.setBillCode(null);
        rentUseRecordVO.setBillState(null);
        rentUseRecordVO.setCreateUserCode(null);
        rentUseRecordVO.setCreateTime(null);
        rentUseRecordVO.setUpdateUserCode(null);
        rentUseRecordVO.setUpdateTime(null);
        rentUseRecordVO.setRentdetail(null);
        rentUseRecordVO.setRentfee(null);
        return rentUseRecordVO;
    }

    @Override
    public ParamsCheckVO checkContractUseMnyRatio(RentUseRecordVO rentUseRecordVo) {
        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<com.ejianc.business.equipment.vo.ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_EQUIPMENT_RENT_USE_RECORD_COUNT, InvocationInfoProxy.getOrgId());
        if (!response.isSuccess()) {
            logger.info(response.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        List<BillParamVO> billParamVOS = response.getData();
        if (CollectionUtils.isNotEmpty(billParamVOS)) {
            for (BillParamVO billParamVO : billParamVOS) {
                if (0 != billParamVO.getControlType()) {
                    // 比例
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal ratio = roleValue.divide(BigDecimal.valueOf(100));
                    QueryWrapper<RentUseRecordEntity> queryWrapper = new QueryWrapper<>();
                    queryWrapper.eq("contract_id",rentUseRecordVo.getContractId());
                    queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode()));
                    queryWrapper.select("IFNULL(SUM(use_mny),0) as lastContractUseMny");
                    RentUseRecordEntity one = rentUseRecordService.getOne(queryWrapper);
                    BigDecimal contractUseMny = ComputeUtil.safeAdd(rentUseRecordVo.getUseMny(), one.getLastContractUseMny());
                    //占比
                    BigDecimal contractUseMnyRatio = ComputeUtil.safeDiv(contractUseMny,rentUseRecordVo.getContractTaxMny());
                    //合同占比金额
                    BigDecimal contractRatiomny = ComputeUtil.safeMultiply(ratio, rentUseRecordVo.getContractTaxMny());
                    //超出的金额
                    BigDecimal exceMny = ComputeUtil.safeSub(contractUseMny, contractRatiomny);
                    if(contractUseMnyRatio.compareTo(ratio)>0){
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        paramsCheckDsVO.setWarnItem("设备使用超合同");
                        paramsCheckDsVO.setWarnName("累计设备使用金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次使用金额：").append(ComputeUtil.nullToZero(rentUseRecordVo.getUseMny()).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元，含本次累计使用金额：").append(contractUseMny.setScale(2, BigDecimal.ROUND_HALF_UP)).append("元，合同金额*").append(roleValue).append("%:").append(contractRatiomny.setScale(2, BigDecimal.ROUND_HALF_UP)).append("元。超出金额：").append(exceMny.setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                    }
                }
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }
    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

}
