package com.ejianc.business.equipment.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.equipment.bean.PurchaseChangeEntity;
import com.ejianc.business.equipment.bean.PurchaseContractDetailEntity;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.mapper.PurchaseChangeMapper;
import com.ejianc.business.equipment.mapper.PurchaseContractMapper;
import com.ejianc.business.equipment.mapper.RentContractMapper;
import com.ejianc.business.equipment.service.IPurchaseChangeService;
import com.ejianc.business.equipment.service.IPurchaseContractDetailService;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.vo.*;
import com.ejianc.business.finance.api.IFinanceLoadReimburseApi;
import com.ejianc.business.finance.api.IFinancePayReimburseApi;
import com.ejianc.business.finance.api.IFinancePaySporadicApi;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * <p>
 * 设备合同变更表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("PurchaseChangeService")
public class PurchaseChangeServiceImpl extends BaseServiceImpl<PurchaseChangeMapper, PurchaseChangeEntity> implements IPurchaseChangeService {

    private static final String PURCHASE_CHANGE_BILL_CODE = "EQUIPMENT_PURCHASE";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PARAM_TOTAL_MNY = "P-oIwZ5646"; // 【预算机械费总金额】控 【设备合同总金额】
    private static final String PARAM_BUDGE_MNY = "P-z3eQ6q89"; // 【项目预算总金额】控【项目总支出金额】
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPurchaseChangeService changeService;
    @Autowired
    private IPurchaseContractDetailService purchaseContractDetailService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private PurchaseContractMapper purchaseContractMapper;
    @Autowired
    private RentContractMapper rentContractMapper;
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IFinancePayReimburseApi financePayReimburseApi;
    @Autowired
    private IFinancePaySporadicApi financePaySporadicApi;
    @Autowired
    private IFinanceLoadReimburseApi financeLoadReimburseApi;
    @Override
    public CommonResponse<PurchaseChangeVO> saveOrUpdate(PurchaseChangeVO purchaseChangeVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseChangeEntity entity = null;
        List<PurchaseContractEntity> entitiesc = null;
        List<PurchaseChangeEntity> entities = null;


        //变更合同只能存在一条未生效的
        LambdaQueryWrapper<PurchaseChangeEntity> lambdachange = Wrappers.<PurchaseChangeEntity>lambdaQuery();
        lambdachange.eq(PurchaseChangeEntity::getTenantId, tenantId);
        lambdachange.eq(PurchaseChangeEntity::getContractId,purchaseChangeVo.getContractId());
        if(purchaseChangeVo.getId() != null && purchaseChangeVo.getId() > 0) {
            lambdachange.ne(PurchaseChangeEntity::getId,purchaseChangeVo.getId());
        }
        lambdachange.ne(PurchaseChangeEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(PurchaseChangeEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }

        PurchaseContractEntity pcentity = purchaseContractService.selectById(purchaseChangeVo.getContractId());
        if(StringUtils.isEmpty(purchaseChangeVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PURCHASE_CHANGE_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                purchaseChangeVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(purchaseChangeVo.getId() != null && purchaseChangeVo.getId() > 0 && changeService.getById(purchaseChangeVo.getId())!=null ) {
            //修改 校验合同编号唯一，变更单除去本单，采购合同  同时唯一
            LambdaQueryWrapper<PurchaseChangeEntity> lambda = Wrappers.<PurchaseChangeEntity>lambdaQuery();
            lambda.eq(PurchaseChangeEntity::getBillCode, purchaseChangeVo.getBillCode());
            lambda.eq(PurchaseChangeEntity::getTenantId, tenantId);
            lambda.ne(PurchaseChangeEntity::getContractId,purchaseChangeVo.getContractId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,purchaseChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE,purchaseChangeVo.getContractId()));
            entitiesc = purchaseContractService.queryList(queryParam,false);

            pcentity.setId(purchaseChangeVo.getContractId());

        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<PurchaseChangeEntity> lambda = Wrappers.<PurchaseChangeEntity>lambdaQuery();
            lambda.eq(PurchaseChangeEntity::getTenantId, tenantId);
            lambda.eq(PurchaseChangeEntity::getBillCode, purchaseChangeVo.getBillCode());
            lambda.ne(PurchaseChangeEntity::getContractId,purchaseChangeVo.getContractId());
            entities = super.list(lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,purchaseChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE,purchaseChangeVo.getContractId()));
            entitiesc = purchaseContractService.queryList(queryParam,false);
            //新增即点变更按钮穿透过来，此时ID为合同id
            pcentity.setId(purchaseChangeVo.getContractId());
            pcentity.setChangeVersion(purchaseChangeVo.getChangeVersion()+1);
            purchaseChangeVo.setChangeVersion(purchaseChangeVo.getChangeVersion()+1);
            purchaseChangeVo.setMakeTime(new Date());
        }

        if(CollectionUtils.isNotEmpty(purchaseChangeVo.getPurchasedetail())){
            purchaseChangeVo.getPurchasedetail().forEach(vo -> {
                //变更类型1-增补，2-变更，3-中止
                if("add".equals(vo.getRowState())){
//                        vo.setContractDetailId(vo.getId());
                    vo.setContractId(purchaseChangeVo.getContractId());
//                        vo.setChangeType(1);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(purchaseChangeVo.getPurchasefee())){
            purchaseChangeVo.getPurchasefee().forEach(vo -> {
                if("add".equals(vo.getRowState())){
                    vo.setContractId(purchaseChangeVo.getContractId());
                }
            });
        }
        if(CollectionUtils.isNotEmpty(purchaseChangeVo.getPurchaseclause())){
            purchaseChangeVo.getPurchaseclause().forEach(vo -> {
                if("add".equals(vo.getRowState())){
                    vo.setContractId(purchaseChangeVo.getContractId());
                }
            });
        }
        if(CollectionUtils.isNotEmpty(entities) || CollectionUtils.isNotEmpty(entitiesc)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity = BeanMapper.map(purchaseChangeVo, PurchaseChangeEntity.class);
        super.saveOrUpdate(entity,false);
        //会写合同表
        pcentity.setChangeStatus(2);
        pcentity.setChangingMny(entity.getContractMny());//修改变更中金额
        pcentity.setChangingTaxMny(entity.getContractTaxMny());
        pcentity.setChangeCode(entity.getBillCode());
        pcentity.setChangeId(entity.getId());
        purchaseContractService.update(pcentity, new QueryWrapper<PurchaseContractEntity>().eq("id",pcentity.getId()),false);
        PurchaseChangeVO res = BeanMapper.map(entity, PurchaseChangeVO.class);
        BigDecimal contractTaxMny = res.getContractTaxMny()==null?BigDecimal.ZERO:res.getContractTaxMny();
        BigDecimal beforeChangeTaxMny = pcentity.getBeforeChangeTaxMny()==null?BigDecimal.ZERO:pcentity.getBeforeChangeTaxMny();
        BigDecimal bb = contractTaxMny.subtract(beforeChangeTaxMny);
        if(bb.compareTo(BigDecimal.ZERO)!=0&&beforeChangeTaxMny.compareTo(BigDecimal.ZERO)!=0){
            res.setScale(new BigDecimal(100).multiply(bb.divide(beforeChangeTaxMny,8,ROUND_HALF_DOWN)));
        }else{
            res.setScale(BigDecimal.ZERO);
        }
        res.setBb(bb);
        return CommonResponse.success(res);
    }

    @Override
    public PurchaseChangeVO queryDetail(Long id) {
        PurchaseChangeEntity entity = super.selectById(id);
        PurchaseChangeVO purchaseChangeVo = BeanMapper.map(entity, PurchaseChangeVO.class);
        BigDecimal contractTaxMny = purchaseChangeVo.getContractTaxMny()==null?BigDecimal.ZERO:purchaseChangeVo.getContractTaxMny();
        BigDecimal beforeChangeTaxMny = purchaseChangeVo.getBeforeChangeTaxMny()==null?BigDecimal.ZERO:purchaseChangeVo.getBeforeChangeTaxMny();
        BigDecimal bb = contractTaxMny.subtract(beforeChangeTaxMny);
        if(bb.compareTo(BigDecimal.ZERO)!=0&&beforeChangeTaxMny.compareTo(BigDecimal.ZERO)!=0){
            purchaseChangeVo.setScale(new BigDecimal(100).multiply(bb.divide(beforeChangeTaxMny,8,ROUND_HALF_DOWN)));
        }else{
            purchaseChangeVo.setScale(BigDecimal.ZERO);
        }
        purchaseChangeVo.setBb(bb);
        return purchaseChangeVo;
    }

    @Override
    public PurchaseChangeVO queryDetails(Long id) {
        PurchaseContractEntity entity = purchaseContractService.selectById(id);
        PurchaseChangeVO purchaseChangeVo = BeanMapper.map(entity, PurchaseChangeVO.class);
        //新增逻辑处理
        purchaseChangeVo.setContractId(purchaseChangeVo.getId());
        //新增即点变更按钮穿透过来，此时ID为合同id
        purchaseChangeVo.setId(IdWorker.getId());
        purchaseChangeVo.setBillState(null);
        purchaseChangeVo.setCreateUserCode(null);
        purchaseChangeVo.setCreateTime(null);
        purchaseChangeVo.setUpdateUserCode(null);
        purchaseChangeVo.setUpdateTime(null);
        purchaseChangeVo.setChangeDate(new Date());
        purchaseChangeVo.setBeforeContractName(entity.getContractName());
        purchaseChangeVo.setBeforeChangeMny(entity.getContractMny());
        purchaseChangeVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
        purchaseChangeVo.setBeforeContractName(purchaseChangeVo.getContractName());

        List<PurchaseContractDetailEntity> details = null;
        LambdaQueryWrapper<PurchaseContractDetailEntity> lambda = Wrappers.<PurchaseContractDetailEntity>lambdaQuery();
        lambda.eq(PurchaseContractDetailEntity::getContractId,id);
        lambda.ne(PurchaseContractDetailEntity::getChangeType,"3");
        details = purchaseContractDetailService.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            purchaseChangeVo.setPurchasedetail(BeanMapper.mapList(details,PurchaseChangeDetailVO.class));
            purchaseChangeVo.getPurchasedetail().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setChangeType("4");
                vo.setRowState("add");
//                vo.setId(null);
            });
        }else{
            purchaseChangeVo.setPurchasedetail(null);
        }
        if(CollectionUtils.isNotEmpty(purchaseChangeVo.getPurchasefee())){
            purchaseChangeVo.getPurchasefee().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
//                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(purchaseChangeVo.getPurchaseclause())){
            purchaseChangeVo.getPurchaseclause().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
//                vo.setId(null);
            });
        }
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id),"BT200528000000001","purchaseContractBill", String.valueOf(purchaseChangeVo.getId()), "BT200604000000001","102345678");

        return purchaseChangeVo;
    }

    @Override
    public PurchaseChangeRecordVO queryChangeRecord(Long id) {
        PurchaseChangeRecordVO vo = new PurchaseChangeRecordVO();
        PurchaseContractEntity entity = purchaseContractService.selectById(id);
        BigDecimal baseTaxMoney = entity.getBaseTaxMoney()==null?BigDecimal.ZERO:entity.getBaseTaxMoney();
        BigDecimal contractTaxMny = entity.getContractTaxMny()==null?BigDecimal.ZERO:entity.getContractTaxMny();
        vo.setBaseTaxMoney(baseTaxMoney);
        vo.setContractId(id);
        vo.setContractTaxMny(contractTaxMny);
        vo.setSumChangeMny(contractTaxMny.subtract(baseTaxMoney));
        vo.setContractStatus(entity.getContractStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        if(vo.getSumChangeMny().compareTo(BigDecimal.ZERO)!=0&&baseTaxMoney.compareTo(BigDecimal.ZERO)!=0){
            vo.setSumScale(new BigDecimal(100).multiply(vo.getSumChangeMny().divide(baseTaxMoney,8,ROUND_HALF_DOWN)));
        }else{
            vo.setSumScale(BigDecimal.ZERO);
        }

        if(entity.getChangeVersion()>0){
            //合同版本号>0说明会有变更记录
            LambdaQueryWrapper<PurchaseChangeEntity> lambda = Wrappers.<PurchaseChangeEntity>lambdaQuery();
            lambda.eq(PurchaseChangeEntity::getContractId,id);
            lambda.in(PurchaseChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
            lambda.orderByDesc(PurchaseChangeEntity::getChangeTime);
            List<PurchaseChangeEntity> entities = super.list(lambda);
//            entities.forEach(changevo -> {
//                if(changevo.getChangeVersion()<10){
//                    changevo.setBillCode(changevo.getBillCode()+"-0"+changevo.getChangeVersion());
//                }else{
//                    changevo.setBillCode(changevo.getBillCode()+"-"+changevo.getChangeVersion());
//                }
//              }
//            );
            vo.setChangeRecord(BeanMapper.mapList(entities, PurchaseChangeVO.class));
        }
        return vo;
    }

    @Override
    public void deletePurchaseChange(List<PurchaseChangeVO> vos) {
        PurchaseChangeVO purchaseChangeVo = vos.get(0);
        PurchaseChangeEntity entity = super.selectById(purchaseChangeVo.getId());
        //合同变更只有详情页有删除
        PurchaseContractEntity pcentity = purchaseContractService.selectById(entity.getContractId());
        //会写合同表
        pcentity.setId(entity.getContractId());
        pcentity.setChangeVersion(pcentity.getChangeVersion()-1);
        pcentity.setChangeStatus(1);
        pcentity.setChangingMny(BigDecimal.ZERO);//修改变更中金额
        pcentity.setChangingTaxMny(BigDecimal.ZERO);
        pcentity.setChangeCode(null);
        pcentity.setChangeId(null);
        purchaseContractService.update(pcentity, new QueryWrapper<PurchaseContractEntity>().eq("id",pcentity.getId()),false);
        super.removeByIds(vos.stream().map(PurchaseChangeVO::getId).collect(Collectors.toList()),false);
    }


    @Override
    public BigDecimal totalContractMny(PurchaseChangeVO vo){
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        QueryWrapper<PurchaseContractEntity> queryPro = new QueryWrapper<>();
        queryPro.eq("project_Id",vo.getProjectId());
//        queryPro.in("bill_state", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode()));
//        queryPro.eq("contract_status",2);
        queryPro.in("change_status",Arrays.asList(1,3));
        if (vo.getContractId()!=null){
            queryPro.ne("id",vo.getContractId());
        }
        queryPro.select("sum(contract_tax_mny) as contractTaxMny");
        PurchaseContractEntity one = purchaseContractService.getOne(queryPro);
        if(one!=null &&null != one.getContractTaxMny()&&!"0".equals(one.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(one.getContractTaxMny());
        }
        //统计变更中的金额
        QueryWrapper<PurchaseChangeEntity> changeQuery = new QueryWrapper<>();
        changeQuery.eq("project_Id", vo.getProjectId());
        if (vo.getId()!=null){
            changeQuery.ne("id",vo.getId());
        }
        if (vo.getContractTaxMny()!=null){
            contractTaxMny =contractTaxMny.add(vo.getContractTaxMny());
        }
        changeQuery.in("bill_state", Arrays.asList(
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        changeQuery.select("sum(contract_tax_mny) as contractTaxMny");
        PurchaseChangeEntity changeEntity = super.getOne(changeQuery);
        if(changeEntity!=null &&null != changeEntity.getContractTaxMny()&&!"0".equals(changeEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(changeEntity.getContractTaxMny());
        }
        return  contractTaxMny;
    }

    @Override
    public ParamsCheckVO checkParams(PurchaseChangeVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        //获取 预算机械费总金额
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType());
        CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(requestVo);
        logger.info("预算机械费总金额 返回内容:{}", JSONObject.toJSONString(res));
        if (!res.isSuccess()){
            throw new BusinessException("网络错误"+res.getMsg());
        }
        // 没有预算不控制，预算不包含不控制
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO data = res.getData();
            //      预算机械费总金额
            BigDecimal budgetTaxMny =  data.getMechanicalTaxMny()==null ? BigDecimal.ZERO : data.getMechanicalTaxMny();
            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, curOrgId);
            if (!response.isSuccess()) {
                throw new BusinessException("【预算机械费总金额】控 【设备合同总金额】，获取控制参数失败，失败原因：" + response.getMsg());
            }
            //设备采购总金额
            BigDecimal purchaseContractTaxMny = totalContractMny(vo);
            //设备租赁总金额
            RentContractVO rentContract = new RentContractVO();
            rentContract.setProjectId(vo.getProjectId());
            BigDecimal rentContractTaxMny = rentContractService.totalContractMny(rentContract);
            BigDecimal totalContractMny = purchaseContractTaxMny.add(rentContractTaxMny);
            List<BillParamVO> billParamVOS = response.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                        logger.info("预算机械费总金额 :{},设置金额:{}", JSONObject.toJSONString(budgetTaxMnyResult),JSONObject.toJSONString(totalContractMny));
                        // 设备合同总金额 和 预算机械费总金额
                        if (totalContractMny.compareTo(budgetTaxMnyResult) > 0) {
                            // 超出金额 = 设备合同总金额 - 预算机械费总金额 * X%
                            BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            // 设备合同总金额：{}元，预算机械费总金额
                            paramsCheckDsVO.setWarnItem("设备合同总金额超预算机械费总金额");
                            paramsCheckDsVO.setWarnName("设备合同总金额大于预算机械费总金额 * " + roleValue + "%");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("设备合同总金额：")
                                    .append(totalContractMny.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，预算机械费总金额 * ")
                                    .append(roleValue).append("%：")
                                    .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，超出金额：")
                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                    .append("元。");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }

                }
            }
            // 【项目预算总金额】控【项目总支出金额】
            //项目总预算金额
            BigDecimal allBudgetTaxMny = res.getData().getBudgetTaxMny() == null ? BigDecimal.ZERO : res.getData().getBudgetTaxMny();
            CommonResponse<List<BillParamVO>> responseBudge = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_BUDGE_MNY, InvocationInfoProxy.getOrgId());

            if (!responseBudge.isSuccess()) {
                throw new BusinessException(" 项目总支出金额超项目总预算金额，获取控制参数失败，失败原因：" + responseBudge.getMsg());
            }
            List<BillParamVO> billParamVOSBudge = responseBudge.getData();
            if (CollectionUtils.isNotEmpty(billParamVOSBudge)) {
                //获取项目总支出金额
                BigDecimal totalOutMny = vo.getContractTaxMny();
                CommonResponse<Map<String, BigDecimal>> proOutMnyCommonResponse = budgetProjectProApi.getProOutMny(vo.getProjectId(), vo.getContractId(), BillTypeCodeEnum.设备采购合同.getBillTypeCode());
                logger.info(" 项目总支出金额不含本次 返回内容:{}", JSONObject.toJSONString(proOutMnyCommonResponse));
                if (!proOutMnyCommonResponse.isSuccess()) {
                    throw new BusinessException(proOutMnyCommonResponse.getMsg());
                }
                totalOutMny = totalOutMny.add(proOutMnyCommonResponse.getData().get("TaxMny"));
                for (BillParamVO billParamVO : billParamVOSBudge) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetTaxMnyResult = allBudgetTaxMny.multiply(scale);
                        // 项目总支出金额超项目总预算金额
                        logger.info("项目总支出金额:{},项目总预算金额:{}", JSONObject.toJSONString(totalOutMny), JSONObject.toJSONString(budgetTaxMnyResult));

                        if (totalOutMny.compareTo(budgetTaxMnyResult) > 0) {
                            // 超出金额 = 项目总支出金额 - 项目预算总金额 * X%
                            BigDecimal over = totalOutMny.subtract(budgetTaxMnyResult);

                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());

                            paramsCheckDsVO.setWarnItem("项目总支出金额超项目总预算金额");
                            paramsCheckDsVO.setWarnName("项目总支出金额超项目总预算金额");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("项目总支出金额：")
                                    .append(totalOutMny.setScale(2, RoundingMode.HALF_UP))
                                    .append("元， 项目预算总金额 * ")
                                    .append(com.ejianc.framework.core.util.ComputeUtil.scaleStripTrailingZeros(roleValue, 8)).append("%：")
                                    .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，超出金额：")
                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                    .append("元。");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
        }

        // 施工合同金额控制支出
        CommonResponse<List<BillParamVO>> sghtkzc = paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, curOrgId);
        if (sghtkzc.isSuccess() && null != sghtkzc.getData()) {
            List<BillParamVO> billParamVOS = sghtkzc.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                BigDecimal sjzcje = this.getSjzcje(vo.getId(), vo.getContractId(), vo.getProjectId(), vo.getContractTaxMny());
                CommonResponse<BigDecimal> res996 = incomeContractApi.fetchSghtzje(vo.getProjectId());
                if (!res996.isSuccess()) {
                    throw new BusinessException("获取施工合同工总金额失败");
                }
                BigDecimal sght = res996.getData();
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = NumberUtil.div(roleValue, new BigDecimal("100"), 8);
                        BigDecimal sghtzje = NumberUtil.mul(sght, scale);
                        if (sjzcje.compareTo(sghtzje) > 0) {
//                            controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("该项目支出汇总金额：")
                                    .append(sjzcje.setScale(2, RoundingMode.HALF_UP))
                                    .append("，施工合同工总金额*")
                                    .append(roleValue)
                                    .append("%：")
                                    .append(sghtzje.setScale(2, RoundingMode.HALF_UP))
                                    .append("，超出金额：")
                                    .append(com.ejianc.framework.core.util.ComputeUtil.safeSub(sjzcje, sghtzje).setScale(2, RoundingMode.HALF_UP));
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem("支出汇总金额超施工合同总金额");
                            paramsCheckDsVO.setWarnName("支出汇总金额大于施工合同总金额");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
//                            checkDsVOS.add(paramsCheckDsVO);
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
        }


        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }


    private BigDecimal getSjzcje(Long changeId, Long contractId, Long projectId, BigDecimal mny) {
        CommonResponse<BigDecimal> fbCommonResponse = subContractApi.fetchSjzcje(projectId);
        if (!fbCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "分包" + "实际支出金额失败");
        }
        BigDecimal fb = fbCommonResponse.getData();
        CommonResponse<BigDecimal> wzCommonResponse = materialContractApi.fetchSjzcje(projectId);
        if (!wzCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "物资" + "实际支出金额失败");
        }
        BigDecimal wz = wzCommonResponse.getData();
        CommonResponse<BigDecimal> zzcCommonResponse = rmatContractApi.fetchSjzcje(projectId);
        if (!zzcCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "周转材" + "实际支出金额失败");
        }
        BigDecimal zzc = zzcCommonResponse.getData();
        BigDecimal sbcg = purchaseContractMapper.fetchSjzcje(projectId, changeId, contractId);
        BigDecimal sbzl = rentContractMapper.fetchSjzcje(projectId, null, null);
        CommonResponse<BigDecimal> qtCommonResponse = otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "其他" + "实际支出金额失败");
        }
        BigDecimal qt = qtCommonResponse.getData();
        CommonResponse<BigDecimal> fybxCommonResponse = financePayReimburseApi.fetchSjzcje(projectId);
        if (!fybxCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "费用报销" + "实际支出金额失败");
        }
        BigDecimal fybx = fybxCommonResponse.getData();
        CommonResponse<BigDecimal> lxCommonResponse = financePaySporadicApi.fetchSjzcje(projectId);
        if (!lxCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "零星" + "实际支出金额失败");
        }
        BigDecimal lx = lxCommonResponse.getData();
        CommonResponse<BigDecimal> yjCommonResponse = financeLoadReimburseApi.fetchSjzcje(projectId);
        if (!yjCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "备用金" + "实际支出金额失败");
        }
        BigDecimal yj = yjCommonResponse.getData();
        return NumberUtil.add(mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj);
    }

    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

}
