package com.ejianc.business.equipment.service;

import com.ejianc.business.equipment.bean.PurchaseChangeEntity;
import com.ejianc.business.equipment.vo.ParamsCheckVO;
import com.ejianc.business.equipment.vo.PurchaseChangeRecordVO;
import com.ejianc.business.equipment.vo.PurchaseChangeVO;
import com.ejianc.business.equipment.vo.PurchaseContractVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 设备合同变更表 服务类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
public interface IPurchaseChangeService extends IBaseService<PurchaseChangeEntity> {

    /**
     * 保存或修改信息
     *
     * @param PurchaseChangeVo
     * @return
     */
    CommonResponse<PurchaseChangeVO> saveOrUpdate(PurchaseChangeVO PurchaseChangeVo);

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    PurchaseChangeVO queryDetail(Long id);

    /**
     * 删除信息
     *
     * @param vos
     */
    void deletePurchaseChange(List<PurchaseChangeVO> vos);

    PurchaseChangeVO queryDetails(Long id);

    PurchaseChangeRecordVO queryChangeRecord(Long id);

    BigDecimal totalContractMny(PurchaseChangeVO vo);
    /**
     * 参数控制
     *
     * @param vo 预算机械费总金额  设备采购总金额
     *
     * @return {@link ParamsCheckVO}
     */
    ParamsCheckVO checkParams(PurchaseChangeVO vo);

}
