/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.equipment.bean.PurchaseChangeEntity;
import com.ejianc.business.equipment.bean.PurchaseContractDetailEntity;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.mapper.PurchaseChangeMapper;
import com.ejianc.business.equipment.mapper.PurchaseContractMapper;
import com.ejianc.business.equipment.mapper.RentContractMapper;
import com.ejianc.business.equipment.service.IPurchaseChangeService;
import com.ejianc.business.equipment.service.IPurchaseContractDetailService;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.vo.ParamsCheckDsVO;
import com.ejianc.business.equipment.vo.ParamsCheckVO;
import com.ejianc.business.equipment.vo.PurchaseChangeDetailVO;
import com.ejianc.business.equipment.vo.PurchaseChangeRecordVO;
import com.ejianc.business.equipment.vo.PurchaseChangeVO;
import com.ejianc.business.equipment.vo.RentContractVO;
import com.ejianc.business.finance.api.IFinanceLoadReimburseApi;
import com.ejianc.business.finance.api.IFinancePayReimburseApi;
import com.ejianc.business.finance.api.IFinancePaySporadicApi;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="PurchaseChangeService")
public class PurchaseChangeServiceImpl
extends BaseServiceImpl<PurchaseChangeMapper, PurchaseChangeEntity>
implements IPurchaseChangeService {
    private static final String PURCHASE_CHANGE_BILL_CODE = "EQUIPMENT_PURCHASE";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PARAM_TOTAL_MNY = "P-oIwZ5646";
    private static final String PARAM_TOTAL_UNTAX_MNY = "P-4Qavg0101";
    private static final String PARAM_BUDGE_MNY = "P-z3eQ6q89";
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPurchaseChangeService changeService;
    @Autowired
    private IPurchaseContractDetailService purchaseContractDetailService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private PurchaseContractMapper purchaseContractMapper;
    @Autowired
    private RentContractMapper rentContractMapper;
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IFinancePayReimburseApi financePayReimburseApi;
    @Autowired
    private IFinancePaySporadicApi financePaySporadicApi;
    @Autowired
    private IFinanceLoadReimburseApi financeLoadReimburseApi;

    @Override
    public CommonResponse<PurchaseChangeVO> saveOrUpdate(PurchaseChangeVO purchaseChangeVo) {
        QueryParam queryParam;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseChangeEntity entity = null;
        List entitiesc = null;
        List entities = null;
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(PurchaseChangeEntity::getContractId, (Object)purchaseChangeVo.getContractId());
        if (purchaseChangeVo.getId() != null && purchaseChangeVo.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)purchaseChangeVo.getId());
        }
        lambdachange.ne(PurchaseChangeEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(PurchaseChangeEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        PurchaseContractEntity pcentity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(purchaseChangeVo.getContractId()));
        if (StringUtils.isEmpty((CharSequence)purchaseChangeVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PURCHASE_CHANGE_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                purchaseChangeVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (purchaseChangeVo.getId() != null && purchaseChangeVo.getId() > 0L && this.changeService.getById(purchaseChangeVo.getId()) != null) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(PurchaseChangeEntity::getBillCode, (Object)purchaseChangeVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(PurchaseChangeEntity::getContractId, (Object)purchaseChangeVo.getContractId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)purchaseChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)purchaseChangeVo.getContractId()));
            entitiesc = this.purchaseContractService.queryList(queryParam, false);
            pcentity.setId(purchaseChangeVo.getContractId());
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(PurchaseChangeEntity::getBillCode, (Object)purchaseChangeVo.getBillCode());
            lambda.ne(PurchaseChangeEntity::getContractId, (Object)purchaseChangeVo.getContractId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)purchaseChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)purchaseChangeVo.getContractId()));
            entitiesc = this.purchaseContractService.queryList(queryParam, false);
            pcentity.setId(purchaseChangeVo.getContractId());
            pcentity.setChangeVersion(purchaseChangeVo.getChangeVersion() + 1);
            purchaseChangeVo.setChangeVersion(Integer.valueOf(purchaseChangeVo.getChangeVersion() + 1));
            purchaseChangeVo.setMakeTime(new Date());
        }
        if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getPurchasedetail())) {
            purchaseChangeVo.getPurchasedetail().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(purchaseChangeVo.getContractId());
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getPurchasefee())) {
            purchaseChangeVo.getPurchasefee().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(purchaseChangeVo.getContractId());
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getPurchaseclause())) {
            purchaseChangeVo.getPurchaseclause().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(purchaseChangeVo.getContractId());
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)entities) || CollectionUtils.isNotEmpty((Collection)entitiesc)) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity = (PurchaseChangeEntity)((Object)BeanMapper.map((Object)purchaseChangeVo, PurchaseChangeEntity.class));
        super.saveOrUpdate((Object)entity, false);
        pcentity.setChangeStatus(2);
        pcentity.setChangingMny(entity.getContractMny());
        pcentity.setChangingTaxMny(entity.getContractTaxMny());
        pcentity.setChangeCode(entity.getBillCode());
        pcentity.setChangeId(entity.getId());
        this.purchaseContractService.update((Object)pcentity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)pcentity.getId()), false);
        PurchaseChangeVO res = (PurchaseChangeVO)BeanMapper.map((Object)((Object)entity), PurchaseChangeVO.class);
        BigDecimal contractTaxMny = res.getContractTaxMny() == null ? BigDecimal.ZERO : res.getContractTaxMny();
        BigDecimal beforeChangeTaxMny = pcentity.getBeforeChangeTaxMny() == null ? BigDecimal.ZERO : pcentity.getBeforeChangeTaxMny();
        BigDecimal bb = contractTaxMny.subtract(beforeChangeTaxMny);
        if (bb.compareTo(BigDecimal.ZERO) != 0 && beforeChangeTaxMny.compareTo(BigDecimal.ZERO) != 0) {
            res.setScale(new BigDecimal(100).multiply(bb.divide(beforeChangeTaxMny, 8, 5)));
        } else {
            res.setScale(BigDecimal.ZERO);
        }
        res.setBb(bb);
        return CommonResponse.success((Object)res);
    }

    @Override
    public PurchaseChangeVO queryDetail(Long id) {
        BigDecimal beforeChangeTaxMny;
        PurchaseChangeEntity entity = (PurchaseChangeEntity)((Object)super.selectById((Serializable)id));
        PurchaseChangeVO purchaseChangeVo = (PurchaseChangeVO)BeanMapper.map((Object)((Object)entity), PurchaseChangeVO.class);
        BigDecimal contractTaxMny = purchaseChangeVo.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseChangeVo.getContractTaxMny();
        BigDecimal bb = contractTaxMny.subtract(beforeChangeTaxMny = purchaseChangeVo.getBeforeChangeTaxMny() == null ? BigDecimal.ZERO : purchaseChangeVo.getBeforeChangeTaxMny());
        if (bb.compareTo(BigDecimal.ZERO) != 0 && beforeChangeTaxMny.compareTo(BigDecimal.ZERO) != 0) {
            purchaseChangeVo.setScale(new BigDecimal(100).multiply(bb.divide(beforeChangeTaxMny, 8, 5)));
        } else {
            purchaseChangeVo.setScale(BigDecimal.ZERO);
        }
        purchaseChangeVo.setBb(bb);
        return purchaseChangeVo;
    }

    @Override
    public PurchaseChangeVO queryDetails(Long id) {
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(id));
        PurchaseChangeVO purchaseChangeVo = (PurchaseChangeVO)BeanMapper.map((Object)((Object)entity), PurchaseChangeVO.class);
        purchaseChangeVo.setContractId(purchaseChangeVo.getId());
        purchaseChangeVo.setId(Long.valueOf(IdWorker.getId()));
        purchaseChangeVo.setBillState(null);
        purchaseChangeVo.setCreateUserCode(null);
        purchaseChangeVo.setCreateTime(null);
        purchaseChangeVo.setUpdateUserCode(null);
        purchaseChangeVo.setUpdateTime(null);
        purchaseChangeVo.setChangeDate(new Date());
        purchaseChangeVo.setBeforeContractName(entity.getContractName());
        purchaseChangeVo.setBeforeChangeMny(entity.getContractMny());
        purchaseChangeVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
        purchaseChangeVo.setBeforeContractName(purchaseChangeVo.getContractName());
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PurchaseContractDetailEntity::getContractId, (Object)id);
        lambda.ne(PurchaseContractDetailEntity::getChangeType, (Object)"3");
        details = this.purchaseContractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            purchaseChangeVo.setPurchasedetail(BeanMapper.mapList((Iterable)details, PurchaseChangeDetailVO.class));
            purchaseChangeVo.getPurchasedetail().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setChangeType("4");
                vo.setRowState("add");
            });
        } else {
            purchaseChangeVo.setPurchasedetail(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getPurchasefee())) {
            purchaseChangeVo.getPurchasefee().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getPurchaseclause())) {
            purchaseChangeVo.getPurchaseclause().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
            });
        }
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "BT200528000000001", "purchaseContractBill", String.valueOf(purchaseChangeVo.getId()), "BT200604000000001", "102345678");
        return purchaseChangeVo;
    }

    @Override
    public PurchaseChangeRecordVO queryChangeRecord(Long id) {
        PurchaseChangeRecordVO vo = new PurchaseChangeRecordVO();
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(id));
        BigDecimal baseTaxMoney = entity.getBaseTaxMoney() == null ? BigDecimal.ZERO : entity.getBaseTaxMoney();
        BigDecimal contractTaxMny = entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny();
        vo.setBaseTaxMoney(baseTaxMoney);
        vo.setContractId(id);
        vo.setContractTaxMny(contractTaxMny);
        vo.setSumChangeMny(contractTaxMny.subtract(baseTaxMoney));
        vo.setContractStatus(entity.getContractStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        if (vo.getSumChangeMny().compareTo(BigDecimal.ZERO) != 0 && baseTaxMoney.compareTo(BigDecimal.ZERO) != 0) {
            vo.setSumScale(new BigDecimal(100).multiply(vo.getSumChangeMny().divide(baseTaxMoney, 8, 5)));
        } else {
            vo.setSumScale(BigDecimal.ZERO);
        }
        if (entity.getChangeVersion() > 0) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(PurchaseChangeEntity::getContractId, (Object)id);
            lambda.in(PurchaseChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            lambda.orderByDesc(PurchaseChangeEntity::getChangeTime);
            List entities = super.list((Wrapper)lambda);
            vo.setChangeRecord(BeanMapper.mapList((Iterable)entities, PurchaseChangeVO.class));
        }
        return vo;
    }

    @Override
    public void deletePurchaseChange(List<PurchaseChangeVO> vos) {
        PurchaseChangeVO purchaseChangeVo = vos.get(0);
        PurchaseChangeEntity entity = (PurchaseChangeEntity)((Object)super.selectById((Serializable)purchaseChangeVo.getId()));
        PurchaseContractEntity pcentity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(entity.getContractId()));
        pcentity.setId(entity.getContractId());
        pcentity.setChangeVersion(pcentity.getChangeVersion() - 1);
        pcentity.setChangeStatus(1);
        pcentity.setChangingMny(BigDecimal.ZERO);
        pcentity.setChangingTaxMny(BigDecimal.ZERO);
        pcentity.setChangeCode(null);
        pcentity.setChangeId(null);
        this.purchaseContractService.update((Object)pcentity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)pcentity.getId()), false);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public BigDecimal totalContractMny(PurchaseChangeVO vo) {
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        QueryWrapper queryPro = new QueryWrapper();
        queryPro.eq((Object)"project_Id", (Object)vo.getProjectId());
        queryPro.in((Object)"change_status", Arrays.asList(1, 3));
        if (vo.getContractId() != null) {
            queryPro.ne((Object)"id", (Object)vo.getContractId());
        }
        queryPro.select(new String[]{"sum(contract_tax_mny) as contractTaxMny"});
        PurchaseContractEntity one = (PurchaseContractEntity)((Object)this.purchaseContractService.getOne((Wrapper)queryPro));
        if (one != null && null != one.getContractTaxMny() && !"0".equals(one.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(one.getContractTaxMny());
        }
        QueryWrapper changeQuery = new QueryWrapper();
        changeQuery.eq((Object)"project_Id", (Object)vo.getProjectId());
        if (vo.getId() != null) {
            changeQuery.ne((Object)"id", (Object)vo.getId());
        }
        if (vo.getContractTaxMny() != null) {
            contractTaxMny = contractTaxMny.add(vo.getContractTaxMny());
        }
        changeQuery.in((Object)"bill_state", Arrays.asList(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        changeQuery.select(new String[]{"sum(contract_tax_mny) as contractTaxMny"});
        PurchaseChangeEntity changeEntity = (PurchaseChangeEntity)((Object)super.getOne((Wrapper)changeQuery));
        if (changeEntity != null && null != changeEntity.getContractTaxMny() && !"0".equals(changeEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(changeEntity.getContractTaxMny());
        }
        return contractTaxMny;
    }

    public BigDecimal totalContractMnyUntax(PurchaseChangeVO vo) {
        BigDecimal contractMny = BigDecimal.ZERO;
        QueryWrapper queryPro = new QueryWrapper();
        queryPro.eq((Object)"project_Id", (Object)vo.getProjectId());
        queryPro.in((Object)"change_status", Arrays.asList(1, 3));
        if (vo.getContractId() != null) {
            queryPro.ne((Object)"id", (Object)vo.getContractId());
        }
        queryPro.select(new String[]{"sum(contract_mny) as contractMny"});
        PurchaseContractEntity one = (PurchaseContractEntity)((Object)this.purchaseContractService.getOne((Wrapper)queryPro));
        if (one != null && null != one.getContractMny() && !"0".equals(one.getContractMny())) {
            contractMny = contractMny.add(one.getContractMny());
        }
        QueryWrapper changeQuery = new QueryWrapper();
        changeQuery.eq((Object)"project_Id", (Object)vo.getProjectId());
        if (vo.getId() != null) {
            changeQuery.ne((Object)"id", (Object)vo.getId());
        }
        if (vo.getContractTaxMny() != null) {
            contractMny = contractMny.add(vo.getContractMny());
        }
        changeQuery.in((Object)"bill_state", Arrays.asList(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        changeQuery.select(new String[]{"sum(contract_mny) as contractMny"});
        PurchaseChangeEntity changeEntity = (PurchaseChangeEntity)((Object)super.getOne((Wrapper)changeQuery));
        if (changeEntity != null && null != changeEntity.getContractMny() && !"0".equals(changeEntity.getContractMny())) {
            contractMny = contractMny.add(changeEntity.getContractMny());
        }
        return contractMny;
    }

    @Override
    public ParamsCheckVO checkParams(PurchaseChangeVO vo) {
        List billParamVOS;
        CommonResponse sghtkzc;
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType());
        CommonResponse res = this.budgetProjectProApi.fetchQuantityAndMny(requestVo);
        this.logger.info("\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d \u8fd4\u56de\u5185\u5bb9:{}", (Object)JSONObject.toJSONString((Object)res));
        if (!res.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u9519\u8bef" + res.getMsg());
        }
        if (null != res.getData()) {
            CommonResponse response3;
            BudgetProjectProQuantityAndMnyVO data = (BudgetProjectProQuantityAndMnyVO)res.getData();
            BigDecimal budgetTaxMny = data.getMechanicalTaxMny() == null ? BigDecimal.ZERO : data.getMechanicalTaxMny();
            BigDecimal budgetMny = data.getMechanicalMny() == null ? BigDecimal.ZERO : data.getMechanicalMny();
            CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, curOrgId);
            if (!response.isSuccess()) {
                throw new BusinessException("\u3010\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d\u3011\u63a7 \u3010\u8bbe\u5907\u5408\u540c\u603b\u91d1\u989d\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
            }
            BigDecimal purchaseContractTaxMny = this.totalContractMny(vo);
            RentContractVO rentContract = new RentContractVO();
            rentContract.setProjectId(vo.getProjectId());
            BigDecimal rentContractTaxMny = this.rentContractService.totalContractMny(rentContract);
            BigDecimal totalContractMny = purchaseContractTaxMny.add(rentContractTaxMny);
            List billParamVOS2 = (List)response.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS2)) {
                for (BillParamVO billParamVO : billParamVOS2) {
                    if (0 == billParamVO.getControlType()) continue;
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                    BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                    this.logger.info("\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d :{},\u8bbe\u7f6e\u91d1\u989d:{}", (Object)JSONObject.toJSONString((Object)budgetTaxMnyResult), (Object)JSONObject.toJSONString((Object)totalContractMny));
                    if (totalContractMny.compareTo(budgetTaxMnyResult) <= 0) continue;
                    BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("\u8bbe\u5907\u5408\u540c\u603b\u91d1\u989d\u8d85\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d");
                    paramsCheckDsVO.setWarnName("\u8bbe\u5907\u5408\u540c\u603b\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d * " + roleValue + "%");
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u8bbe\u5907\u5408\u540c\u603b\u91d1\u989d\uff1a").append(totalContractMny.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d * ").append(roleValue).append("%\uff1a").append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u5143\u3002");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    PurchaseChangeServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                }
            }
            if (!(response3 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_UNTAX_MNY, curOrgId)).isSuccess()) {
                throw new BusinessException("\u3010\u9884\u7b97\u673a\u68b0\u8d39\u65e0\u7a0e\u603b\u91d1\u989d\u3011\u63a7 \u3010\u8bbe\u5907\u5408\u540c\u65e0\u7a0e\u603b\u91d1\u989d\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response3.getMsg());
            }
            BigDecimal purchaseContractMny = this.totalContractMnyUntax(vo);
            RentContractVO rentContract1 = new RentContractVO();
            rentContract1.setProjectId(vo.getProjectId());
            BigDecimal rentContractMny = this.rentContractService.totalContractMnyUnTax(rentContract1);
            BigDecimal totalContractMnyUntax = purchaseContractMny.add(rentContractMny);
            List billParamVOS3 = (List)response3.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS3)) {
                for (BillParamVO billParamVO : billParamVOS3) {
                    if (0 == billParamVO.getControlType()) continue;
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                    BigDecimal budgetMnyResult = budgetMny.multiply(scale);
                    this.logger.info("\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d :{},\u8bbe\u7f6e\u91d1\u989d:{}", (Object)JSONObject.toJSONString((Object)budgetMnyResult), (Object)JSONObject.toJSONString((Object)totalContractMnyUntax));
                    if (totalContractMnyUntax.compareTo(budgetMnyResult) <= 0) continue;
                    BigDecimal over = totalContractMnyUntax.subtract(budgetMnyResult);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("\u8bbe\u5907\u5408\u540c\u65e0\u7a0e\u603b\u91d1\u989d\u8d85\u9884\u7b97\u673a\u68b0\u8d39\u65e0\u7a0e\u603b\u91d1\u989d");
                    paramsCheckDsVO.setWarnName("\u8bbe\u5907\u5408\u540c\u65e0\u7a0e\u603b\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u673a\u68b0\u8d39\u65e0\u7a0e\u603b\u91d1\u989d * " + roleValue + "%");
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u8bbe\u5907\u5408\u540c\u65e0\u7a0e\u603b\u91d1\u989d\uff1a").append(totalContractMnyUntax.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u9884\u7b97\u673a\u68b0\u8d39\u65e0\u7a0e\u603b\u91d1\u989d * ").append(roleValue).append("%\uff1a").append(budgetMnyResult.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u5143\u3002");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    PurchaseChangeServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                }
            }
            BigDecimal allBudgetTaxMny = ((BudgetProjectProQuantityAndMnyVO)res.getData()).getBudgetTaxMny() == null ? BigDecimal.ZERO : ((BudgetProjectProQuantityAndMnyVO)res.getData()).getBudgetTaxMny();
            CommonResponse responseBudge = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_BUDGE_MNY, InvocationInfoProxy.getOrgId());
            if (!responseBudge.isSuccess()) {
                throw new BusinessException(" \u9879\u76ee\u603b\u652f\u51fa\u91d1\u989d\u8d85\u9879\u76ee\u603b\u9884\u7b97\u91d1\u989d\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + responseBudge.getMsg());
            }
            List billParamVOSBudge = (List)responseBudge.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOSBudge)) {
                BigDecimal totalOutMny = vo.getContractTaxMny();
                CommonResponse proOutMnyCommonResponse = this.budgetProjectProApi.getProOutMny(vo.getProjectId(), vo.getContractId(), BillTypeCodeEnum.\u8bbe\u5907\u91c7\u8d2d\u5408\u540c.getBillTypeCode());
                this.logger.info(" \u9879\u76ee\u603b\u652f\u51fa\u91d1\u989d\u4e0d\u542b\u672c\u6b21 \u8fd4\u56de\u5185\u5bb9:{}", (Object)JSONObject.toJSONString((Object)proOutMnyCommonResponse));
                if (!proOutMnyCommonResponse.isSuccess()) {
                    throw new BusinessException(proOutMnyCommonResponse.getMsg());
                }
                totalOutMny = totalOutMny.add((BigDecimal)((Map)proOutMnyCommonResponse.getData()).get("TaxMny"));
                for (BillParamVO billParamVO : billParamVOSBudge) {
                    if (0 == billParamVO.getControlType()) continue;
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                    BigDecimal budgetTaxMnyResult = allBudgetTaxMny.multiply(scale);
                    this.logger.info("\u9879\u76ee\u603b\u652f\u51fa\u91d1\u989d:{},\u9879\u76ee\u603b\u9884\u7b97\u91d1\u989d:{}", (Object)JSONObject.toJSONString((Object)totalOutMny), (Object)JSONObject.toJSONString((Object)budgetTaxMnyResult));
                    if (totalOutMny.compareTo(budgetTaxMnyResult) <= 0) continue;
                    BigDecimal over = totalOutMny.subtract(budgetTaxMnyResult);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem("\u9879\u76ee\u603b\u652f\u51fa\u91d1\u989d\u8d85\u9879\u76ee\u603b\u9884\u7b97\u91d1\u989d");
                    paramsCheckDsVO.setWarnName("\u9879\u76ee\u603b\u652f\u51fa\u91d1\u989d\u8d85\u9879\u76ee\u603b\u9884\u7b97\u91d1\u989d");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u9879\u76ee\u603b\u652f\u51fa\u91d1\u989d\uff1a").append(totalOutMny.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c \u9879\u76ee\u9884\u7b97\u603b\u91d1\u989d * ").append(ComputeUtil.scaleStripTrailingZeros((BigDecimal)roleValue, (int)8)).append("%\uff1a").append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u5143\u3002");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    PurchaseChangeServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                }
            }
        }
        if ((sghtkzc = this.paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, curOrgId)).isSuccess() && null != sghtkzc.getData() && CollectionUtils.isNotEmpty((Collection)(billParamVOS = (List)sghtkzc.getData()))) {
            BigDecimal sjzcje = this.getSjzcje(vo.getId(), vo.getContractId(), vo.getProjectId(), vo.getContractTaxMny());
            CommonResponse res996 = this.incomeContractApi.fetchSghtzje(vo.getProjectId());
            if (!res996.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u65bd\u5de5\u5408\u540c\u5de5\u603b\u91d1\u989d\u5931\u8d25");
            }
            BigDecimal sght = (BigDecimal)res996.getData();
            for (BillParamVO billParamVO : billParamVOS) {
                BigDecimal roleValue;
                BigDecimal scale;
                BigDecimal sghtzje;
                if (0 == billParamVO.getControlType() || sjzcje.compareTo(sghtzje = NumberUtil.mul((Number)sght, (Number)(scale = NumberUtil.div((Number)(roleValue = billParamVO.getRoleValue()), (Number)new BigDecimal("100"), (int)8)))) <= 0) continue;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u8be5\u9879\u76ee\u652f\u51fa\u6c47\u603b\u91d1\u989d\uff1a").append(sjzcje.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u65bd\u5de5\u5408\u540c\u5de5\u603b\u91d1\u989d*").append(roleValue).append("%\uff1a").append(sghtzje.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)sjzcje, (BigDecimal)sghtzje).setScale(2, RoundingMode.HALF_UP));
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                paramsCheckDsVO.setWarnItem("\u652f\u51fa\u6c47\u603b\u91d1\u989d\u8d85\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d");
                paramsCheckDsVO.setWarnName("\u652f\u51fa\u6c47\u603b\u91d1\u989d\u5927\u4e8e\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                PurchaseChangeServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }

    private BigDecimal getSjzcje(Long changeId, Long contractId, Long projectId, BigDecimal mny) {
        CommonResponse fbCommonResponse = this.subContractApi.fetchSjzcje(projectId);
        if (!fbCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5206\u5305\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal fb = (BigDecimal)fbCommonResponse.getData();
        CommonResponse wzCommonResponse = this.materialContractApi.fetchSjzcje(projectId);
        if (!wzCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7269\u8d44\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal wz = (BigDecimal)wzCommonResponse.getData();
        CommonResponse zzcCommonResponse = this.rmatContractApi.fetchSjzcje(projectId);
        if (!zzcCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5468\u8f6c\u6750\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal zzc = (BigDecimal)zzcCommonResponse.getData();
        BigDecimal sbcg = this.purchaseContractMapper.fetchSjzcje(projectId, changeId, contractId);
        BigDecimal sbzl = this.rentContractMapper.fetchSjzcje(projectId, null, null);
        CommonResponse qtCommonResponse = this.otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5176\u4ed6\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal qt = (BigDecimal)qtCommonResponse.getData();
        CommonResponse fybxCommonResponse = this.financePayReimburseApi.fetchSjzcje(projectId);
        if (!fybxCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8d39\u7528\u62a5\u9500\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal fybx = (BigDecimal)fybxCommonResponse.getData();
        CommonResponse lxCommonResponse = this.financePaySporadicApi.fetchSjzcje(projectId);
        if (!lxCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u96f6\u661f\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal lx = (BigDecimal)lxCommonResponse.getData();
        CommonResponse yjCommonResponse = this.financeLoadReimburseApi.fetchSjzcje(projectId);
        if (!yjCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5907\u7528\u91d1\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal yj = (BigDecimal)yjCommonResponse.getData();
        return NumberUtil.add((BigDecimal[])new BigDecimal[]{mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj});
    }

    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
}

